<?php
@session_start();
include('includes/config.php');

$show_alert = false;
$alert_type = '';
$alert_message = '';

if(isset($_POST['submit']) && !empty($_POST['username'])){
    $U = mysqli_real_escape_string($tng_conn, $_POST['username']);

    // Prevent admin reset
    if(strtolower($U) == "admin"){
        $show_alert = true; 
        $alert_type = 'error';
        $alert_message = "You are not authorized to reset  admin password.";
    } else {
        $Q = mysqli_query($tng_conn, "SELECT * FROM users WHERE phone='$U' OR email='$U'");

        if(mysqli_num_rows($Q) == 1){
            $D = mysqli_fetch_assoc($Q);

            if($D['status'] == 1){
                // Generate new password
                $NP = rand(10000000, 99999999);
                $HP = password_hash($NP, PASSWORD_DEFAULT);
                date_default_timezone_set("Asia/Kolkata");
                $TS = date('Y-m-d H:i:s');

                $IQ = mysqli_query($tng_conn, "UPDATE users SET password='$HP', date='$TS' WHERE phone='$U' OR email='$U'");

                if($IQ){
                    $WN = XyZ_val('brand');
                    $SV = $_SERVER['SERVER_NAME'];
                    $PP = "https://cdn.pixabay.com/animation/2022/07/31/05/09/05-09-53-216_512.gif";

                    $MSG = "🔒 Hello " . $D['name'] . "!\n\n"
                         . "🆕 Your new password is: *" . $NP . "*\n"
                         . "🌐 Login now: https://$SV\n\n" 
                         . "✨ Keep it safe and secure!";

                   
                        sendWhatsAppMessage($D['phone'], $MSG, $SV);
                    

                    $BODY = generatePasswordResetEmail($D['name'], $NP, $WN, $SV, $PP);
                    SendMail($D['email'], "Password Reset Successful", $BODY);
                    
                    $show_alert = true;
                    $alert_type = 'success';
                    $alert_message = "Password reset successfully. New password sent via email.";

                } else {
                    $show_alert = true;
                    $alert_type = 'error';
                    $alert_message = "Failed to update password. Please try again.";
                }

            } else {
                $show_alert = true;
                $alert_type = 'error';
                $alert_message = "Account not active. Contact support.";
            }

        } else {
            $show_alert = true;
            $alert_type = 'error';
            $alert_message = "Email or phone not registered.";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="./template/tngweb/assets/images/favicon-32x32.png" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
    <script disable-devtool-auto src='https://cdn.jsdelivr.net/npm/disable-devtool@latest'></script>
    <title><?php echo XyZ_val('brand'); ?> | <?php echo XyZ_val('title'); ?></title>
    <link href="./template/tngweb/assets/css/forget-reset-style.css" rel="stylesheet">
 
</head>

<body>
    <!-- Alert Container -->
    <?php if ($show_alert): ?>
    <div class="alert-container">
        <div class="alert alert-<?php echo $alert_type; ?>">
            <?php echo $alert_message; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <a href="index.php" class="logo">
                <img src="<?php echo XyZ_val('logo'); ?>" alt="Logo">
                <?php echo XyZ_val('brand'); ?>
            </a>
            
            <button class="mobile-toggle" id="mobileToggle">
                <i class='bx bx-menu'></i>
            </button>
            
            <ul class="nav-links" id="navLinks">
                <li><a href="index.php">Home</a></li>
                <?php if (XyZ_val('register_status') === 'active'): ?>
                <li><a href="register.php">Register</a></li>
                <?php endif; ?>
                <li><a href="Forgot-password.php" class="active">Forgot Password</a></li>
                <li><a href="contact.php">Contact</a></li>
            </ul>
        </div>
    </nav>

    <!-- Forgot Password Content -->
    <div class="forgot-container">
        <div class="forgot-card">
            <div class="forgot-header">
                <i class='bx bx-lock-alt forgot-icon'></i>
                <h1>Reset Your Password</h1>
                <p>Enter your email or phone to receive reset instructions</p>
            </div>
            
            <div class="forgot-body">
                <div class="instructions">
                    <p>Enter the email address or phone number associated with your account, and we'll send you a new password via email<?php echo (XyZ_val('otp_option') === "yes" ? ' and WhatsApp' : ''); ?>.</p>
                </div>
                
                <form method="POST" action="">
                    <div class="form-group">
                        <label for="inputEmailAddress" class="form-label">Email or Phone *</label>
                        <input name="username" type="text" class="form-control" id="inputEmailAddress" placeholder="Enter your email or phone number" required value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
                    </div>
                    
                    <button type="submit" name="submit" class="submit-btn" id="submitBtn">
                        <i class='bx bx-send'></i> Reset Password
                    </button>
                    
                    <div class="back-to-login">
                        Remember your password? <a href="login.php">Back to Login</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date("Y"); ?> <?php echo strtoupper($_SERVER['SERVER_NAME']); ?>. All rights reserved.</p>
        </div>
    </footer>
 
    <script>
        $(document).ready(function () {
            $("#show_hide_password a").on('click', function (event) {
                event.preventDefault();
                if ($('#show_hide_password input').attr("type") == "text") {
                    $('#show_hide_password input').attr('type', 'password');
                    $('#show_hide_password i').addClass("bx-hide");
                    $('#show_hide_password i').removeClass("bx-show");
                } else if ($('#show_hide_password input').attr("type") == "password") {
                    $('#show_hide_password input').attr('type', 'text');
                    $('#show_hide_password i').removeClass("bx-hide");
                    $('#show_hide_password i').addClass("bx-show");
                }
            });
        });
    </script>
</body>
</html>