<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// ✅ Enable Error Reporting
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Function to check if Aadhaar already has a pending/approved request
function checkExistingRequest($ahk_conn, $aadhaar_no, $name) {
    $check = mysqli_query($ahk_conn, "SELECT * FROM `aadhaar_pdf` 
        WHERE aadhaar_no = '$aadhaar_no' 
        AND name = '$name' 
        AND status IN ('pending', 'approved') 
        ORDER BY id DESC LIMIT 1");
    
    if (mysqli_num_rows($check) > 0) {
        return mysqli_fetch_assoc($check);
    }
    return false;
}

if (isset($_POST['aadhaar_no']) && !empty($_POST['name']) && !empty($_POST['ret_wp_no'])) {
    $name       = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $pan_no     = mysqli_real_escape_string($ahk_conn, $_POST['pan_no']);
    $aadhaar_no = mysqli_real_escape_string($ahk_conn, $_POST['aadhaar_no']);
    $dob        = mysqli_real_escape_string($ahk_conn, $_POST['dob']);
    $ret_wp_no  = mysqli_real_escape_string($ahk_conn, $_POST['ret_wp_no']);

    // ✅ Check if request already exists with API
    $existingRequest = checkExistingRequest($ahk_conn, $aadhaar_no, $name);
    
    if ($existingRequest) {
        // Request already exists
        $apiStatus = $existingRequest['api_status'];
        $apiMessage = $existingRequest['api_message'];
        $apiTrackingId = $existingRequest['api_tracking_id'];
        $dbStatus = $existingRequest['status'];
        $Traking_No = $existingRequest['application_no'];
        
        // Show message based on existing status
        if ($dbStatus == 'approved') {
            ?>
            <script>
                Swal.fire({
                    title: 'Application Already Approved',
                    html: 'Your request is already approved.<br>You can download the PDF from the list.',
                    icon: 'success',
                    timer: 3000,
                    showConfirmButton: true
                });
                setTimeout(() => {
                    window.location = 'AadharNo_to_pdf_list.php';
                }, 3000);
            </script>
            <?php
        } else {
            ?>
            <script>
                Swal.fire({
                    title: 'Application Already Submitted',
                    html: 'Status: <?php echo $apiStatus; ?><br>Message: <?php echo $apiMessage; ?><br>Tracking ID: <?php echo $apiTrackingId; ?>',
                    icon: 'info',
                    timer: 3000,
                    showConfirmButton: true
                });
                setTimeout(() => {
                    window.location = 'AadharNo_to_pdf_list.php';
                }, 3000);
            </script>
            <?php
        }
        exit();
    }

    $Traking_No = "Aadhar_pdf_" . rand(10000000, 99999999);
    $appliedby  = $udata['phone'];
    $fee        = $price['aadhaar_no_to_pdf'];
    $old_walletamount = $udata['balance'];
    $new_walletamount = $old_walletamount - $fee;

    if ($old_walletamount >= $fee) {
        date_default_timezone_set("Asia/Kolkata");
        $timestamp = date('d/m/Y g:i:s');
        
    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);
    $apiKey = $api['api_key'];
        
        // Build GET URL with parameters
        $apiUrl = "https://{$api['url_link']}/api_services/V2/adharCard_Services/aadharNo_to_pdf.php?" . http_build_query([
            'apiKey' => $apiKey,
            'uidNumber' => $aadhaar_no,
            'name' => $name
        ]);

        // Initialize cURL for API request
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        
        $apiResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if (curl_error($ch)) {
            $apiError = curl_error($ch);
            error_log("API cURL Error: " . $apiError);
            $apiResponseData = ['Status' => 'Error', 'message' => 'API connection failed: ' . $apiError];
        } else {
            $apiResponseData = json_decode($apiResponse, true);
            if ($apiResponseData === null && json_last_error() !== JSON_ERROR_NONE) {
                $apiResponseData = [
                    'Status' => 'Error', 
                    'message' => 'Invalid API response format',
                    'raw_response' => substr($apiResponse, 0, 500)
                ];
            }
        }
        curl_close($ch);

        // Process API Response
        $apiStatus = isset($apiResponseData['Status']) ? $apiResponseData['Status'] : 'Unknown';
        $apiMessage = isset($apiResponseData['message']) ? $apiResponseData['message'] : '';
        $apiTrackingId = isset($apiResponseData['tracking_id']) ? $apiResponseData['tracking_id'] : '';
        
        // Check if API says it's already pending
        if ($apiStatus == "Pending") {
            // Don't debit wallet, just save the request
            $dbStatus = "pending";
            $walletDebited = false;
        
            
            // Show pending message
            ?>
            <script>
                Swal.fire({
                    title: 'Application Already in Process',
                    html: 'API Status: <?php echo $apiStatus; ?><br>Message: <?php echo $apiMessage; ?><br>Tracking ID: <?php echo $apiTrackingId; ?>',
                    icon: 'info',
                    timer: 3000,
                    showConfirmButton: true
                });
                setTimeout(() => {
                    window.location = 'AadharNo_to_pdf_list.php';
                }, 3000);
            </script>
            <?php
            exit();
            
        } elseif ($apiStatus == "Request" || $apiStatus == "Success") {
            // New request or approved - proceed with wallet debit
            $walletDebited = true;
            
            // ✅ Wallet Deduction
            $debit = mysqli_query($ahk_conn, "UPDATE `users` SET balance='$new_walletamount' WHERE phone='$appliedby'");
            if (!$debit) {
                die("❌ Wallet debit failed: " . mysqli_error($ahk_conn));
            }

            // ✅ Card Summary Insert
            $summary = mysqli_query($ahk_conn, "INSERT INTO `card_summary` (`Requst_Name`, `Requst_No`, `Purpose`, `Traking_No`, `Status`, `fee`, `type`, `old_balance`, `new_balance`, `date`, `username`) 
                VALUES ('$name', '$aadhaar_no', 'UID NO TO PDF', '$Traking_No', 'pending', '$fee', 'Debit', '$old_walletamount', '$new_walletamount', '$timestamp', '$appliedby')");
            if (!$summary) {
                die("❌ Card summary insert failed: " . mysqli_error($ahk_conn));
            }

            // Determine status based on API response
            if ($apiStatus == "APPROVED") {
                $dbStatus = "approved";
            } else {
                $dbStatus = "pending";
            }

            // ✅ Aadhaar PDF Request Insert
            $insert = mysqli_query($ahk_conn, "INSERT INTO `aadhaar_pdf` 
                (`application_no`, `appliedby`, `name`, `aadhaar_no`, `pan_no`, `dob`, `status`, `ret_wp_no`, `fee`, `api_status`, `api_message`, `api_tracking_id`, `api_response`, `created_at`, `wallet_debited`) 
                VALUES ('$Traking_No', '$appliedby', '$name', '$aadhaar_no', '$pan_no', '$dob', '$dbStatus', '$ret_wp_no', '$fee', 
                '" . mysqli_real_escape_string($ahk_conn, $apiStatus) . "', 
                '" . mysqli_real_escape_string($ahk_conn, $apiMessage) . "', 
                '" . mysqli_real_escape_string($ahk_conn, $apiTrackingId) . "', 
                '" . mysqli_real_escape_string($ahk_conn, json_encode($apiResponseData)) . "', 
                '$timestamp', '1')");
                
            if (!$insert) {
                die("❌ Aadhaar PDF insert failed: " . mysqli_error($ahk_conn));
            }

            // ✅ WhatsApp Notification to Operator
            $api_query = mysqli_query($ahk_conn, "SELECT * FROM whatsapp_gateway LIMIT 1");
            $api = mysqli_fetch_assoc($api_query);

            if ($api) {
                $operator_number = $api['Admin_opreter'];
                $api_key  = $api['api_key'];
                $base_url = $api['url_link'];

                $message = "*Alert: UID NO TO PDF Request*\n";
                $message .= "Application Name: *$name*\n";
                $message .= "Aadhar No: *$aadhaar_no*\n";
                $message .= "Date of Birth: *$dob*\n";
                $message .= "API Status: *$apiStatus*\n";
                $message .= "API Message: *$apiMessage*\n";
                $message .= "Status: *$dbStatus*";

                $encoded_message = urlencode($message);
                $sms_url = "https://{$base_url}/send-message?api_key={$api_key}&sender={$api_key}&number={$operator_number}&message={$encoded_message}";

                $curl = curl_init();
                curl_setopt_array($curl, [
                    CURLOPT_URL => $sms_url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);
                $response = curl_exec($curl);
                if ($error = curl_error($curl)) {
                    error_log("WhatsApp API Error: " . $error);
                }
                curl_close($curl);
            }

            // Show appropriate message
            if ($apiStatus == "APPROVED") {
                ?>
                <script>
                    Swal.fire({
                        title: 'Application Approved!',
                        html: 'Your PDF is ready for download.<br>Tracking ID: <?php echo $apiTrackingId; ?>',
                        icon: 'success',
                        timer: 3000,
                        showConfirmButton: true
                    });
                    setTimeout(() => {
                        window.location = 'AadharNo_to_pdf_list.php';
                    }, 3000);
                </script>
                <?php
            } else {
                ?>
                <script>
                    Swal.fire({
                        title: 'Application Submitted Successfully',
                        html: 'API Status: <?php echo $apiStatus; ?><br>Message: <?php echo $apiMessage; ?><br>Tracking ID: <?php echo $apiTrackingId; ?>',
                        icon: 'success',
                        timer: 3000,
                        showConfirmButton: true
                    });
                    setTimeout(() => {
                        window.location = 'AadharNo_to_pdf_list.php';
                    }, 3000);
                </script>
                <?php
            }
        } else {
            // Error case
            ?>
            <script>
                Swal.fire({
                    title: 'API Error',
                    html: 'Status: <?php echo $apiStatus; ?><br>Message: <?php echo $apiMessage; ?>',
                    icon: 'error',
                    timer: 3000,
                    showConfirmButton: true
                });
                setTimeout(() => {
                    window.location = 'AadharNo_to_pdf_list.php';
                }, 3000);
            </script>
            <?php
        }

    } else {
        // ❌ Wallet Balance Too Low
        ?>
        <script>
            Swal.fire('Wallet Balance is Low!', 'Please Recharge Now!', 'error');
            setTimeout(() => {
                window.location = 'wallet.php';
            }, 1200);
        </script>
        <?php
    }
}
?>


<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
    
        <div class="row">
        </div> 
        <div class="row">
            <div class="col-xl-15 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bxs-id-card me-1 font-22 text-primary"></i>
                            </div>
                            <h5 class="mb-0 text-primary">Aadhar Number To Aadhar Pdf</h5>
                        </div>
                        <hr>
                        <form action="" method="POST" class="row g-3">
                            <div class="col-md-3">
                                <label for="inputFirstName" class="form-label">Name</label>
                                <input name="name" type="text"  placeholder="Name As Per Aadhaar"  class="form-control" id="inputFirstName" required>
                            </div> 
                            <div class="col-md-3">
                                <label for="inputLastName" class="form-label">AADHAAR No</label>
                                <input name="aadhaar_no" type="text" id="eid"  data-inputmask="'mask': '999999999999'"   placeholder="Enter 12 Digit AADHAAR  no" class="form-control" required maxlength="12" minlength="12">
                            </div>
                            <div class="col-md-3">
                                <label for="inputEmail" class="form-label">Date of Birth</label>
                                <input name="dob" type="text"  data-inputmask="'mask': '99/99/9999'"  placeholder="DD/MM/YYYY" class="form-control" id="date" required>
                            </div>
                            
                            <div class="col-md-3">
                                <label for="inputPassword" class="form-label">Retailer Whatsapp No</label>
                                <input name="ret_wp_no" type="text" placeholder="Enter Phone Number" value="<?php echo $udata['phone'] ?>"  class="form-control" id="inputPassword" required>
                            </div>
                            
                            <div class="col-12 ml-2">
                                <h5 class="text-warning ">Application Fee: ₹<?php echo $price['aadhaar_no_to_pdf']; ?></h5>
                                <h6 class="text-info">Wallet Balance: ₹<?php echo $udata['balance']; ?></h6>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary px-5">Apply</button>
                                <button type="reset" class="btn btn-secondary px-5">Reset</button>
                                <button type="button" onclick="window.location.href='AadharNo_to_pdf_list.php';"class="btn btn-danger px-5">Go To Aadhar Pdf List</button>

                            </div>
                        </form>
                    </div>
                </div>
            
            </div>
        </div>
        
    </div>
</div>

<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>

<script>
    $(document).ready(function() {
    
    $('#eid').inputmask();
    $('#date').inputmask();
    $('#pan_no').inputmask();
    $('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        hourFormat: 12
    });
    
    // Form validation
    $('form').on('submit', function(e) {
        var aadhar = $('#eid').val().replace(/\s/g, '');
        if (aadhar.length != 12 || isNaN(aadhar)) {
            e.preventDefault();
            Swal.fire('Invalid Aadhar Number', 'Please enter a valid 12-digit Aadhar number', 'error');
            return false;
        }
        
        var dob = $('#date').val();
        if (!dob.match(/^\d{2}\/\d{2}\/\d{4}$/)) {
            e.preventDefault();
            Swal.fire('Invalid Date Format', 'Please enter date in DD/MM/YYYY format', 'error');
            return false;
        }
    });
    });
</script>
</html>

<!--end page wrapper -->
<?php 
include('../template/ahkweb/footer.php');
?>