<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Function to check PDF status from API
function checkPDFStatus($aadhaar_no, $name) {
    
        /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);
    
    $api_url = "https://{$api['url_link']}/api_services/V2/adharCard_Services/aadharNo_to_pdf.php?apiKey={$api['api_key']}&uidNumber=" . $aadhaar_no . "&name=" . urlencode($name);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Function to save base64 PDF to file
function saveBase64PDF($base64_string, $aadhaar_no, $application_no) {
    // Create directory if not exists
    $upload_dir = '../uploads/aadhar_pdfs/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    // Generate filename
    $filename = 'aadhar_' . $application_no . '_' . $aadhaar_no . '_' . time() . '.pdf';
    $filepath = $upload_dir . $filename;
    
    // Decode base64 and save
    $pdf_data = base64_decode($base64_string);
    if (file_put_contents($filepath, $pdf_data)) {
        // Return relative path for database
        return 'uploads/aadhar_pdfs/' . $filename;
    }
    return false;
}

// Function to update PDF status in database
function updatePDFStatus($conn, $application_no, $status, $pdf_link = '', $pdf_path = '', $message = '') {
    $update_query = "UPDATE aadhaar_pdf SET status = ?, pdf_link = ?, pdf_path = ?, api_message = ? WHERE application_no = ?";
    $stmt = mysqli_prepare($conn, $update_query);
    mysqli_stmt_bind_param($stmt, "sssss", $status, $pdf_link, $pdf_path, $message, $application_no);
    return mysqli_stmt_execute($stmt);
}

// Handle refresh action
if(isset($_GET['refresh']) && isset($_GET['app_no'])) {
    $app_no = mysqli_real_escape_string($ahk_conn, $_GET['app_no']);
    
    // Get record details
    $get_record = mysqli_query($ahk_conn, "SELECT * FROM aadhaar_pdf WHERE application_no = '$app_no' AND appliedby = '".$_SESSION['phone']."'");
    
    if(mysqli_num_rows($get_record) > 0) {
        $record = mysqli_fetch_assoc($get_record);
        
        // Check status from API
        $api_response = checkPDFStatus($record['aadhaar_no'], $record['name']);
        
        if($api_response) {
            $status = '';
            $pdf_link = '';
            $pdf_path = '';
            $message = $api_response['message'] ?? '';
            
            // Map API status to database status
            switch($api_response['Status']) {
                case 'Success':
                    $status = 'success';
                    // Save base64 PDF to file
                    if(!empty($api_response['pdf_base64'])) {
                        $saved_path = saveBase64PDF($api_response['pdf_base64'], $record['aadhaar_no'], $app_no);
                        if($saved_path) {
                            $pdf_path = $saved_path;
                            $pdf_link = $saved_path; // For backward compatibility
                        }
                    }
                    $user_message = "PDF approved successfully! You can now download it.";
                    break;
                    
                case 'Pending':
                    $status = 'pending';
                    $user_message = "Your request is under process. Please check again later.";
                    break;
                    
                case 'Failed':
                    $status = 'failed';
                    $user_message = "Request rejected: " . $message;
                    break;
                    
                default:
                    $status = 'pending';
                    $user_message = "Status unknown. Please try again.";
            }
            
            // Update database
            if(updatePDFStatus($ahk_conn, $app_no, $status, $pdf_link, $pdf_path, $message)) {
                $_SESSION['refresh_message'] = $user_message;
                $_SESSION['refresh_status'] = $status;
            }
        } else {
            $_SESSION['refresh_message'] = "Unable to connect to API. Please try again later.";
            $_SESSION['refresh_status'] = 'error';
        }
        
        // Redirect back to main page
        header("Location: AadharNo_to_pdf_list.php");
        exit();
    }
}

// Handle bulk refresh
if(isset($_GET['refresh_all'])) {
    $get_pending = mysqli_query($ahk_conn, "SELECT * FROM aadhaar_pdf WHERE appliedby = '".$_SESSION['phone']."' AND status = 'pending'");
    
    $updated_count = 0;
    $failed_count = 0;
    $rejected_count = 0;
    $pending_count = 0;
    
    while($pending = mysqli_fetch_assoc($get_pending)) {
        $api_response = checkPDFStatus($pending['aadhaar_no'], $pending['name']);
        
        if($api_response) {
            $status = '';
            $pdf_link = '';
            $pdf_path = '';
            $message = $api_response['message'] ?? '';
            
            switch($api_response['Status']) {
                case 'Success':
                    $status = 'success';
                    // Save base64 PDF
                    if(!empty($api_response['pdf_base64'])) {
                        $saved_path = saveBase64PDF($api_response['pdf_base64'], $pending['aadhaar_no'], $pending['application_no']);
                        if($saved_path) {
                            $pdf_path = $saved_path;
                            $pdf_link = $saved_path;
                        }
                    }
                    $updated_count++;
                    break;
                    
                case 'Pending':
                    $status = 'pending';
                    $pending_count++;
                    break;
                    
                case 'Failed':
                    $status = 'failed';
                    $rejected_count++;
                    break;
            }
            
            if($status != 'pending') {
                updatePDFStatus($ahk_conn, $pending['application_no'], $status, $pdf_link, $pdf_path, $message);
            }
        } else {
            $failed_count++;
        }
        usleep(500000); // 0.5 second delay
    }
    
    $_SESSION['refresh_message'] = "Refresh completed. Success: $updated_count, Rejected: $rejected_count, Pending: $pending_count, API Failed: $failed_count";
    $_SESSION['refresh_status'] = 'info';
    
    header("Location: AadharNo_to_pdf_list.php");
    exit();
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <h5 class="mb-0">All AADHAAR PDF REQUEST LIST</h5>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="?refresh_all=1" class="btn btn-primary" onclick="return confirm('Refresh all pending records? This may take a few moments.');">
                            <i class="bx bx-refresh me-1"></i>Refresh All
                        </a>
                    </div>
                </div>
                <hr>
                
                <!-- Display refresh message -->
                <?php if(isset($_SESSION['refresh_message'])): ?>
                <div class="alert alert-<?php 
                    echo $_SESSION['refresh_status'] == 'success' ? 'success' : 
                        ($_SESSION['refresh_status'] == 'failed' ? 'danger' : 
                        ($_SESSION['refresh_status'] == 'error' ? 'warning' : 'info')); 
                ?> alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['refresh_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php 
                    unset($_SESSION['refresh_message']);
                    unset($_SESSION['refresh_status']);
                endif; 
                ?>
                
                <div class="table-responsive">
                    <table id="example2" class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">SL.</th>
                                <th class="text-center">Application No</th>
                                <th class="text-center">Name</th>
                                <th class="text-center">Aadhaar No</th>
                                <th class="text-center">Date of Birth</th>
                                <th class="text-center">Processing Fee</th>
                                <th class="text-center">Apply Date</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">API Message</th>
                                <th class="text-center">Action</th>
                                <th class="text-center">Download</th>
                            </tr>
                        </thead>
                        <tbody>
                           
<?php
$res = mysqli_query($ahk_conn,"SELECT * FROM aadhaar_pdf WHERE appliedby='".$_SESSION['phone']."' ORDER BY id DESC");
if(mysqli_num_rows($res)>0){
    $x=0;
    while($data = mysqli_fetch_assoc($res)){
        $x ++;
        ?>
        <tr>
            <td class="text-center"><?= $x;?></td>
            <td class="text-center"><?php echo strtoupper($data['application_no']); ?></td>
            <td class="text-center">
                <div class="d-flex align-items-center">
                    <div class="ms-2">
                        <h6 class="mb-1 font-14"><?php echo strtoupper($data['name']); ?></h6>
                    </div>
                </div>
            </td>
            <td class="text-center"><?php echo strtoupper($data['aadhaar_no']); ?></td>
            <td class="text-center"><?php echo strtoupper($data['dob']); ?></td>
            <td class="text-center">₹ <?php echo number_format($data['fee'], 2); ?></td>
            <td class="text-center"><?php echo date('d-m-Y H:i', strtotime($data['apply_date'])); ?></td>
            <td class="text-center">
                <?php
                if($data['status'] == "pending"){
                    echo '<span class="badge rounded-pill bg-light-warning text-warning">Pending</span>';
                } else if($data['status'] == "success"){
                    echo '<span class="badge rounded-pill bg-light-success text-success">Approved</span>';
                } else if($data['status'] == "failed"){
                    echo '<span class="badge rounded-pill bg-light-danger text-danger">Rejected</span>';
                }
                ?>
            </td>
            <td class="text-center">
                <?php if(!empty($data['api_message'])): ?>
                    <small class="text-muted"><?php echo htmlspecialchars($data['api_message']); ?></small>
                <?php else: ?>
                    <span class="text-muted">-</span>
                <?php endif; ?>
            </td>
            
            <td class="text-center">
                <?php if($data['status'] == "pending") { ?>
                <a href="?refresh=1&app_no=<?php echo $data['application_no']; ?>" 
                   class="btn btn-sm btn-warning" 
                   onclick="return confirm('Check live status from API?');"
                   title="Check Live Status">
                    <i class="bx bx-refresh"></i> Check
                </a>
                <?php } else { ?>
                <span class="text-muted">-</span>
                <?php } ?>
            </td>
        
            <td class="text-center">
                <?php
                    if($data['status'] == "pending"){
                        ?>
                        <div class="d-flex flex-column gap-1">
                            <span class="badge bg-light-warning text-warning">Processing</span>
                            <small class="text-muted">Check status</small>
                        </div>
                        
                        <?php
                    } else if($data['status'] == "success"){
                        // Determine download link - prefer local path first
                        $download_link = !empty($data['pdf_path']) ? $data['pdf_path'] : $data['pdf_link'];
                        ?>
                        <div class="d-flex flex-column gap-2">
                            <a href="../<?php echo $download_link; ?>" 
                               class="btn btn-sm btn-success"
                               download="aadhaar_<?php echo $data['aadhaar_no']; ?>.pdf">
                                <i class="bx bx-download"></i> Download PDF
                            </a>
                            <small class="text-muted">
                                <a href="../<?php echo $download_link; ?>" target="_blank">View PDF</a>
                            </small>
                        </div>
                        <?php
                    } else if($data['status'] == "failed"){
                        ?>
                        <div class="d-flex flex-column gap-1">
                            <span class="badge bg-light-danger text-danger">Rejected</span>
                            <small class="text-danger"><?php echo htmlspecialchars($data['api_message']); ?></small>
                        </div>
                        <?php
                    }
                ?>
            </td>
        </tr>
        <?php
       
    }
} else {
    echo '<tr><td colspan="11" class="text-center py-4">No records found</td></tr>';
}
?>
                          
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Loading Modal -->
<div class="modal fade" id="loadingModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center py-4">
                <div class="spinner-border text-primary mb-3" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <h6>Checking API Status...</h6>
                <p class="small text-muted mb-0">Please wait while we fetch live data</p>
            </div>
        </div>
    </div>
</div>

<!--end page wrapper -->
<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#example2').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'print'],
        order: [[6, 'desc']] // Sort by apply date descending
    });

    table.buttons().container()
        .appendTo('#example2_wrapper .col-md-6:eq(0)');
});

// Show loading modal on refresh click
$('a[href*="refresh="], a[href*="refresh_all"]').click(function(e) {
    if($(this).attr('href').includes('refresh_all')) {
        if(!confirm('Refresh all pending records? This may take a few moments.')) {
            e.preventDefault();
            return false;
        }
    } else {
        if(!confirm('Check live status from API?')) {
            e.preventDefault();
            return false;
        }
    }
    
    // Show loading modal
    $('#loadingModal').modal('show');
    return true;
});
</script>

<!-- Add new columns to database if not exists -->
<?php
// Check if pdf_path column exists
$check_pdf_path = mysqli_query($ahk_conn, "SHOW COLUMNS FROM aadhaar_pdf LIKE 'pdf_path'");
if(mysqli_num_rows($check_pdf_path) == 0) {
    mysqli_query($ahk_conn, "ALTER TABLE aadhaar_pdf ADD COLUMN pdf_path VARCHAR(500) AFTER pdf_link");
}

// Check if api_message column exists
$check_api_message = mysqli_query($ahk_conn, "SHOW COLUMNS FROM aadhaar_pdf LIKE 'api_message'");
if(mysqli_num_rows($check_api_message) == 0) {
    mysqli_query($ahk_conn, "ALTER TABLE aadhaar_pdf ADD COLUMN api_message TEXT AFTER pdf_path");
}

// Create upload directory if not exists
$upload_dir = '../uploads/aadhar_pdfs/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}
?>

</body>
</html>