<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Initialize variables
$msg = '';
$msgno = 0;
$fee = '₹' . $fee ?? 'N/A'; // Assuming this variable exists in config

// Get user data and balance
$userid = $udata['phone'] ?? '';
$current_balance = $udata['balance'] ?? 0;
$nbal = $current_balance; // Initialize new balance

if(isset($_POST['name'])){
    
    // Sanitize all inputs
    $name = mysqli_real_escape_string($ahk_conn, trim($_POST['name']));
    $fathername = mysqli_real_escape_string($ahk_conn, trim($_POST['fathername']));
    $aadhar = mysqli_real_escape_string($ahk_conn, trim($_POST['aadhar']));
    $account = mysqli_real_escape_string($ahk_conn, trim($_POST['account']));
    $cif = mysqli_real_escape_string($ahk_conn, trim($_POST['cif']));
    $ifsc = mysqli_real_escape_string($ahk_conn, trim($_POST['ifsc']));
    $branch = mysqli_real_escape_string($ahk_conn, trim($_POST['branch']));
    $village = mysqli_real_escape_string($ahk_conn, trim($_POST['village']));
    $post = mysqli_real_escape_string($ahk_conn, trim($_POST['post']));
    $block = mysqli_real_escape_string($ahk_conn, trim($_POST['block']));
    $district = mysqli_real_escape_string($ahk_conn, trim($_POST['district']));
    $state = mysqli_real_escape_string($ahk_conn, trim($_POST['state']));
    $pincode = mysqli_real_escape_string($ahk_conn, trim($_POST['pincode']));
    $mobile = $udata['phone'] ?? '';
    $email = $udata['email'] ?? '';
    
    date_default_timezone_set("Asia/Kolkata");
    $timestamp = date('d/m/Y g:i:s');
    
    // Validate required fields
    if(empty($name) || empty($aadhar) || empty($account)) {
        echo "<script>alert('Please fill all required fields.');</script>";
    } else {
        // Get fee from commission settings
        $fee_query = mysqli_query($ahk_conn, "SELECT airtel_pass_fee FROM users LIMIT 1");
        if ($fee_query && mysqli_num_rows($fee_query) > 0) {
            $price = mysqli_fetch_assoc($fee_query);
            $fee = $price['airtel_pass_fee'] ?? 0;
        } else {
            $fee = 0;
        }
        
        $appliedby = $udata['phone'] ?? '';
        
        // Check if user has sufficient balance
        if ($current_balance < $fee) {
            $_SESSION['error'] = "Insufficient wallet balance. Required: ₹$fee, Available: ₹$current_balance";
            echo "<script>alert('Insufficient wallet balance.');</script>";
        } else {
            // Start transaction
            mysqli_begin_transaction($ahk_conn);
            
            try {
                // Debit from wallet
                $debit = mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $fee WHERE phone = '$userid'");
                
                if(!$debit) {
                    throw new Exception("Balance deduction failed");
                }
                
                // Get updated balance
                $balance_query = mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone = '$userid'");
                if($balance_query && mysqli_num_rows($balance_query) > 0) {
                    $balance_data = mysqli_fetch_assoc($balance_query);
                    $nbal = $balance_data['balance'];
                }
                
                // Insert wallet history
                $updatehistory = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) VALUES ('$userid','$fee','$nbal','Airtel Passbook Print','1','Debit')");
                
                if(!$updatehistory) {
                    throw new Exception("Wallet history update failed");
                }
                
                // Insert application data
                $q = "INSERT INTO `airtelpass`(`name`, `fathername`,`aadhar`, `account`, `cif`, `ifsc`, `branch`, `village`, `post`, `block`, `district`, `state`, `pincode`, `userid`,`mobile`,`email`, `date`, `status`, `payment_status`) 
                      VALUES ('$name','$fathername','$aadhar','$account','$cif','$ifsc','$branch','$village','$post','$block','$district','$state','$pincode','$userid','$mobile','$email','$timestamp','Generated',1)";
                
                $res = mysqli_query($ahk_conn, $q);
                
                if($res){
                    // Fetch user details
                    $AWS = mysqli_fetch_array(mysqli_query($ahk_conn, "SELECT * FROM `users` WHERE `phone`='$userid'"));
                    $fullname = $AWS['name'] ?? '';
                    $apply_by = $AWS['phone'] ?? '';
                    
                    // Send SMS notification
                    if(!empty($apply_by) && isset($good_sms_url) && isset($good_sms_kay) && isset($good_sms_sender)) {
                        $user_number = "91" . $apply_by;                            
                        $whatsapp_url = $whatsapp_url ?? '#';
                        
                        $usermsg = urlencode("Congratulations 🎉 Your dear { *$fullname* } 🎉

Purpose : *Airtel Payment Bank Passbook Print*

Name : *$name*
Account No : $account

Update Fee : $fee
Old Balance : $current_balance
New Balance : $nbal

Thank You Very Much For Working With Us. For More Information Join WhatsApp Group: $whatsapp_url");

                        $sms_url = "https://$good_sms_url/send-message?api_key={$good_sms_kay}&sender={$good_sms_sender}&number={$user_number}&message=$usermsg";
                        
                        // Use cURL instead of file_get_contents for better error handling
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $sms_url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        $response = curl_exec($ch);
                        curl_close($ch);
                    }
                    
                    $msgno = 1;
                    $msg = "Application Submitted Successfully!";
                    $_SESSION['success'] = "Application submitted successfully!";
                    
                    // Commit transaction
                    mysqli_commit($ahk_conn);
                    
                    echo "<script> 
                        alert('Application submitted successfully!'); 
                        setTimeout(function(){
                            window.location.href = 'Airtel_pass_list.php';
                        }, 100);
                    </script>";
                    
                } else {
                    throw new Exception("Application submission failed: " . mysqli_error($ahk_conn));
                }
                
            } catch (Exception $e) {
                // Rollback transaction on error
                mysqli_rollback($ahk_conn);
                echo "<script>alert('Error: " . addslashes($e->getMessage()) . "');</script>";
                $msg = "Application Failed!";
            }
        }
    }
}
?>

<!-- HTML और JavaScript कोड यहाँ से शुरू -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Airtel Passbook Print</title>
</head>
<body>
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <h6 class="mb-0 text-uppercase">AIRTEL DIGITAL PASSBOOK PRINT</h6>
                    <hr/>
                    <div class="card border-top border-0 border-4 border-primary">
                        <div class="card-body p-5">
                            <div class="card-title d-flex align-items-center">
                                <div><i class="bx bxs-id-card me-1 font-22 text-primary"></i></div>
                            </div>
                            
                            <!-- Success Message -->
                            <?php if(isset($_SESSION['success'])): ?>
                                <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
                            <?php endif; ?>
                            
                            <?php if(isset($_SESSION['error'])): ?>
                                <div class="alert alert-danger"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
                            <?php endif; ?>
                            
                            <section id="main-content">
                                <div class="row dgnform">
                                    <div class="col-sm-12">
                                        <form action="" method="post" onsubmit="return validateForm()">
                                            <div class="row">
                                                <!-- Form fields remain the same -->
                                                <div class="col-sm-3">
                                                    <label>Full Name *</label>
                                                    <div class="form-group">
                                                        <input class="form-control" value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>" id="name" placeholder="Full Name" autocomplete="off" name="name" type="text" maxlength="40" required>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-sm-3">
                                                    <label>Father Name *</label>
                                                    <div class="form-group">
                                                        <input class="form-control" value="<?php echo isset($_POST['fathername']) ? htmlspecialchars($_POST['fathername']) : ''; ?>" id="fathername" placeholder="Father Name" name="fathername" type="text" required>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-sm-3">
                                                    <label>Aadhar Number *</label>
                                                    <div class="form-group">
                                                        <input class="form-control" value="<?php echo isset($_POST['aadhar']) ? htmlspecialchars($_POST['aadhar']) : ''; ?>" id="aadhar" placeholder="Aadhar Number" name="aadhar" type="number" minlength="12" maxlength="12" required>
                                                    </div>
                                                </div>
                                                
                                                <!-- Remaining form fields... -->
                                                
                                                <div class="col-sm-3">
                                                    <label>Account No *</label>
                                                    <div class="form-group">
                                                        <input class="form-control" name="account" id="account" placeholder="20120677526" value="<?php echo isset($_POST['account']) ? htmlspecialchars($_POST['account']) : ''; ?>" type="number" required>
                                                    </div>
                                                </div>
                                                
                                                <!-- Add all other form fields similarly with value persistence -->
                                                
                                                <div class="col-sm-12 mt-3">
                                                    <div class="row">
                                                        <div class="col-sm-3">
                                                            <div class="form-group">
                                                                <button type="submit" class="btn btn-success form-control">Submit Application</button>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-9">
                                                            <div class="alert alert-warning">
                                                               
                                                    <strong>Application Fee:</strong> ₹<?php echo htmlspecialchars($price['airtel_pass_fee'] ?? 0); ?>
                                                                <br><strong>Your Current Balance:</strong> ₹<?php echo number_format($current_balance, 2); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end page wrapper -->



    <!-- JavaScript Validation -->
    <script>
    function validateForm() {
        var aadhar = document.getElementById('aadhar').value;
        var account = document.getElementById('account').value;
        var pincode = document.getElementById('pincode').value;
        
        // Validate Aadhar (12 digits)
        if(aadhar.length !== 12) {
            alert('Aadhar number must be 12 digits');
            return false;
        }
        
        // Validate Pincode (6 digits)
        if(pincode.length !== 6) {
            alert('Pincode must be 6 digits');
            return false;
        }
        
        // Confirm submission
        return confirm('Are you sure you want to submit this application? ₹<?php echo $fee ?? 0; ?> will be deducted from your wallet.');
    }
    
    // Auto redirect if success
    <?php if($msgno == 1): ?>
    setTimeout(function() {
        window.location.href = "Airtel_pass_list.php";
    }, 3000);
    <?php endif; ?>
    </script>
</body>
</html>
    <?php include('../template/ahkweb/footer.php'); ?>