<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ================= DEFAULT VARS ================= */
$showResult = false;

$uidMasked = $bankName = $npcistatus = $lastUpdate = '';
$apiTrack = $oldBalApi = $feeApi = $newBalApi = '';

/* ================= FORM SUBMIT ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uidNumber = trim($_POST['uidNumber']);

    if (!preg_match('/^[0-9]{12}$/', $uidNumber)) {
        echo "<script>alert('Invalid Aadhaar Number');</script>";
    } else {

        $username = $udata['phone'];
        $fee      = 15;
        $oldBal   = $udata['balance'];
        $newBal   = $oldBal - $fee;
        $Purpose  = "UID_TO_NPCI_S2";
        $Tracking = "UIDNPCI".rand(100000,999999);
        $date     = date('Y-m-d H:i:s');

        if ($oldBal < $fee) {
            echo "<script>
                alert('Low Balance! Please Recharge');
                window.location='wallet.php';
            </script>";
            exit;
        }

        /* ================= GET API ================= */
        $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api LIMIT 1");
        $api = mysqli_fetch_assoc($AWS_api);
        $apiKey = $api['api_key'];

        $apiUrl = "https://{$api['url_link']}/api_services/V1/aadharServices/uid_to_ncpi_S2.php"
                . "?apiKey=$apiKey&uidNumber=$uidNumber";

        /* ================= CURL REQUEST ================= */
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo "<script>alert('API Server Error');</script>";
            curl_close($ch);
            exit;
        }

        curl_close($ch);

        $res = json_decode($response, true);

        /* ================= CHECK SUCCESS ================= */
        if (!isset($res['Status']) || $res['Status'] !== 'Success') {
            echo "<script>alert('NPCI Check Failed');</script>";
        } else {

            $uidMasked   = $res['uid'] ?? '';
            $bankName    = $res['bank_Name'] ?? '';
            $npcistatus  = $res['status'] ?? '';
            $lastUpdate  = $res['last_Updated_Date'] ?? '';
            $apiTrack    = $res['tracking_id'] ?? '';

            $oldBalApi  = $oldBal;
            $feeApi     = $fee;
            $newBalApi  = $newBal;

            /* ================= DB TRANSACTION ================= */
            mysqli_begin_transaction($ahk_conn);

            try {

                mysqli_query($ahk_conn,
                    "UPDATE users SET balance='$newBal' WHERE phone='$username'"
                );

                mysqli_query($ahk_conn,"
                    INSERT INTO aadhaar_ncpi_status
                    (tracking_no,purpose,username,uid_masked,
                     bank_name,ncpi_status,last_updated,
                     fee,old_balance,new_balance,api_tracking_id,date)
                    VALUES
                    ('$Tracking','$Purpose','$username','$uidMasked',
                     '$bankName','$npcistatus','$lastUpdate',
                     '$fee','$oldBal','$newBal','$apiTrack','$date')
                ");

                mysqli_commit($ahk_conn);
                $showResult = true;

            } catch (Exception $e) {
                mysqli_rollback($ahk_conn);
                echo "<script>alert('Transaction Failed');</script>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Aadhaar to NPCI Status (S2 API)</title>
</head>

<body>
<div class="page-wrapper">
<div class="page-content">

<div class="col-lg-12">
<div class="card" style="margin:10px;padding:20px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">AADHAAR TO NPCI LINK STATUS (S2 API)</div>

<form method="POST">
<label>Aadhaar Number</label>
<input type="text"
       name="uidNumber"
       maxlength="12"
       class="form-control"
       required>

<br>
<input class="form-control" value="Charge ₹15" readonly>

<br>
<button type="submit" name="submit" class="btn btn-success w-100">
Check Status
</button>
</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8">
<div class="card" style="background:#f3fbf4;">
<div class="card-body">

<h6>Aadhaar NPCI Linking Status Result</h6>
<hr>

<?php if ($showResult) { ?>
<p>
<b>Aadhaar (Masked):</b> <?php echo $uidMasked; ?><br>
<b>Bank Name:</b> <?php echo $bankName; ?><br>
<b>NPCI Status:</b> 
<span class="badge bg-success"><?php echo $npcistatus; ?></span><br>
<b>Last Updated:</b> <?php echo $lastUpdate; ?><br>
</p>

<hr>

<p>
<b>Tracking ID:</b> <?php echo $apiTrack; ?><br>
<b>Old Balance:</b> ₹<?php echo $oldBalApi; ?><br>
<b>Fee:</b> ₹<?php echo $feeApi; ?><br>
<b>New Balance:</b> ₹<?php echo $newBalApi; ?>
</p>

<?php } else { ?>
<h6>Submit Aadhaar Number to Check NPCI Status</h6>
<?php } ?>

</div>
</div>
</div>

</div>
</div>
</div>
</div>
</div>

</body>
</html>

<?php include('../template/ahkweb/footer.php'); ?>
