<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uid   = trim($_POST['uid']);
    $state = trim($_POST['state']);

    /* ================= VALIDATION ================= */
    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning')
            .then(()=>window.location.href='GoodApi_AyushmanNo');
        </script>";
        exit;
    }

    if ($state == '') {
        echo "<script>
            Swal.fire('Invalid State','Please select state','warning')
            .then(()=>window.location.href='GoodApi_AyushmanNo');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "AYF".rand(100000,999999);
    $Purpose    = "AYUSHMAN NO DETAILS";
    $username   = $udata['phone'];
    $fee        = $price['ayushman_no_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/aaayushmanServices/aayushman_no.php"
         . "?uid=$uid&state=$state&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Ayushman details fetch failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_AyushmanNo');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $members  = $resdata['family_members'] ?? [];
    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* MAIN HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO ayushman_no_find
            (application_no,purpose,username,uid,state,total_members,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$uid','$state','".count($members)."','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* MEMBER DETAILS */
        foreach ($members as $m) {
            mysqli_query($ahk_conn,"
                INSERT INTO ayushman_no_members
                (application_no,username,name,gender,mobile,father,card_no,dob,district,state,address,pincode,mask_uid,date)
                VALUES
                ('$Traking_No','$username',
                 '".($m['Name'] ?? '')."',
                 '".($m['Gender'] ?? '')."',
                 '".($m['Mobile_no'] ?? '')."',
                 '".($m['Father'] ?? '')."',
                 '".($m['Card_no'] ?? '')."',
                 '".($m['Dob'] ?? '')."',
                 '".($m['Distic'] ?? '')."',
                 '".($m['State'] ?? '')."',
                 '".($m['Full_address'] ?? '')."',
                 '".($m['pincode'] ?? '')."',
                 '".($m['Mask_uid'] ?? '')."',
                 '$timestamp')
            ");
        }

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('Ayushman No','$uid','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire(
          'Success',
          'Ayushman family details fetched successfully. Total Members: ".count($members)."',
          'success'
        );
    </script>";
}
?>
<!-- AYUSHMAN NO DETAILS HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">AYUSHMAN NO DETAILS</div>

<form method="POST" class="row g-3">

<div class="col-md-12">
<label>Aadhaar Number</label>
<input name="uid" maxlength="12" class="form-control"
placeholder="Enter 12 Digit Aadhaar" required>
</div>
<div class="col-md-12">
  <label>Select State</label>
  <select name="state" class="form-control" required>
    <option value="">-- Select State --</option>

    <option value="35">ANDAMAN AND NICOBAR ISLANDS</option>
    <option value="28">ANDHRA PRADESH</option>
    <option value="12">ARUNACHAL PRADESH</option>
    <option value="18">ASSAM</option>
    <option value="10">BIHAR</option>
    <option value="4">CHANDIGARH</option>
    <option value="22">CHHATTISGARH</option>
    <option value="26">DADRA AND NAGAR HAVELI AND DAMAN AND DIU</option>
    <option value="7">DELHI</option>
    <option value="30">GOA</option>
    <option value="24">GUJARAT</option>
    <option value="6">HARYANA</option>
    <option value="2">HIMACHAL PRADESH</option>
    <option value="1">JAMMU AND KASHMIR</option>
    <option value="20">JHARKHAND</option>
    <option value="29">KARNATAKA</option>
    <option value="32">KERALA</option>
    <option value="37">LADAKH</option>
    <option value="31">LAKSHADWEEP</option>
    <option value="23">MADHYA PRADESH</option>
    <option value="27">MAHARASHTRA</option>
    <option value="14">MANIPUR</option>
    <option value="17">MEGHALAYA</option>
    <option value="15">MIZORAM</option>
    <option value="13">NAGALAND</option>
    <option value="21">ODISHA</option>
    <option value="34">PUDUCHERRY</option>
    <option value="3">PUNJAB</option>
    <option value="8">RAJASTHAN</option>
    <option value="11">SIKKIM</option>
    <option value="33">TAMIL NADU</option>
    <option value="36">TELANGANA</option>
    <option value="16">TRIPURA</option>
    <option value="9">UTTAR PRADESH</option>
    <option value="5">UTTARAKHAND</option>
    <option value="19">WEST BENGAL</option>

  </select>
</div>


<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['ayushman_no_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>

</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="background:#f3fbf4;">
<div class="card-body">
<h6>
Aadhaar aur State ke basis par Ayushman family member details nikali ja rahi hain.
</h6>
<hr>

<?php if (isset($members) && count($members) > 0) { ?>
<div class="table-responsive">
<table class="table table-bordered table-striped">
<thead class="table-primary">
<tr>
<th>#</th>
<th>Name</th>
<th>Gender</th>
<th>Card No</th>
<th>Mobile</th>
<th>Masked UID</th>
</tr>
</thead>
<tbody>
<?php $i=1; foreach ($members as $m) { ?>
<tr>
<td><?php echo $i++; ?></td>
<td><?php echo htmlspecialchars($m['Name']); ?></td>
<td><?php echo htmlspecialchars($m['Gender']); ?></td>
<td><?php echo htmlspecialchars($m['Card_no']); ?></td>
<td><?php echo htmlspecialchars($m['Mobile_no']); ?></td>
<td><?php echo htmlspecialchars($m['Mask_uid']); ?></td>
</tr>
<?php } ?>
</tbody>
</table>
</div>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_AyushmanNo_list" class="btn btn-dark mt-2">
GO TO AYUSHMAN NO LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>

