<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $rtps_no = trim($_POST['rtps_no']);
    $name    = trim($_POST['name']);

    /* ================= BASIC VALIDATION ================= */
    if ($rtps_no == '' || $name == '') {
        echo "<script>
            Swal.fire('Error','RTPS Number and Name are required','warning')
            .then(()=>window.location.href='GoodApi_BiharRTPS');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "RTPSV".rand(100000,999999);
    $Purpose    = "BIHAR RTPS CERTIFICATE PRINT";
    $username   = $udata['phone'];
    $fee        = $price['bihar_rtps_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/rtpsService/bihar_print.php"
         . "?rtps_no=" . urlencode($rtps_no)
         . "&name=" . urlencode($name)
         . "&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'RTPS PDF Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_BiharRTPS');
        </script>";
        exit;
    }

    /* ================= PDF PROCESS ================= */
    $pdfRaw = $resdata['pdf'] ?? '';

    if ($pdfRaw == '') {
        die('PDF data not found');
    }

    // remove data:application/pdf;base64,
    $pdfBase64 = preg_replace('#^data:application/pdf;base64,#', '', $pdfRaw);
    $pdfData   = base64_decode($pdfBase64);

    $safeRtps  = str_replace(['/','\\'], '_', $rtps_no);
    $fileName  = "RTPS_{$safeRtps}.pdf";
    $dirPath   = "../uploads/rtps_pdf/";
    $filePath  = $dirPath . $fileName;

    if (!is_dir($dirPath)) {
        mkdir($dirPath, 0777, true);
    }

    file_put_contents($filePath, $pdfData);

    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* RTPS HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO bihar_rtps_print
            (application_no,purpose,username,rtps_no,name,pdf_file,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$rtps_no','$name','$fileName','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('RTPS Certificate','$rtps_no','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire({
          title: 'Success',
          html: 'RTPS Certificate PDF generated successfully.<br><br>
                 <a href=\"$filePath\" target=\"_blank\" class=\"btn btn-success\">Download PDF</a>',
          icon: 'success'
        });
    </script>";
}
?>
<!-- BIHAR RTPS CERTIFICATE HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">
BIHAR RTPS CERTIFICATE (DOMICILE / INCOME / RESIDENT)
</div>

<form method="POST" class="row g-3">
<div class="col-md-12">
<label>RTPS Application Number</label>
<input name="rtps_no" class="form-control"
placeholder="BICCO/2026/233369" required>
</div>

<div class="col-md-12">
<label>Applicant Name</label>
<input name="name" class="form-control"
placeholder="Sunil Kumar" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['bihar_rtps_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>
</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="height:290px;background:#f3fbf4;">
<div class="card-body">
<h6>
RTPS Application Number ke through Bihar RTPS Certificate PDF download ki ja rahi hai.
</h6>
<hr>

<?php if (isset($fileName)) { ?>
<p>
<b>RTPS No:</b> <?php echo htmlspecialchars($rtps_no); ?><br>
<b>Name:</b> <?php echo htmlspecialchars($name); ?><br><br>
<a href="<?php echo $filePath; ?>" target="_blank" class="btn btn-success">
Download RTPS Certificate PDF
</a>
</p>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_BiharRTPS_list" class="btn btn-dark mt-2">
GO TO RTPS LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>
