<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $applNum = trim($_POST['applNum']);
    $licNum  = trim($_POST['licNum']);
    $mobile  = trim($_POST['mobile']);
    $dob     = trim($_POST['dob']);

    if (empty($applNum)) {
        echo "<script>Swal.fire('Error','Application Number Required','error');</script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "LLPDF".rand(100000,999999);
    $Purpose    = "LEARNING LICENCE PDF";
    $username   = $udata['phone'];
    $fee        = $price['ll_pdf_fee'] ?? 30;
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API DETAILS ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/vahanServices/leaning_licence_pdf.php"
        . "?applNum=$applNum"
        . "&licNum=$licNum"
        . "&mobileNum=$mobile"
        . "&dateOfBirth=$dob"
        . "&apiKey={$api['api_key']}";

    $response = file_get_contents($url);

    if ($response === FALSE) {
        die("API Connection Failed");
    }

    $resdata = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        die("Invalid JSON Response");
    }

    /* ================= STATUS CHECK ================= */
    if (!isset($resdata['Status']) || $resdata['Status'] !== 'Success') {

        $msg = $resdata['message'] ?? 'LL PDF Fetch Failed';

        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_LL_PDF');
        </script>";
        exit;
    }

    /* ================= PDF PROCESS ================= */
    $pdfBase64 = $resdata['pdf'] ?? '';

    if (empty($pdfBase64)) {
        die("PDF data not found in API response");
    }

    if (strpos($pdfBase64, 'base64,') !== false) {
        $pdfBase64 = explode('base64,', $pdfBase64)[1];
    }

    $pdfData = base64_decode($pdfBase64);

    if ($pdfData === false) {
        die("Base64 Decode Failed");
    }

    $folderPath = "../uploads/ll_pdf/";
    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0777, true);
    }

    $fileName = "LL_" . $applNum . "_" . time() . ".pdf";
    $filePath = $folderPath . $fileName;

    if (file_put_contents($filePath, $pdfData) === false) {
        die("PDF Save Failed");
    }

    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= DATABASE TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        mysqli_query($ahk_conn,"
            INSERT INTO learning_licence_pdf
            (application_no,purpose,username,appl_no,lic_no,mobile,dob,pdf_file,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$applNum','$licNum','$mobile','$dob','$fileName','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('LL PDF','$applNum','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

        echo "<script>
            Swal.fire({
              title: 'Success',
              html: 'Learning Licence PDF generated successfully.<br><br><a href=\"$filePath\" target=\"_blank\" class=\"btn btn-primary\">Download PDF</a>',
              icon: 'success'
            });
        </script>";

    } catch (Exception $e) {

        mysqli_rollback($ahk_conn);
        unlink($filePath);
        die("Transaction Failed: " . $e->getMessage());
    }
}
?>

<!-- LEARNING LICENCE PDF HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">LEARNING LICENCE PDF</div>

<form method="POST" class="row g-3">
<div class="col-md-12">
<label>Application Number</label>
<input name="applNum" class="form-control" required>
</div>

<div class="col-md-12">
<label>Licence Number (Optional)</label>
<input name="licNum" class="form-control">
</div>

<div class="col-md-12">
<label>Registered Mobile</label>
<input name="mobile" class="form-control" >
</div>

<div class="col-md-12">
<label>Date of Birth</label>
<input name="dob" type="date" class="form-control" >
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['ll_pdf_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>
</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="background:#f3fbf4;">
<div class="card-body">
<h6>
Application number ke through Learning Licence PDF generate ki ja rahi hai.
</h6>
<hr>

<?php if (isset($fileName)) { ?>
<p>
<b>PDF File:</b>
<a href="<?php echo $filePath; ?>" target="_blank">Download Learning Licence PDF</a>
</p>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_LL_PDF_list" class="btn btn-dark mt-2">
GO TO LL PDF LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>
