<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $pan_no = strtoupper(trim($_POST['pan_no']));

    /* ================= PAN VALIDATION ================= */
    if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/', $pan_no)) {
        echo "<script>
        Swal.fire('Invalid PAN','Enter valid PAN number','warning')
        .then(()=>window.location.href='GoodApi_PanDetails');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "PANDET".rand(100000,999999);
    $Purpose    = "PAN DETAILS FIND";
    $username   = $udata['phone'];
    $fee        = $price['Pan_detail_fee']; // DATABASE FEE
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
        Swal.fire('Low Balance','Please recharge wallet','warning')
        .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/panServices/pan_details_S1.php?panNumber=$pan_no&apiKey={$api['api_key']}";
    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'PAN Details Fetch Failed';
        echo "<script>
        Swal.fire('Failed','$msg','error')
        .then(()=>window.location.href='GoodApi_PanDetails');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $name          = $resdata['name'] ?? 'N/A';
    $fathername    = $resdata['father'] ?? 'N/A';
    $dob           = $resdata['dob'] ?? 'N/A';
    $gender        = $resdata['gender'] ?? 'N/A';
    $panStatus     = $resdata['pan_status'] ?? 'N/A';
    $aadhaarLinked = $resdata['aadhaar_linked'] ?? false;
    $tracking_id  = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* PAN DETAILS HISTORY */
        mysqli_query($ahk_conn,"
        INSERT INTO instantpan_find
        (application_no, Purpose, username, pan_no, name, fathername,
         gender, dob, aadhaar_no, Status, StatusCode,
         fee, old_balance, new_balance, date)
        VALUES
        ('$tracking_id','$Purpose','$username','$pan_no','$name','$fathername',
         '$gender','$dob','$aadhaarLinked','$Status','100',
         '$fee','$oldBal','$newBal','$timestamp')
        ");

        /* SUMMARY */
        mysqli_query($ahk_conn,"
        INSERT INTO card_summary
        (Requst_Name, Requst_No, Purpose, Traking_No, Status,
         fee, type, old_balance, new_balance, date, username)
        VALUES
        ('$pan_no','$pan_no','$Purpose','$tracking_id','$Status',
         '$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die("Transaction Failed");
    }

    /* ================= SUCCESS ================= */
    echo "<script>
    Swal.fire(
        'Success',
        'PAN Details Fetched Successfully',
        'success'
    ).then(()=>window.location.href='#');
    </script>";
}
?>

<!-- HTML Form -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="col-lg-12">
            <div class="card" style="margin-left: 10px; padding-left: 30px; padding-top: 12px; box-shadow: 1px 5px 5px 5px;">
                <div class="stat-content">
                    <div class="stat-text">
                        <div class="container-fluid">
                            <div class="row">
                                <!-- Input Section -->
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="alert alert-danger" role="alert">
                                                PAN NUMBER TO PAN NUMBER WITH PAN CARD DETAIL
                                            </div>
                                            <form action="" method="POST" class="row g-3">
                                                <div class="col-md-12">
                                                    <label>Pan Number</label>
                                                    <input name="pan_no" type="text" maxlength="10" minlength="10"  placeholder="Enter 10-digit Pan number" class="form-control" required>
                                                </div>
                                                <div class="col-md-12 mt-3">
                                                    <input class="form-control" value="Charge ₹<?php echo $price['Pan_detail_fee']; ?>" readonly>
                                                </div>
                                                <div class="text-left mt-3">
                                                    <button class="form-control btn btn-success" name="submit"><i class="fa fa-check-circle"></i> Submit</button>
                                                </div>
                                            </form>
                                            </div>
                                         </div>
                                      </div>
                                 <div class="col-lg-8 col-md-6 col-sm-6">
                            <div class="card" style="height: 290px; background-color: #f3fbf4;">
                        <div class="card-body">
                            <h6>please pay attention. PAN card number and PAN card details are obtained. Remember, we are providing these services only for verification and not for misuse. Thanks.....</h6>
                        <hr>
                         <?php if (!empty($pan_no)) { ?>
                        <h6>Pan No : <?php echo $pan_no; ?></h6>
                        <ul>
                        <li style="color:red">Name : <?php echo $name; ?></li>
                        <li style="color:block">Father's Name : <B> <?php echo $fathername; ?></B></li>
                        <li style="color:block">Gender : <B><?php echo $gender; ?></B></li>
                        <li style="color:block">Date of Birth : <B><?php echo $dob; ?></B></li>
                        <li style="color:block">Mask UID : <B> <?php echo htmlspecialchars($aadhaarLinked); ?>; </B></li>
                        </ul>
                        <?php } else { ?>
                <h6>Data Found To Details Show ...</h6>
                <?php } ?>
                        </div>
                     </div>
                   <a href="GoodApi_PanDetail_list" class="btn btn-dark">GO TO PAN DETAIL FIND LIST <img width="30" height="30" src="https://img.icons8.com/3d-fluency/94/undo.png" alt="undo"/></a>
                </div>
            </div>
        </div>
    </div>
          
       </div>
           <br>
 <div class="col-lg-12">
                                         <div class="card" style="margin-left: 10px;    padding-left: 30px;
                                        padding-top: 12px;
                                      box-shadow: 1px 5px 5px 5px;">
                                 <div class="stat-widget-two">
                            <div class="stat-content">
                        <div class="stat-text">
<div hidden class="card-body text-center">
<p><font size="5px">
<b style="color:#046A38">
<span class="blink"></div>
<p style="color:#06038D;margin-left:0%; font-size: 20px;">कृपया ध्यान दें। पैन कार्ड नंबर तो पैन कार्ड डिटेल निकलवाई याद रहे सिर्फ वेरिफाई के लिए यह सर्विसेज प्रोवाइड कर रहे है न की गलत इस्तेमाल करने के लिए धन्यवादैं। अगर आप लोगों को किसी प्रकार कोई समस्या है तो Telegram मे Massage करें, धन्यवाद ...  <a href="<?php echo $telegram_url; ?>" class="fa fa-telegram text-info" target="_blank" >Joint Telegram Support</a></p>
        </h4>
				                  		</h4>
			                   		</div>
			                	</div>
		                  	</div>
                        </div>      
                    </div>
                </div>
           <br>
 <!-- Add your footer content here -->
     <?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>
