<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $aadhaar = trim($_POST['uid']);

    /* ================= AADHAAR VALIDATION ================= */
    if (!preg_match('/^\d{12}$/', $aadhaar)) {
        echo "<script>Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning').then(()=>window.location.href='GoodApi_PanFind');</script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "PANFIND".rand(100000,999999);
    $Purpose    = "PAN FIND";
    $username   = $udata['phone'];
    $fee        = $price['pan_find_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>Swal.fire('Low Balance','Please recharge wallet','warning').then(()=>window.location.href='wallet.php');</script>";exit;
    }
    
    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);
    
    $url = "https://{$api['url_link']}/api_services/V1/panServices/pan_no_find_S1.php?aadhaarNo=$aadhaar&apiKey={$api['api_key']}";
    
    // Use cURL instead of file_get_contents for better error handling
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200 || !$response) {
        echo "<script>Swal.fire('Failed','API Connection Failed','error').then(()=>window.location.href='GoodApi_PanFind');</script>";exit;
    }
    
    $resdata  = json_decode($response, true);

    // Check API response based on actual response structure
    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'PAN Fetch Failed';
        echo "<script>Swal.fire('Failed','$msg','error').then(()=>window.location.href='GoodApi_PanFind');</script>";exit;
    }
    
    /* ================= API DATA ================= */
    // Extract data from the response based on the sample provided
    $pan_no     = $resdata['pan_no'] ?? 'N/A';
    $name       = $resdata['full_name'] ?? 'N/A';
    $dob        = $resdata['date_of_birth'] ?? 'N/A';
    $aadhaar_no = $resdata['aadhaar_no'] ?? $aadhaar;
    $tracking_id = $resdata['tracking_id'] ?? $Traking_No;
    
    // Get fee from API response if available, otherwise use configured fee
    $api_fee = $resdata['fee'] ?? $fee;
    $api_old_balance = $resdata['old_balance'] ?? $oldBal;
    $api_new_balance = $resdata['new_balance'] ?? $newBal;
    
    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);
    try {
        /* Wallet Update */
        mysqli_query($ahk_conn,"UPDATE users SET balance='$newBal' WHERE phone='$username'");

        /* PAN FIND HISTORY */
        $insert_query = "INSERT INTO instantpan_find(application_no, Purpose, username, aadhaar_no, pan_no,
            name, dob, Status, StatusCode, fee, old_balance, new_balance, date)
            VALUES
            ('$Traking_No', '$Purpose', '$username', '$aadhaar_no', '$pan_no', '$name', '$dob', 
            '$Status', '{$resdata['StatusCode']}', '$api_fee', '$api_old_balance', '$api_new_balance', '$timestamp')";
        
        mysqli_query($ahk_conn, $insert_query);

        /* SUMMARY */
        $summary_query = "INSERT INTO card_summary(Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username)
            VALUES
            ('$name', '$aadhaar_no', '$Purpose', '$Traking_No', '$Status', '$api_fee', 'Debit', '$oldBal', '$newBal', '$timestamp', '$username')";
        
        mysqli_query($ahk_conn, $summary_query);

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        error_log("Transaction Failed: " . $e->getMessage());
        echo "<script>Swal.fire('Error','Transaction Failed: " . addslashes($e->getMessage()) . "','error').then(()=>window.location.href='GoodApi_PanFind');</script>";
        exit;
    }
    
    // Store data in session to display in the form
    $_SESSION['last_pan_result'] = [
        'pan_no' => $pan_no,
        'name' => $name,
        'dob' => $dob,
        'aadhaar' => $aadhaar_no
    ];
    
    echo "<script>Swal.fire('Success','PAN Details Fetched Successfully','success').then(()=>window.location.href='GoodApi_PanFind');</script>";
    exit;
}

// Check if we have a previous result to display
$last_result = $_SESSION['last_pan_result'] ?? null;
if ($last_result) {
    $pan_no = $last_result['pan_no'];
    $name = $last_result['name'];
    $dob = $last_result['dob'];
    $aadhaar = $last_result['aadhaar'];
    // Clear the session data after retrieving
    unset($_SESSION['last_pan_result']);
}
?>

<!-- PAN FIND HTML -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="col-lg-12">
            <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
                <div class="stat-content">
                    <div class="stat-text">
                        <div class="container-fluid">
                            <div class="row">
                                <!-- INPUT SECTION -->
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="alert alert-danger">
                                                AADHAAR NUMBER TO PAN FIND
                                            </div>
                                            <form action="" method="POST" class="row g-3">
                                                <div class="col-md-12">
                                                    <label>Aadhaar Number</label>
                                                    <input name="uid" type="text" maxlength="12" minlength="12" 
                                                           placeholder="Enter 12 Digit Aadhaar" 
                                                           class="form-control" 
                                                           value="<?php echo isset($_POST['uid']) ? htmlspecialchars($_POST['uid']) : ''; ?>"
                                                           required>
                                                </div>
                                                <div class="col-md-12 mt-3">
                                                    <input class="form-control" 
                                                           value="Charge ₹<?php echo htmlspecialchars($price['pan_find_fee'] ?? '8'); ?>" 
                                                           readonly>
                                                </div>
                                                <div class="text-left mt-3">
                                                    <button class="form-control btn btn-success" name="submit"> 
                                                        <i class="fa fa-check-circle"></i> Submit
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- RESULT SECTION -->
                                <div class="col-lg-8 col-md-6 col-sm-6">
                                    <div class="card" style="min-height:290px;background-color:#f3fbf4;">
                                        <div class="card-body">
                                            <h6>
                                                Please pay attention. Aadhaar se PAN details nikali ja rahi hain.
                                                Yeh service sirf verification ke liye hai, misuse ke liye nahi.
                                            </h6>
                                            <hr>

                                            <?php if (isset($pan_no) && $pan_no != '' && $pan_no != 'N/A'): ?>
                                                <h6>PAN No : <?php echo htmlspecialchars($pan_no); ?></h6>
                                                <ul class="list-unstyled">
                                                    <li style="color:red">
                                                        <strong>Name :</strong> <?php echo htmlspecialchars($name); ?>
                                                    </li>
                                                    <li>
                                                        <strong>Date of Birth :</strong>
                                                        <b><?php echo htmlspecialchars($dob); ?></b>
                                                    </li>
                                                    <li>
                                                        <strong>Aadhaar :</strong>
                                                        <b><?php echo htmlspecialchars($aadhaar); ?></b>
                                                    </li>
                                                    <li>
                                                        <strong>Status :</strong>
                                                        <span style="color:green; font-weight:bold;">Verified</span>
                                                    </li>
                                                </ul>
                                            <?php else: ?>
                                                <div class="text-center text-muted py-4">
                                                    <i class="fas fa-search fa-3x mb-3"></i>
                                                    <h6>Enter Aadhaar number to fetch PAN details</h6>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <a href="GoodApi_PanFind_list" class="btn btn-dark mt-2">
                                        GO TO PAN FIND LIST
                                        <img width="30" height="30" src="https://img.icons8.com/3d-fluency/94/undo.png" alt="undo"/>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
      
    <!-- Request History Table -->
    <div class="row">
        <div class="col-xl-12">
            <div class="card shadow border-0">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h6 class="mb-0"><i class="fas fa-history me-2"></i>Request History</h6>
                    <?php
                        $resultData = mysqli_query($ahk_conn, "SELECT * FROM instantpan_find WHERE username='$username' ORDER BY id DESC LIMIT 20");
                    ?>
                    <div class="badge bg-primary">Total: <?php echo mysqli_num_rows($resultData); ?></div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="historyTable" class="table table-striped table-hover table-bordered" style="width:100%">
                            <thead class="table-primary">
                                <tr>
                                    <th>#</th>
                                    <th>PAN</th>
                                    <th>Aadhaar</th>
                                    <th>Name</th>
                                    <th>DOB</th>
                                    <th>Charge</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if ($resultData && mysqli_num_rows($resultData) > 0): ?>
                                <?php $count = 1; while ($row = mysqli_fetch_assoc($resultData)): ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?php echo htmlspecialchars($row['pan_no'] ?? 'N/A'); ?></td>
                                        <td><?php echo !empty($row['aadhaar_no']) ? htmlspecialchars($row['aadhaar_no']) : 'N/A'; ?></td>
                                        <td><?php echo htmlspecialchars($row['name'] ?? 'N/A'); ?></td>
                                        <td><?php echo htmlspecialchars($row['dob'] ?? 'N/A'); ?></td>
                                        <td>₹<?php echo htmlspecialchars($row['fee'] ?? '0'); ?></td>
                                        <td>
                                            <?php
                                                $status = strtoupper($row['Status'] ?? 'pending');
                                                $badgeClass = 'bg-secondary';
                                                if ($status == 'SUCCESS') $badgeClass = 'bg-success';
                                                else if ($status == 'PENDING') $badgeClass = 'bg-warning text-dark';
                                                else if ($status == 'REJECT' || $status == 'FAILED') $badgeClass = 'bg-danger';
                                                echo "<span class='badge $badgeClass'>$status</span>";
                                            ?>
                                        </td>
                                        <td><?php echo date('d M Y h:i A', strtotime($row['date'] ?? date('Y-m-d H:i:s'))); ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-inbox fa-2x mb-2"></i><br>No records found
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>

<?php include('../template/akweb/footer.php'); // Note: Fixed typo from 'ahkweb' to 'akweb' ?>