<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $pan = strtoupper(trim($_POST['pan']));

    /* ================= PAN VALIDATION ================= */
    if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]$/', $pan)) {
        echo "<script>
            Swal.fire('Invalid PAN','Enter valid PAN number','warning')
            .then(()=>window.location.href='GoodApi_PanToMaskUid');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "PANMASK".rand(100000,999999);
    $Purpose    = "PAN TO MASK UID";
    $username   = $udata['phone'];
    $fee        = $price['pan_mask_uid_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "http://{$api['url_link']}/api_services/V1/panServices/pan_to_maskuid_S1.php?panNumber=$pan&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'PAN to Mask UID Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_PanToMaskUid');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $panNumber = $resdata['panNumber'] ?? $pan;
    $maskedPan = $resdata['maskedPan'] ?? 'N/A';
    $maskedUid = $resdata['maskedUid'] ?? 'N/A';

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* PAN → MASK UID HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO pan_mask_uid
            (application_no,purpose,username,pan_no,masked_pan,masked_uid,status,statuscode,fee,old_balance,new_balance,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$panNumber','$maskedPan','$maskedUid','$Status','100','$fee','$oldBal','$newBal','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('$maskedUid','$panNumber','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire('Success','Masked Aadhaar Generated Successfully','success')
        .then(()=>window.location.href='#');
    </script>";
}
?>

<!-- PAN TO MASK UID HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">PAN NUMBER TO MASK UID</div>

<form method="POST" class="row g-3">
<div class="col-md-12">
<label>PAN Number</label>
<input name="pan" type="text" class="form-control"
placeholder="ABCDE1234F" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control" value="Charge ₹<?php echo $price['pan_mask_uid_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>
</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="height:290px;background:#f3fbf4;">
<div class="card-body">
<h6>
PAN se Masked Aadhaar nikala ja raha hai.  
Service sirf verification purpose ke liye hai.
</h6>
<hr>

<?php if (isset($maskedUid) && $maskedUid != '') { ?>
<ul>
<li>Masked PAN : <b><?php echo htmlspecialchars($maskedPan); ?></b></li>
<li style="color:red">Masked Aadhaar : <b><?php echo htmlspecialchars($maskedUid); ?></b></li>
<li>Status : <b style="color:green">Verified</b></li>
</ul>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_PanToMaskUid_list" class="btn btn-dark mt-2">
GO TO PAN MASK UID LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<!-- HISTORY -->
<div class="row">
<div class="col-xl-12">
<div class="card shadow border-0">
<div class="card-header bg-light d-flex justify-content-between">
<h6><i class="fas fa-history"></i> Request History</h6>

<?php
$resultData = mysqli_query($ahk_conn,
"SELECT * FROM pan_mask_uid WHERE username='$username' ORDER BY id DESC");
?>
<div class="badge bg-primary">Total: <?php echo mysqli_num_rows($resultData); ?></div>
</div>

<div class="card-body table-responsive">
<table class="table table-bordered table-striped">
<thead class="table-primary">
<tr>
<th>#</th>
<th>Masked UID</th>
<th>Masked PAN</th>
<th>Charge</th>
<th>Status</th>
<th>Date</th>
</tr>
</thead>
<tbody>
<?php if(mysqli_num_rows($resultData)>0){ $i=1; while($row=mysqli_fetch_assoc($resultData)){ ?>
<tr>
<td><?php echo $i++; ?></td>
<td><?php echo $row['masked_uid']; ?></td>
<td><?php echo $row['masked_pan']; ?></td>
<td>₹<?php echo $row['fee']; ?></td>
<td><span class="badge bg-success"><?php echo $row['status']; ?></span></td>
<td><?php echo date('d M Y h:i A',strtotime($row['date'])); ?></td>
</tr>
<?php }} else { ?>
<tr><td colspan="6" class="text-center">No records found</td></tr>
<?php } ?>
</tbody>
</table>
</div>
</div>
</div>
</div>

</div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
