<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['PanNo'])) {

    // -------------------------
    // BASIC USER VARIABLES
    // -------------------------
    $appliedby   = $udata['phone'];
    $old_wallet  = $udata['balance'];
    $fee         = $price['pan_aadharNo_fee'];
    $username    = $udata['username'];

    // -------------------------
    // INPUT
    // -------------------------
    $panNumber = strtoupper(trim($_POST['PanNo']));

    if (empty($panNumber)) {
        echo "<script>Swal.fire('Error','PAN Number is required','error');</script>";
        exit;
    }

    date_default_timezone_set('Asia/Kolkata');
    $timestamp   = date("Y-m-d H:i:s");
    $Tracking_No = "PANUID" . rand(100000, 999999);
    $Purpose     = "PAN TO UID";
    $status      = "success";

    // -------------------------
    // WALLET CHECK
    // -------------------------
    if ($old_wallet < $fee) {
        echo "<script>Swal.fire('Insufficient Balance','Please recharge your wallet','error');</script>";
        exit;
    }

    // -------------------------
    // API URL (NEW)
    // -------------------------
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);
    $apiKey = $api['api_key'];

    $apiUrl = "https://{$api['url_link']}/api_services/V1/panServices/pan_to_uid_S1.php"
        . "?panNumber=" . urlencode($panNumber)
        . "&apiKey=" . urlencode($apiKey);

    // For debugging - you can comment this out after testing
    // echo "API URL: " . $apiUrl . "<br>";

    // -------------------------
    // CURL CALL
    // -------------------------
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);

    $response  = curl_exec($curl);
    $curlError = curl_error($curl);
    $httpCode  = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    // Debug - check raw response
    // echo "<pre>Raw Response: " . htmlspecialchars($response) . "</pre>";

    if ($curlError) {
        echo "<script>Swal.fire('Connection Error','$curlError','error');</script>";
        exit;
    }

    if ($httpCode != 200) {
        echo "<script>Swal.fire('HTTP Error','Server Error $httpCode','error');</script>";
        exit;
    }

    $data = json_decode($response, true);

    if (!$data) {
        echo "<script>Swal.fire('Error','Invalid JSON Response: " . addslashes($response) . "','error');</script>";
        exit;
    }

    if (!isset($data['Status'])) {
        echo "<script>Swal.fire('Error','Invalid API Response Structure','error');</script>";
        exit;
    }

    if ($data['Status'] !== 'Success') {
        $msg = addslashes($data['message'] ?? 'API Failed');
        echo "<script>Swal.fire('API Error','$msg','error');</script>";
        exit;
    }

    // -------------------------
    // RESPONSE DATA - FIXED MAPPING
    // -------------------------
    $pan            = $data['panNumber'] ?? '';
    $aadhaar        = $data['aadhaarNo'] ?? '';  // This should work - field name matches exactly
    $name           = $data['name'] ?? '';
    $fatherName     = $data['father'] ?? '';
    $dob            = $data['dob'] ?? '';
    $api_tracking   = $data['tracking_id'] ?? '';

    // Debug - check extracted values
    /*
    echo "<pre>";
    echo "PAN: $pan\n";
    echo "Aadhaar: $aadhaar\n";
    echo "Name: $name\n";
    echo "Father: $fatherName\n";
    echo "DOB: $dob\n";
    echo "Tracking: $api_tracking\n";
    echo "</pre>";
    */

    // Validate that we got the aadhaar number
    if (empty($aadhaar)) {
        echo "<script>Swal.fire('Error','Aadhaar number not found in response','error');</script>";
        exit;
    }

    $new_wallet = $old_wallet - $fee;

    // -------------------------
    // DB TRANSACTION
    // -------------------------
    mysqli_begin_transaction($ahk_conn);

    try {
        // Escape all strings to prevent SQL injection
        $pan_escaped = mysqli_real_escape_string($ahk_conn, $pan);
        $aadhaar_escaped = mysqli_real_escape_string($ahk_conn, $aadhaar);
        $name_escaped = mysqli_real_escape_string($ahk_conn, $name);
        $fatherName_escaped = mysqli_real_escape_string($ahk_conn, $fatherName);
        $dob_escaped = mysqli_real_escape_string($ahk_conn, $dob);
        $api_tracking_escaped = mysqli_real_escape_string($ahk_conn, $api_tracking);
        $username_escaped = mysqli_real_escape_string($ahk_conn, $username);
        $appliedby_escaped = mysqli_real_escape_string($ahk_conn, $appliedby);

        // WALLET DEBIT
        $wallet_query = "UPDATE users SET balance='$new_wallet' WHERE phone='$appliedby_escaped'";
        if (!mysqli_query($ahk_conn, $wallet_query)) {
            throw new Exception("Wallet update failed: " . mysqli_error($ahk_conn));
        }

        // CARD SUMMARY
        $card_query = "INSERT INTO card_summary
            (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username)
            VALUES
            ('$pan_escaped', '$aadhaar_escaped', '$Purpose', '$api_tracking_escaped', '$status', '$fee', 'Debit',
             '$old_wallet', '$new_wallet', '$timestamp', '$username_escaped')";
        
        if (!mysqli_query($ahk_conn, $card_query)) {
            throw new Exception("Card summary insert failed: " . mysqli_error($ahk_conn));
        }

        // PAN → UID HISTORY
        $history_query = "INSERT INTO pan2uid_find
            (panNo, aadhaar, name, fatherName, dob, status, username, fee, date)
            VALUES
            ('$pan_escaped', '$aadhaar_escaped', '$name_escaped', '$fatherName_escaped', '$dob_escaped', 'success',
             '$appliedby_escaped', '$fee', '$timestamp')";
        
        if (!mysqli_query($ahk_conn, $history_query)) {
            throw new Exception("History insert failed: " . mysqli_error($ahk_conn));
        }

        mysqli_commit($ahk_conn);

        // Format DOB nicely if needed
        $formatted_dob = date("d-m-Y", strtotime(str_replace('/', '-', $dob)));

        // -------------------------
        // SUCCESS ALERT
        // -------------------------
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'PAN to UID Success',
                html: `
                    <div style='text-align: left;'>
                        <b>PAN:</b> $pan<br>
                        <b>Aadhaar:</b> $aadhaar<br>
                        <b>Name:</b> $name<br>
                        <b>Father Name:</b> $fatherName<br>
                        <b>DOB:</b> $formatted_dob<br>
                        <b>Fee:</b> ₹$fee<br>
                        <b>Balance:</b> ₹$new_wallet<br>
                        <b>Tracking ID:</b> $api_tracking
                    </div>
                `
            }).then(() => {
                window.location.href = 'GoodApi_PanToUid_S1_list';
            });
        </script>";

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        $err = addslashes($e->getMessage());
        echo "<script>Swal.fire('Database Error','$err','error');</script>";
    }
}
?>



<!-- HTML FORM AND HISTORY TABLE -->
<div class="page-wrapper">
  <div class="page-content">
    <!-- PAN Form -->
    <div class="row justify-content-center mb-4">
      <div class="col-xl-5">
        <div class="card shadow border-0">
          <div class="card-header bg-primary text-white text-center rounded-top">
            <h5 class="mb-0"><i class="fas fa-search me-2"></i>PAN to Aadhaar Find</h5>
          </div>
          <div class="card-body">
            <form method="POST" id="panForm">
              <div class="form-group mb-3">
                <label for="PanNo" class="form-label">PAN Number <span class="text-danger">*</span></label>
                <input type="text" name="PanNo" id="PanNo" class="form-control text-uppercase" placeholder="Enter PAN Number (e.g., ABCDE1234F)" maxlength="10" required />
              </div>
              <div class="col-md-12 mt-3">
                <input class="form-control" value="Charge ₹<?php echo $price['pan_aadharNo_fee']; ?>" readonly>
                </div>
              <div class="d-grid">
                <button type="submit" name="submit" class="btn btn-primary btn-block">
                  <i class="fas fa-paper-plane me-2"></i>Submit Request
                </button>
              </div>
              <div class="mt-3 text-center">
                <small class="text-muted"><strong>Note:</strong> Fee will be auto-deducted per request.</small>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Request History Table -->
    <div class="row">
      <div class="col-xl-12">
        <div class="card shadow border-0">
          <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h6 class="mb-0"><i class="fas fa-history me-2"></i>Request History</h6>
            <?php
              $resultData = mysqli_query($ahk_conn, "SELECT * FROM pan2uid_find WHERE username='$appliedby' ORDER BY id DESC");
            ?>
            <div class="badge bg-primary">Total: <?php echo mysqli_num_rows($resultData); ?></div>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table id="historyTable" class="table table-striped table-hover table-bordered" style="width:100%">
                <thead class="table-primary">
                  <tr>
                    <th>#</th>
                    <th>PAN</th>
                    <th>Aadhaar</th>
                    <th>Name</th>
                    <th>DOB</th>
                    <th>Charge</th>
                    <th>Status</th>
                    <th>Date</th>
                  </tr>
                </thead>
                <tbody>
                <?php if (mysqli_num_rows($resultData) > 0): ?>
                  <?php $count = 1; while ($row = mysqli_fetch_assoc($resultData)): ?>
                    <tr>
                      <td><?php echo $count++; ?></td>
                      <td><?php echo htmlspecialchars($row['panNo']); ?></td>
                      <td><?php echo !empty($row['aadhaar']) ? htmlspecialchars($row['aadhaar']) : 'N/A'; ?></td>
                      <td><?php echo htmlspecialchars($row['name']); ?></td>
                      <td><?php echo htmlspecialchars($row['dob']); ?></td>
                      <td>₹<?php echo htmlspecialchars($row['fee']); ?></td>
                      <td>
                        <?php
                          $status = strtoupper($row['status']);
                          $badgeClass = [
                            'SUCCESS' => 'bg-success',
                            'PENDING' => 'bg-warning text-dark',
                            'FAILED' => 'bg-danger',
                          ][$status] ?? 'bg-secondary';
                          echo "<span class='badge $badgeClass'>$status</span>";
                        ?>
                      </td>
                      <td><?php echo date('d M Y h:i A', strtotime($row['date'])); ?></td>
                    </tr>
                  <?php endwhile; ?>
                <?php else: ?>
                  <tr>
                    <td colspan="8" class="text-center py-4">
                      <div class="text-muted">
                        <i class="fas fa-inbox fa-2x mb-2"></i><br>No records found
                      </div>
                    </td>
                  </tr>
                <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
