<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* =========================================================
   AUTO PAN ADVANCE (API BASED)
=========================================================*/
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['panNumber'])) {

    $pan_no = strtoupper(trim($_POST['panNumber']));

    /* PAN VALIDATION */
    if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/', $pan_no)) {
        echo "<script>Swal.fire('Invalid PAN','Enter valid PAN number','warning');</script>";
        exit;
    }

    $fee        = $price['pan_advance_fee'];
    $username   = $udata['phone'];
    $oldBal     = $udata['balance'];

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Insufficient Balance','Please recharge wallet','error');
            setTimeout(()=>window.location.href='wallet.php',2000);
        </script>";
        exit;
    }

    /* API CONFIG */
    $api = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM service_api LIMIT 1"));

    /* API CALL */
    $url = "https://{$api['url_link']}/api_services/V1/panServices/pan_details_S1.php?panNumber=$pan_no&apiKey={$api['api_key']}";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
    ]);
    
    $response = curl_exec($curl);
    curl_close($curl);

    $json = json_decode($response, true);

    /* API STATUS CHECK - UPDATED */
    if (!isset($json['Status']) || strtolower($json['Status']) !== 'success') {
        $msg = $json['message'] ?? 'PAN details fetch failed';
        echo "<script>Swal.fire('Failed','$msg','error');</script>";
        exit;
    }

    /* API DATA - CORRECTED FIELD NAMES */
    $name       = $json['name'] ?? '';
    $fathername = $json['father'] ?? '';  // Changed from 'fathername' to 'father'
    $dob        = $json['dob'] ?? '';
    $gender     = $json['gender'] ?? '';
    $category   = $json['category'] ?? '';  // Added category if needed
    $aadhaar_linked = $json['aadhaar_linked'] ?? '';  // Added aadhaar status if needed
    $pan_status = $json['pan_status'] ?? '';  // Added pan status if needed
    $trackingId = $json['tracking_id'] ?? 'PANADV'.time();

    /* WALLET DEDUCT */
    $newBal = $oldBal - $fee;

    mysqli_begin_transaction($ahk_conn);
    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        mysqli_query($ahk_conn,
            "INSERT INTO wallethistory
            (userid, amount, balance, purpose, status, type)
            VALUES
            ('$username','$fee','$oldBal','PAN Advance Print','1','Debit')"
        );

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die("Transaction Failed");
    }

    /* AUTO DATA SESSION (FOR FORM PREFILL) - UPDATED */
    $_SESSION['PAN_ADV'] = [
        'pan' => $pan_no,
        'name' => $name,
        'father' => $fathername,
        'dob' => $dob,
        'gender' => $gender,
        'category' => $category,
        'aadhaar_linked' => $aadhaar_linked,
        'pan_status' => $pan_status,
        'tracking_id' => $trackingId
    ];

    echo "<script>
        Swal.fire('Success','PAN details fetched successfully','success');
    </script>";
}
/* =========================================================
   MANUAL PAN ADVANCE SAVE
=========================================================*/
elseif (isset($_POST['savedata'])) {

    $panno       = trim($_POST['pannumber']);
    $name        = trim($_POST['name']);
    $fathername  = trim($_POST['fathername']);
    $dobadhar    = trim($_POST['dobadhar']);
    $gender      = trim($_POST['gender']);

    if ($panno=="" || $name=="" || $fathername=="" || $dobadhar=="") {
        echo "<script>alert('All fields are required');</script>";
        exit;
    }

    $file = $_FILES['imagefile']['name'];
    $sign = $_FILES['signfile']['name'];

    $target_dir = "uploads/";
    $target_file = $target_dir . basename($file);
    $sign_file   = $target_dir . basename($sign);

    if (!strstr($_FILES['imagefile']['type'],'image') || !strstr($_FILES['signfile']['type'],'image')) {
        echo "<script>alert('Only image files allowed');</script>";
        exit;
    }

    $Traking_No = "PanAdvance" . rand(10000000,99999999);
    $appliedby  = $udata['phone'];
    $fee        = $price['pan_advance_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $timestamp  = date('Y-m-d H:i:s');

    mysqli_begin_transaction($ahk_conn);
    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$appliedby'"
        );

        mysqli_query($ahk_conn,
            "INSERT INTO card_summary
            (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username)
            VALUES
            ('$name','$panno','PAN ADVANCE','$Traking_No','success','$fee','Debit',
             '$oldBal','$newBal','$timestamp','$appliedby')"
        );

        mysqli_query($ahk_conn,
            "INSERT INTO panauto
            (userid,panno,name,fathername,dob,gender,image,signimage,create_time)
            VALUES
            ('$appliedby','$panno','$name','$fathername','$dobadhar','$gender',
             '$target_file','$sign_file','$timestamp')"
        );

        move_uploaded_file($_FILES['imagefile']['tmp_name'],$target_file);
        move_uploaded_file($_FILES['signfile']['tmp_name'],$sign_file);

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die("Manual Save Failed");
    }

    echo "<script>
        Swal.fire('Success','PAN Advance saved successfully','success');
        setTimeout(()=>window.location='Goodapi_Pan_Advance_list',1200);
    </script>";
}

$panData = $_SESSION['PAN_ADV'] ?? [];

$panNumber = $panData['pan'] ?? '';
$name = $panData['name'] ?? '';
$fathername = $panData['father'] ?? '';
$dob = $panData['dob'] ?? '';
$gender = $panData['gender'] ?? '';
?>
<!--start page wrapper -->
<div class="page-wrapper">
<div class="container my-5">
  <div class="card shadow rounded-4">
    <div class="card-header bg-primary text-white rounded-top-4">
      <h4 class="mb-0"><i class="bx bxs-id-card me-2"></i>THIS IS DATA NSDL APIS DONT CHANGE ANI THIS</h4>
    </div>

    <div class="card-body p-4">
      <form method="post" enctype="multipart/form-data" onsubmit="return validation();" autocomplete="off">

        <div class="mb-3">
          <label class="form-label fw-semibold">Select PAN Card Type</label>
          <select name="ptype" id="ptype" class="form-select form-select-lg rounded-pill" required>
            <option value="">-- Select Type --</option>
            <option value="UTI-NONMINOR">(18 साल या उस से ज्यादा उम्र के लिए)</option>
            <option value="NSDL-NONMINOR">NSDL NONMINOR</option>
            <option value="UTI-MINOR">UTI MINOR</option>
            <option value="NSDL-MINOR">NSDL MINOR</option>
          </select>
        </div>

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">PAN Card Number</label>
            <input type="text" name="pannumber" id="pannumber"
              value="<?php echo $panNumber; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              maxlength="10" readonly required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold">Full Name</label>
            <input type="text" name="name"
              value="<?php echo $name; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              readonly required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold">Father's Name</label>
            <input type="text" name="fathername"
              value="<?php echo $fathername; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              readonly required>
          </div>

          <div class="col-md-3">
            <label class="form-label fw-semibold">Date of Birth</label>
            <input type="text" name="dobadhar"
              value="<?php echo $dob; ?>"
              class="form-control form-control-lg rounded-pill"
              readonly required>
          </div>

          <div class="col-md-3">
            <label class="form-label fw-semibold">Gender</label>
            <select name="gender" class="form-select form-select-lg rounded-pill" readonly required>
              <option value="<?php echo $gender; ?>"><?php echo $gender; ?></option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold" id="stype">Upload Photo</label>
            <input type="file" name="imagefile" class="form-control form-control-lg rounded-pill" required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold" id="simgs">Upload Signature</label>
            <input type="file" name="signfile" class="form-control form-control-lg rounded-pill" required>
          </div>
        </div>

        <div class="mt-4 d-flex justify-content-between align-items-center">
          <h5 class="text-warning">
            Application Fee: ₹<?php echo $price['pan_advance_fee']; ?>
          </h5>
          <button type="submit" name="savedata" class="btn btn-lg btn-success rounded-pill px-5">
            <i class="bi bi-check2-circle me-1"></i> Submit
          </button>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
function validation() {
  const pan = document.getElementById("pannumber");
  const error = document.getElementById("erroraadharno");
  if (pan.value.length !== 10) {
    error.innerText = "Please enter a valid 10-digit PAN number.";
    pan.classList.add("is-invalid");
    pan.focus();
    return false;
  }
  return true;
}

function ValidatePAN() {
  const pan = document.getElementById("pannumber");
  const pattern = /^([A-Z]{5})(\d{4})([A-Z]{1})$/;
  if (pan.value && !pattern.test(pan.value)) {
    alert("Invalid PAN format (Example: ABCDE1234F)");
    pan.value = '';
    pan.focus();
    return false;
  }
}

function previewImage(input, targetImg, hiddenInput) {
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = function (e) {
      document.getElementById(targetImg).src = e.target.result;
      document.getElementById(targetImg).classList.remove("d-none");
      document.getElementById(hiddenInput).value = e.target.result;
    };
    reader.readAsDataURL(input.files[0]);
  }
}

document.getElementById("imgInp").addEventListener("change", function () {
  previewImage(this, 'blah', 'blahin');
});
document.getElementById("signInp").addEventListener("change", function () {
  previewImage(this, 'blahs', 'blahsin');
});

// Hide Signature Field for MINOR
document.getElementById("ptype").addEventListener("change", function () {
  const isMinor = this.value.includes("MINOR");
  document.getElementById("signInp").style.display = isMinor ? "none" : "block";
  document.getElementById("simgs").style.display = isMinor ? "none" : "block";
});
</script>
		<?php 
		include('footer.php');
		?>
	<!-- Bootstrap JS -->
	<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/ahkweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
<script>
	$(document).ready(function() {
	
	$('#eid').inputmask();
	$('#date').inputmask();
	$('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        // hourFormat: 24
      });
	});
</script>
</html>