<?php
include('../includes/session.php');
include('../includes/config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $rationNumber = trim(mysqli_real_escape_string($ahk_conn, $_POST['rationNumber']));

    if(empty($rationNumber)){
        die("Ration Number Required");
    }

    // ===== USER DATA =====
    $Traking_No = "RCPDF".rand(100000,999999);
    $Purpose    = "RATION CARD PDF";
    $username   = $udata['phone'];
    $fee        = $price['ration_pdf_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    // ===== BALANCE CHECK =====
    if ($oldBal < $fee) {
        echo "<script>alert('Low Balance!'); window.location='wallet.php';</script>";
        exit;
    }
    // -------------------------
    // API URL (NEW)
    // -------------------------
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);
    $apiKey = $api['api_key'];

    $url = "https://{$api['url_link']}/api_services/V1/rasanServices/ration_pdf_S1.php?apiKey=".$apiKey."&rationNumber=".$rationNumber;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    $response = curl_exec($ch);

    if(curl_errno($ch)){
        die("API Error: ".curl_error($ch));
    }

    curl_close($ch);

    $resdata = json_decode($response, true);

    if(!isset($resdata['Status']) || $resdata['Status'] != 'Success'){
        $msg = isset($resdata['message']) ? $resdata['message'] : 'PDF Generate Failed';
        echo "<script>alert('$msg'); window.location='GoodApi_Ration_PDF';</script>";
        exit;
    }

    // ===== PDF DATA =====
    $pdfBase64 = $resdata['pdf_base64'];
    $headName  = mysqli_real_escape_string($ahk_conn, $resdata['head_name']);
    $fileName  = preg_replace('/[^A-Za-z0-9_\-\.]/', '_', $resdata['file_name']);
    $apiTrack  = mysqli_real_escape_string($ahk_conn, $resdata['transaction_id']);

    $pdfData = base64_decode($pdfBase64, true);

    if ($pdfData === false) {
        die("Base64 Decode Failed");
    }

    // ===== DATABASE TRANSACTION =====
    mysqli_begin_transaction($ahk_conn);

    try {

        mysqli_query($ahk_conn, "UPDATE users SET balance='$newBal' WHERE phone='$username'");

        mysqli_query($ahk_conn, "INSERT INTO ration_pdf 
        (tracking_no, purpose, username, ration_no, head_name, pdf_file, status, fee, old_balance, new_balance, api_tracking_id, date) 
        VALUES 
        ('$Traking_No', '$Purpose', '$username', '$rationNumber', '$headName', '$pdfBase64', '$Status', '$fee', '$oldBal', '$newBal', '$apiTrack', '$timestamp')");

        mysqli_query($ahk_conn, "INSERT INTO card_summary 
        (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username) 
        VALUES 
        ('RATION PDF', '$rationNumber', '$Purpose', '$Traking_No', '$Status', '$fee', 'Debit', '$oldBal', '$newBal', '$timestamp', '$username')");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {

        mysqli_rollback($ahk_conn);
        die("Database Error");
    }

    // ===== DIRECT PDF DOWNLOAD =====
    if (ob_get_length()) {
        ob_end_clean();
    }

    header("Content-Type: application/pdf");
    header("Content-Disposition: attachment; filename=\"$fileName\"");
    header("Content-Length: " . strlen($pdfData));
    header("Cache-Control: no-cache, no-store, must-revalidate");
    header("Pragma: no-cache");
    header("Expires: 0");

    echo $pdfData;
    exit;
}

include('../template/ahkweb/header.php');
?>

<!-- HTML FORM -->

<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">
<div class="row">

<div class="col-md-6">
<div class="card">
<div class="card-body">

<h4 class="text-danger">RATION CARD PDF</h4>
<hr>

<form method="POST">

<div class="form-group">
<label>Ration Card Number</label>
<input type="text" name="rationNumber" class="form-control" placeholder="Enter Ration Number" required>
</div>

<div class="form-group mt-3">
<label>Charge</label>
<input type="text" class="form-control" value="₹<?php echo $price['ration_pdf_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button type="submit" name="submit" class="btn btn-success btn-block">
Generate PDF
</button>
</div>

</form>

</div>
</div>
</div>

<div class="col-md-6">
<div class="card">
<div class="card-body">
<h5>Note:</h5>
<p>राशन कार्ड नंबर डालें और PDF जनरेट करें।</p>
<p>Current Balance: ₹<?php echo $udata['balance']; ?></p>
<hr>
<a href="GoodApi_RationPdf_list" class="btn btn-dark">PDF List देखें</a>
</div>
</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
