<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $type   = $_POST['type'];          // A or R
    $ration = trim($_POST['ration']);  // Aadhaar or Ration No

    /* ================= VALIDATION ================= */
    if ($type == 'A' && !preg_match('/^[0-9]{12}$/', $ration)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning')
            .then(()=>window.location.href='GoodApi_RationSleep');
        </script>";
        exit;
    }

    if ($type == 'R' && !preg_match('/^[0-9]{8,20}$/', $ration)) {
        echo "<script>
            Swal.fire('Invalid Ration Number','Enter valid Ration Card Number','warning')
            .then(()=>window.location.href='GoodApi_RationSleep');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "RAT".rand(100000,999999);
    $Purpose    = "RATION SLEEP PDF";
    $username   = $udata['phone'];
    $fee        = $price['ration_sleep_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/rasanServices/ration_sleep.php"
         . "?rationNumber=$ration&type=$type&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Ration Sleep Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_RationSleep');
        </script>";
        exit;
    }

    /* ================= PDF PROCESS ================= */
    $pdfRaw = $resdata['pdf_base64'] ?? '';
    if ($pdfRaw == '') {
        die('PDF not found');
    }

    $pdfBase64 = preg_replace('#^data:application/pdf;base64,#', '', $pdfRaw);
    $pdfData   = base64_decode($pdfBase64);

    $fileName = "RATION_SLEEP_{$Traking_No}.pdf";
    $dirPath  = "../uploads/ration_sleep/";
    $filePath = $dirPath.$fileName;

    if (!is_dir($dirPath)) {
        mkdir($dirPath, 0777, true);
    }

    file_put_contents($filePath, $pdfData);

    $hofName  = $resdata['hof_name'] ?? 'N/A';
    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);
    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        mysqli_query($ahk_conn,"
            INSERT INTO ration_sleep
            (application_no,purpose,username,type,input_no,hof_name,pdf_file,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$type','$ration','$hofName','$fileName','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('Ration Sleep','$ration','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire({
          title: 'Success',
          html: 'Ration Sleep PDF generated successfully.<br><br>
                 <a href=\"$filePath\" target=\"_blank\" class=\"btn btn-success\">Download PDF</a>',
          icon: 'success'
        });
    </script>";
}
?>
<!-- RATION SLEEP HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">RATION SLEEP PDF</div>

<form method="POST" class="row g-3">

<div class="col-md-12">
<label>Select Type</label>
<select name="type" class="form-control" required>
  <option value="A">Aadhaar Number</option>
  <option value="R">Ration Card Number</option>
</select>
</div>

<div class="col-md-12">
<label>Enter Aadhaar / Ration Number</label>
<input name="ration" class="form-control"
placeholder="Enter Aadhaar or Ration No" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['ration_sleep_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>

</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="height:290px;background:#f3fbf4;">
<div class="card-body">
<h6>
Aadhaar / Ration Card ke through Ration Sleep PDF generate ki ja rahi hai.
</h6>
<hr>

<?php if (isset($fileName)) { ?>
<p>
<b>HOF Name:</b> <?php echo htmlspecialchars($hofName); ?><br><br>
<a href="<?php echo $filePath; ?>" target="_blank" class="btn btn-success">
Download Ration Sleep PDF
</a>
</p>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_RationSleep_list" class="btn btn-dark mt-2">
GO TO RATION SLEEP LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>
