<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

$s_phone = $udata['phone'];
?>

<!-- Datatable -->
<script>
$(document).ready(function () {
    $('#default-datatable').DataTable();
});
</script>

<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-content">

<div class="card radius-10">
<div class="card-body">

<div class="d-flex align-items-center">
    <h5 class="mb-0">RATION SLEEP PDF LIST</h5>
</div>

<hr>

<div class="table-responsive">
<table id="default-datatable" class="table table-bordered table-striped" width="100%">

<thead style="background:linear-gradient(-62deg,#3a3a53,#03a9f4);color:white">
<tr>
    <th>#</th>
    <th>Application No</th>
    <th>Purpose</th>
    <th>Input No</th>
    <th>HOF Name</th>
    <th>Status</th>
    <th>Fee</th>
    <th>Date</th>
    <th>PDF</th>
</tr>
</thead>

<tbody>
<?php
if (checkAdmin($udata['type']) == false) {
    $sql = mysqli_query($ahk_conn, "SELECT * FROM ration_sleep ORDER BY id DESC");
} else {
    $sql = mysqli_query($ahk_conn, "SELECT * FROM ration_sleep WHERE username='$s_phone' ORDER BY id DESC");
}

$sl = 1;
while ($data = mysqli_fetch_assoc($sql)) {
?>
<tr>
    <td><?= $sl++; ?></td>
    <td><?= htmlspecialchars($data['application_no']); ?></td>
    <td><?= htmlspecialchars($data['purpose']); ?></td>
    <td><?= htmlspecialchars($data['input_no']); ?></td>
    <td><?= htmlspecialchars($data['hof_name']); ?></td>

    <td>
        <?php if($data['status']=="SUCCESS"){ ?>
            <span class="badge bg-success">SUCCESS</span>
        <?php } else { ?>
            <span class="badge bg-danger">FAILED</span>
        <?php } ?>
    </td>

    <td>₹ <?= number_format($data['fee'],2); ?></td>
    <td><?= $data['date']; ?></td>

    <td class="text-center">
        <?php if(!empty($data['pdf_file'])){ ?>
            <a href="<?= $data['pdf_file']; ?>" download>
                <img src="https://cdn-icons-png.flaticon.com/512/337/337946.png" width="40">
            </a>
        <?php } else { ?>
            <span class="text-danger">N/A</span>
        <?php } ?>
    </td>
</tr>
<?php } ?>
</tbody>

</table>
</div>

</div>
</div>

</div>
</div>
<!--end page wrapper -->

<?php include('../template/ahkweb/footer.php'); ?>
