<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('../includes/session.php');
include('../includes/config.php');

$bik_number = $name = $address = $tracking_id = $pdf_url = "";

/* ================= SUBMIT ================= */

if (isset($_POST['find'])) {

    $rc_no = strtoupper(trim($_POST['rc_dl']));
    $appliedby = $udata['phone'];
    $username  = $udata['phone'];

    $fee = isset($price['Rc_fee']) ? $price['Rc_fee'] : 30;
    $old_wallet = $udata['balance'];

    if ($old_wallet < $fee) {
        echo "<script>alert('Insufficient Balance');location='wallet.php';</script>";
        exit;
    }

    /* ================= API CONFIG ================= */

    $apiRow = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT * FROM service_api LIMIT 1"));
    $apiKey = $apiRow['api_key'];
    $base   = $apiRow['url_link'];

    $url = "https://{$base}/api_services/V1/vahanServices/vehicle_rc_pdf_S2.php?apiKey={$apiKey}&rcno={$rc_no}";

    /* ================= CURL ================= */

    $ch = curl_init();
    curl_setopt_array($ch,[
        CURLOPT_URL=>$url,
        CURLOPT_RETURNTRANSFER=>true,
        CURLOPT_TIMEOUT=>40
    ]);

    $response = curl_exec($ch);

    if(curl_errno($ch)){
        die("Curl Error: ".curl_error($ch));
    }

    curl_close($ch);

    $result = json_decode($response,true);
    if(!$result) die("Invalid API JSON");

    if($result['StatusCode'] != 100){
        die($result['message']);
    }

    $bik_number = $result['rcno'];
    $name       = $result['name'];
    $address    = $result['address'];
    $tracking_id= $result['tracking_id'];

    /* ================= PDF SAVE ================= */

/* ================= PDF BASE64 FIX ================= */

$pdf_base64 = $result['pdf'];

// remove line breaks + tabs + spaces
$pdf_base64 = preg_replace('/\s+/', '', $pdf_base64);

// keep only valid base64 chars
$pdf_base64 = preg_replace('/[^A-Za-z0-9+\/=]/', '', $pdf_base64);

// fix padding if missing
$pad = strlen($pdf_base64) % 4;
if ($pad > 0) {
    $pdf_base64 .= str_repeat('=', 4 - $pad);
}

$pdf_data = base64_decode($pdf_base64);

if ($pdf_data === false || strlen($pdf_data) < 100) {
    die("PDF decode failed — corrupted base64 from API");
}

/* ===== PDF SAVE — ABSOLUTE PATH ===== */

// project root detect
$rootPath = $_SERVER['DOCUMENT_ROOT'];

$dir = $rootPath . '/admin/uploads/rc_pdfs/';  
// agar uploads admin ke bahar hai to use karo:
// $dir = $rootPath . '/uploads/rc_pdfs/';

if (!is_dir($dir)) {
    mkdir($dir, 0777, true);
}

$filename = 'rc_' . $bik_number . '_' . time() . '.pdf';
$fullpath = $dir . $filename;

$bytes = file_put_contents($fullpath, $pdf_data);

if ($bytes === false) {
    die("PDF save failed at: " . $fullpath);
}

$pdf_url = 'uploads/rc_pdfs/' . $filename;   // browser path


    /* ================= DB ================= */

    date_default_timezone_set("Asia/Kolkata");
    $ts = date('Y-m-d H:i:s');

    $new_wallet = $old_wallet - $fee;

    mysqli_query($ahk_conn,"
        INSERT INTO rc_vehical
        (username,rc_vehical_no,status,pdf,date,tracking_id)
        VALUES
        ('$username','$bik_number','success','$pdf_url','$ts','$tracking_id')
    ");

    mysqli_query($ahk_conn,"
        UPDATE users SET balance='$new_wallet'
        WHERE phone='$username'
    ");

    mysqli_query($ahk_conn,"
        INSERT INTO card_summary
        (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
        VALUES
        ('$username','$bik_number','RC PDF','$tracking_id','success',
        '$fee','Debit','$old_wallet','$new_wallet','$ts','$username')
    ");
}

include('../template/ahkweb/header.php');
?>

<!-- ================= HTML ================= -->

<div class="container mt-4">

<div class="card p-3">
<h5>Vehicle RC PDF Find</h5>

<form method="POST">
<input name="rc_dl" class="form-control"
placeholder="Enter RC Number"
required>

<input class="form-control mt-2"
value="Charge ₹<?php echo isset($price['Rc_fee'])?$price['Rc_fee']:30; ?>"
readonly>

<button class="btn btn-success mt-2" name="find">
Get RC PDF
</button>
</form>
</div>


<?php if($bik_number!=""): ?>
<div class="card p-3 mt-3">
<h6>Result</h6>
RC: <?php echo $bik_number ?><br>
Tracking: <?php echo $tracking_id ?><br>
<a href="<?php echo $pdf_url ?>" target="_blank"
class="btn btn-primary mt-2">
Download PDF
</a>
</div>
<?php endif; ?>


<?php
$username = $udata['phone'];
$q = mysqli_query($ahk_conn,"SELECT * FROM rc_vehical WHERE username='$username' ORDER BY id DESC");
?>

<div class="card mt-4 p-3">
<h6>History</h6>

<table class="table table-bordered">
<tr>
<th>#</th>
<th>RC</th>
<th>Tracking</th>
<th>PDF</th>
<th>Date</th>
</tr>

<?php $i=1; while($r=mysqli_fetch_assoc($q)): ?>
<tr>
<td><?php echo $i++ ?></td>
<td><?php echo $r['rc_vehical_no'] ?></td>
<td><?php echo $r['tracking_id'] ?></td>
<td>
<a href="<?php echo $r['pdf'] ?>" target="_blank">View</a>
</td>
<td><?php echo $r['date'] ?></td>
</tr>
<?php endwhile; ?>

</table>
</div>

</div>

<?php include('../template/ahkweb/footer.php'); ?>
