<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uid = trim($_POST['uid']);

    /* ================= UID VALIDATION ================= */
    if (!preg_match('/^\d{12}$/', $uid)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning')
            .then(()=>window.location.href='GoodApi_UidMaskPan');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "UIDPAN".rand(100000,999999);
    $Purpose    = "UID TO MASK PAN";
    $username   = $udata['phone'];
    $fee        = $price['uid_mask_pan_fee']; // price table me add kare
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API DETAILS ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/aadharServices/aadhar_to_maskpan_S1.php?uidNumber=$uid&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'UID to PAN Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_UidMaskPan');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $uidNumber = $resdata['uidNumber'] ?? 'N/A';
    $maskedUid = $resdata['maskedUid'] ?? 'N/A';
    $maskedPan = $resdata['maskedPan'] ?? 'N/A';

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* UID MASK PAN HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO uid_mask_pan
            (application_no,purpose,username,uid_no,masked_uid,masked_pan,status,statuscode,fee,old_balance,new_balance,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$uid','$maskedUid','$maskedPan','$Status','100','$fee','$oldBal','$newBal','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('$maskedPan','$uid','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die("Transaction Failed");
    }

    echo "<script>
        Swal.fire('Success','Masked PAN Generated Successfully','success')
        .then(()=>window.location.href='#');
    </script>";
}
?>
<!-- UID TO MASK PAN HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="col-lg-12">
      <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
        <div class="stat-content">
          <div class="stat-text">
            <div class="container-fluid">
              <div class="row">

                <!-- INPUT SECTION -->
                <div class="col-lg-4 col-md-6 col-sm-6">
                  <div class="card">
                    <div class="card-body">
                      <div class="alert alert-danger">
                        AADHAAR NUMBER TO MASK PAN
                      </div>

                      <form action="" method="POST" class="row g-3">
                        <div class="col-md-12">
                          <label>Aadhaar Number</label>
                          <input name="uid" type="text" maxlength="12" minlength="12"
                                 placeholder="Enter 12 Digit Aadhaar"
                                 class="form-control" required>
                        </div>

                        <div class="col-md-12 mt-3">
                          <input class="form-control"
                                 value="Charge ₹<?php echo $price['uid_mask_pan_fee']; ?>"
                                 readonly>
                        </div>

                        <div class="text-left mt-3">
                          <button class="form-control btn btn-success" name="submit">
                            <i class="fa fa-check-circle"></i> Submit
                          </button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>

                <!-- RESULT SECTION -->
                <div class="col-lg-8 col-md-6 col-sm-6">
                  <div class="card" style="height:290px;background-color:#f3fbf4;">
                    <div class="card-body">
                      <h6>
                        Please pay attention. Aadhaar se Masked PAN nikala ja raha hai.
                        Yeh service sirf verification ke liye hai, misuse ke liye nahi.
                      </h6>
                      <hr>

                      <?php if (isset($maskedPan) && $maskedPan != '') { ?>
                        <ul>
                          <li>
                            Aadhaar :
                            <b><?php echo htmlspecialchars($maskedUid); ?></b>
                          </li>
                          <li style="color:red">
                            Masked PAN :
                            <b><?php echo htmlspecialchars($maskedPan); ?></b>
                          </li>
                          <li>
                            Status :
                            <b style="color:green">Verified</b>
                          </li>
                        </ul>
                      <?php } else { ?>
                        <h6>Data Found To Details Show ...</h6>
                      <?php } ?>
                    </div>
                  </div>

                  <a href="GoodApi_UidMaskPan_list" class="btn btn-dark mt-2">
                    GO TO UID MASK PAN LIST
                    <img width="30" height="30"
                         src="https://img.icons8.com/3d-fluency/94/undo.png"
                         alt="undo"/>
                  </a>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <br>

    <!-- REQUEST HISTORY TABLE -->
    <div class="row">
      <div class="col-xl-12">
        <div class="card shadow border-0">
          <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h6 class="mb-0">
              <i class="fas fa-history me-2"></i>Request History
            </h6>

            <?php
              $resultData = mysqli_query(
                $ahk_conn,
                "SELECT * FROM uid_mask_pan WHERE username='$username' ORDER BY id DESC"
              );
            ?>

            <div class="badge bg-primary">
              Total: <?php echo mysqli_num_rows($resultData); ?>
            </div>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table id="historyTable" class="table table-striped table-hover table-bordered" style="width:100%">
                <thead class="table-primary">
                  <tr>
                    <th>#</th>
                    <th>Masked PAN</th>
                    <th>Aadhaar</th>
                    <th>Charge</th>
                    <th>Status</th>
                    <th>Date</th>
                  </tr>
                </thead>

                <tbody>
                <?php if (mysqli_num_rows($resultData) > 0): ?>
                  <?php $count = 1; while ($row = mysqli_fetch_assoc($resultData)): ?>
                    <tr>
                      <td><?php echo $count++; ?></td>
                      <td><?php echo htmlspecialchars($row['masked_pan']); ?></td>
                      <td><?php echo htmlspecialchars($row['masked_uid']); ?></td>
                      <td>₹<?php echo htmlspecialchars($row['fee']); ?></td>
                      <td>
                        <?php
                          $status = strtoupper($row['status']);
                          $badgeClass = [
                            'SUCCESS' => 'bg-success',
                            'PENDING' => 'bg-warning text-dark',
                            'FAILED'  => 'bg-danger',
                          ][$status] ?? 'bg-secondary';
                          echo "<span class='badge $badgeClass'>$status</span>";
                        ?>
                      </td>
                      <td><?php echo date('d M Y h:i A', strtotime($row['date'])); ?></td>
                    </tr>
                  <?php endwhile; ?>
                <?php else: ?>
                  <tr>
                    <td colspan="6" class="text-center py-4">
                      <div class="text-muted">
                        <i class="fas fa-inbox fa-2x mb-2"></i><br>
                        No records found
                      </div>
                    </td>
                  </tr>
                <?php endif; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>