<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uid = trim($_POST['uid']);

    /* ================= UID VALIDATION ================= */
    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning')
            .then(()=>window.location.href='GoodApi_UidName');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "UIDNM".rand(100000,999999);
    $Purpose    = "UID TO NAME";
    $username   = $udata['phone'];
    $fee        = $price['uid_name_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/aadharServices/aadhar_name_find.php?uidNumber=$uid&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'UID Name Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_UidName');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $apiUid     = $resdata['uid'] ?? $uid;
    $name       = $resdata['name'] ?? 'N/A';
    $localName  = $resdata['localName'] ?? 'N/A';
    $mobile     = $resdata['mobile'] ?? 'N/A';
    $apiTrack   = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* UID NAME HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO uid_name_find
            (application_no,purpose,username,uid,name,local_name,mobile,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$apiUid','$name','$localName','$mobile','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('$name','$apiUid','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire('Success','Aadhaar Name Fetched Successfully','success')
        .then(()=>window.location.href='#');
    </script>";
}
?>
<!-- UID TO NAME HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="col-lg-12">
      <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
        <div class="container-fluid">
          <div class="row">

            <!-- INPUT SECTION -->
            <div class="col-lg-4 col-md-6 col-sm-6">
              <div class="card">
                <div class="card-body">
                  <div class="alert alert-danger">
                    AADHAAR NUMBER TO NAME
                  </div>

                  <form method="POST" class="row g-3">
                    <div class="col-md-12">
                      <label>Aadhaar Number</label>
                      <input name="uid"
                             type="text"
                             maxlength="12"
                             placeholder="Enter 12 Digit Aadhaar"
                             class="form-control"
                             required>
                    </div>

                    <div class="col-md-12 mt-3">
                      <input class="form-control"
                             value="Charge ₹<?php echo $price['uid_name_fee']; ?>"
                             readonly>
                    </div>

                    <div class="mt-3">
                      <button class="form-control btn btn-success" name="submit">
                        <i class="fa fa-check-circle"></i> Submit
                      </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>

            <!-- RESULT SECTION -->
            <div class="col-lg-8 col-md-6 col-sm-6">
              <div class="card" style="height:290px;background:#f3fbf4;">
                <div class="card-body">
                  <h6>
                    Aadhaar number ke through Name verify kiya ja raha hai.
                    Yeh service sirf verification purpose ke liye hai.
                  </h6>
                  <hr>

                  <?php if (isset($name) && $name != '') { ?>
                    <ul>
                      <li style="color:red">
                        Name :
                        <b><?php echo htmlspecialchars($name); ?></b>
                      </li>
                      <li>
                        Local Name :
                        <b><?php echo htmlspecialchars($localName); ?></b>
                      </li>
                      <li>
                        Mobile :
                        <b><?php echo htmlspecialchars($mobile); ?></b>
                      </li>
                      <li>
                        Status :
                        <b style="color:green">Verified</b>
                      </li>
                    </ul>
                  <?php } else { ?>
                    <h6>Data Found To Details Show ...</h6>
                  <?php } ?>
                </div>
              </div>

              <a href="GoodApi_UidName_list" class="btn btn-dark mt-2">
                GO TO UID NAME LIST
                <img width="30" height="30"
                     src="https://img.icons8.com/3d-fluency/94/undo.png"
                     alt="undo"/>
              </a>
            </div>

          </div>
        </div>
      </div>
    </div>

    <br>

    <!-- REQUEST HISTORY TABLE -->
    <div class="row">
      <div class="col-xl-12">
        <div class="card shadow border-0">
          <div class="card-header bg-light d-flex justify-content-between">
            <h6><i class="fas fa-history me-2"></i>Request History</h6>

            <?php
              $resultData = mysqli_query(
                $ahk_conn,
                "SELECT * FROM uid_name_find WHERE username='$username' ORDER BY id DESC"
              );
            ?>

            <div class="badge bg-primary">
              Total: <?php echo mysqli_num_rows($resultData); ?>
            </div>
          </div>

          <div class="card-body table-responsive">
            <table class="table table-bordered table-striped">
              <thead class="table-primary">
                <tr>
                  <th>#</th>
                  <th>Aadhaar</th>
                  <th>Name</th>
                  <th>Mobile</th>
                  <th>Charge</th>
                  <th>Status</th>
                  <th>Date</th>
                </tr>
              </thead>
              <tbody>
              <?php if(mysqli_num_rows($resultData)>0){ $i=1; while($row=mysqli_fetch_assoc($resultData)){ ?>
                <tr>
                  <td><?php echo $i++; ?></td>
                  <td><?php echo htmlspecialchars($row['uid']); ?></td>
                  <td><?php echo htmlspecialchars($row['name']); ?></td>
                  <td><?php echo htmlspecialchars($row['mobile']); ?></td>
                  <td>₹<?php echo $row['fee']; ?></td>
                  <td><span class="badge bg-success"><?php echo $row['status']; ?></span></td>
                  <td><?php echo date('d M Y h:i A',strtotime($row['date'])); ?></td>
                </tr>
              <?php }} else { ?>
                <tr>
                  <td colspan="7" class="text-center">No records found</td>
                </tr>
              <?php } ?>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>

  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
