<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* =====================================================
   CAPTCHA GENERATE (UPDATED RESPONSE KEYS)
===================================================== */

$captchaImg   = '';
$captchaTxnId = '';

$AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
$api = mysqli_fetch_assoc($AWS_api);

$captchaUrl = "https://{$api['url_link']}/api_services/V1/aadharServices/aadhar_captcha.php?apiKey={$api['api_key']}";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $captchaUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: application/json',
    'User-Agent: Mozilla/5.0'
]);

$response = curl_exec($ch);
curl_close($ch);

$captchaData = json_decode($response, true);

/* 🔑 HANDLE NEW RESPONSE FORMAT */
if (
    isset($captchaData['imageBase64']) &&
    isset($captchaData['transactionId'])
) {
    $captchaImg   = $captchaData['imageBase64'];   // base64 image
    $captchaTxnId = $captchaData['transactionId']; // txn id
}


/* =====================================================
   2️⃣ VERIFY AADHAAR (FORM SUBMIT)
===================================================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

   $uid     = trim($_POST['uid'] ?? '');
$captcha = trim($_POST['captcha'] ?? '');
$captchaTxnId = trim($_POST['captchaTxnId'] ?? '');

if ($uid == '' || $captcha == '' || $captchaTxnId == '') {
    Swal.fire('Error','Captcha expired. Please refresh and try again','warning');
    exit;
}

    /* ---------- BASIC VALIDATION ---------- */
    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning');
        </script>";
        exit;
    }

    if ($captcha === '' || $txnId === '') {
        echo "<script>
            Swal.fire('Captcha Error','Captcha expired or missing. Please refresh and try again','warning')
            .then(()=>window.location.reload());
        </script>";
        exit;
    }

    /* ---------- WALLET DATA ---------- */
    $Traking_No = "UIDV" . rand(100000, 999999);
    $Purpose    = "AADHAAR VERIFY";
    $username   = $udata['phone'];
    $fee        = $price['aadhaar_verify_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ---------- API CALL ---------- */
$verifyUrl = "https://{$api['url_link']}/api_services/V1/aadharServices/aadhar_verify.php"
           . "?uid=" . urlencode($uid)
           . "&captcha=" . urlencode($captcha)
           . "&captchaTxnId=" . urlencode($captchaTxnId)
           . "&transactionId=" . urlencode($captchaTxnId)
           . "&captchaTransactionId=" . urlencode($captchaTxnId)
           . "&apiKey={$api['api_key']}";



    $verifyResponse = @file_get_contents($verifyUrl);
    $resdata = json_decode($verifyResponse, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Aadhaar verification failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.reload());
        </script>";
        exit;
    }

    /* ---------- API RESULT ---------- */
    $gender   = $resdata['gender'] ?? 'N/A';
    $age      = $resdata['age'] ?? 'N/A';
    $mobile   = $resdata['mobile'] ?? 'N/A';
    $address  = $resdata['address'] ?? 'N/A';
    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* =====================================================
       3️⃣ TRANSACTION START
    ===================================================== */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* Wallet Update */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* Aadhaar Verify History */
        mysqli_query($ahk_conn,"
            INSERT INTO aadhaar_verify
            (application_no,purpose,username,uid,gender,age,mobile,address,status,statuscode,
             fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$uid','$gender','$age','$mobile','$address',
             '$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* Card Summary */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,
             old_balance,new_balance,date,username)
            VALUES
            ('Aadhaar Verify','$uid','$Purpose','$Traking_No','$Status','$fee','Debit',
             '$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    /* ---------- SUCCESS ---------- */
    echo "<script>
        Swal.fire('Success','Aadhaar verified successfully','success');
    </script>";
}
?>

<!-- AADHAAR CAPTCHA VERIFY HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="row">

      <!-- INPUT SECTION -->
      <div class="col-lg-4 col-md-6 col-sm-12">
        <div class="card">
          <div class="card-body">

            <div class="alert alert-danger text-center">
              AADHAAR VERIFY (CAPTCHA)
            </div>

            <form method="POST" autocomplete="off">

              <!-- Aadhaar -->
              <div class="mb-2">
                <label>Aadhaar Number</label>
                <input type="text"
                       name="uid"
                       maxlength="12"
                       minlength="12"
                       class="form-control"
                       placeholder="Enter 12 Digit Aadhaar"
                       required>
              </div>

              <!-- CAPTCHA IMAGE -->
              <div class="mb-2 text-center">
<?php if (!empty($captchaImg) && !empty($captchaTxnId)) { ?>
    <img src="<?php echo $captchaImg; ?>" style="border:1px solid #ccc;">
    <input type="hidden" name="captchaTxnId" value="<?php echo $captchaTxnId; ?>">
<?php } ?>


              </div>

              <!-- Captcha Input -->
              <div class="mb-2">
                <label>Enter Captcha</label>
                <input type="text"
                       name="captcha"
                       class="form-control"
                       placeholder="Enter captcha"
                       required>
              </div>

              <!-- Charge -->
              <div class="mb-2">
                <input class="form-control"
                       value="Charge ₹<?php echo $price['aadhaar_verify_fee']; ?>"
                       readonly>
              </div>

              <!-- Buttons -->
              <div class="d-flex gap-2">
                <button type="submit"
                        name="submit"
                        class="btn btn-success w-100">
                  <i class="fa fa-check-circle"></i> Verify
                </button>

                <button type="button"
                        onclick="location.reload();"
                        class="btn btn-secondary w-100">
                  🔄 Refresh
                </button>
              </div>

            </form>

          </div>
        </div>
      </div>

      <!-- RESULT SECTION -->
      <div class="col-lg-8 col-md-6 col-sm-12">
        <div class="card" style="background:#f3fbf4;">
          <div class="card-body">

            <h6>
              Aadhaar captcha ke through UID verify kiya ja raha hai.
              Yeh service sirf verification purpose ke liye hai.
            </h6>
            <hr>

            <?php if (isset($gender)) { ?>
              <ul>
                <li><b>Gender :</b> <?php echo htmlspecialchars($gender); ?></li>
                <li><b>Age Group :</b> <?php echo htmlspecialchars($age); ?></li>
                <li><b>Mobile :</b> <?php echo htmlspecialchars($mobile); ?></li>
                <li><b>Address :</b> <?php echo htmlspecialchars($address); ?></li>
                <li>
                  <b>Status :</b>
                  <span style="color:green;font-weight:bold;">
                    Verified
                  </span>
                </li>
              </ul>
            <?php } else { ?>
              <h6 class="text-muted">
                Data Found To Details Show ...
              </h6>
            <?php } ?>

          </div>
        </div>

        <a href="GoodApi_aadharVerify_list"
           class="btn btn-dark mt-2">
          GO TO AADHAAR VERIFY LIST
        </a>

      </div>

    </div>
  </div>
</div>


<?php include('../template/ahkweb/footer.php'); ?>
