<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uid = trim($_POST['uid']);

    /* ================= UID VALIDATION ================= */
    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        echo "<script>
            Swal.fire('Invalid Aadhaar','Enter valid 12 digit Aadhaar','warning')
            .then(()=>window.location.href='GoodApi_eShramDetails');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "ESHD".rand(100000,999999);
    $Purpose    = "ESHRAM DETAILS";
    $username   = $udata['phone'];
    $fee        = $price['esharam_details_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL (cURL) ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    // Updated API URL with new endpoint
    $url = "https://{$api['url_link']}/api_services/V1/esharamService/eshram_photo_details.php"
         . "?uid=$uid&apiKey={$api['api_key']}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'User-Agent: Mozilla/5.0'
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $resdata = json_decode($response, true);

    // Updated response validation for new API format
    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'eShram details fetch failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_eShramDetails');
        </script>";
        exit;
    }

    /* ================= API DATA - UPDATED TO USE data OBJECT ================= */
    $apiData = $resdata['data'] ?? [];
    
    $name    = $apiData['name'] ?? 'N/A';
    $unicode_name = $apiData['unicode_name'] ?? 'N/A';
    $father  = $apiData['fatherName'] ?? 'N/A';
    $dob     = $apiData['dob'] ?? 'N/A';
    $gender  = $apiData['gender'] ?? 'N/A';
    $mobile  = $apiData['mobile'] ?? 'N/A';
    $address = $apiData['address'] ?? 'N/A';
    $unicode_address = $apiData['unicode_address'] ?? 'N/A';
    $apiTrack= $resdata['tracking_id'] ?? $Traking_No;

    /* ================= PHOTO PROCESS ================= */
    $photoPath = '';
    if (!empty($apiData['photo'])) {
        $imgBase64 = preg_replace('#^data:image/\w+;base64,#', '', $apiData['photo']);
        $imgData   = base64_decode($imgBase64);

        $dirPath = "../uploads/eshram_photo/";
        if (!is_dir($dirPath)) {
            mkdir($dirPath, 0777, true);
        }

        $photoName = "ESHRAM_{$uid}_" . time() . ".jpg";
        $photoPath = $dirPath . $photoName;
        file_put_contents($photoPath, $imgData);
    }

    /* ================= TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);
    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        // Updated INSERT to include new fields (unicode_name, mobile, unicode_address)
        mysqli_query($ahk_conn,"
            INSERT INTO eshram_details
            (application_no,purpose,username,uid,name,unicode_name,father,dob,gender,
             mobile,address,unicode_address,photo,status,statuscode,fee,old_balance,
             new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$uid','$name','$unicode_name','$father','$dob','$gender',
             '$mobile','$address','$unicode_address','$photoPath','$Status','100','$fee',
             '$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,
             old_balance,new_balance,date,username)
            VALUES
            ('eShram Details','$uid','$Purpose','$Traking_No','$Status','$fee','Debit',
             '$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        error_log("Transaction Failed: " . $e->getMessage());
        echo "<script>
            Swal.fire('Error','Transaction failed: " . addslashes($e->getMessage()) . "','error')
            .then(()=>window.location.href='GoodApi_eShramDetails');
        </script>";
        exit;
    }

    echo "<script>
        Swal.fire('Success','eShram details fetched successfully','success')

    </script>";
}
?>
<!-- e-SHRAM DETAILS HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">E-SHRAM DETAILS</div>

<form method="POST" class="row g-3">

<div class="col-md-12">
<label>Aadhaar Number</label>
<input name="uid" maxlength="12" class="form-control"
placeholder="Enter 12 Digit Aadhaar" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['esharam_details_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>

</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="background:#f3fbf4;">
<div class="card-body">
<h6>
Aadhaar ke basis par e-Shram details nikali ja rahi hain.
</h6>
<hr>

<?php if (isset($name) && $name != 'N/A') { ?>
<div class="row">
<div class="col-md-4">
<?php if (!empty($photoPath)) { ?>
<img src="<?php echo $photoPath; ?>" class="img-thumbnail" style="max-width:200px;">
<?php } ?>
</div>

<div class="col-md-8">
<ul class="list-unstyled">
<li><b>Name:</b> <?php echo htmlspecialchars($name); ?></li>
<?php if ($unicode_name != 'N/A') { ?>
<li><b>Name (Hindi):</b> <?php echo htmlspecialchars($unicode_name); ?></li>
<?php } ?>
<li><b>Father:</b> <?php echo htmlspecialchars($father); ?></li>
<li><b>DOB:</b> <?php echo htmlspecialchars($dob); ?></li>
<li><b>Gender:</b> <?php echo htmlspecialchars($gender); ?></li>
<li><b>Mobile:</b> <?php echo htmlspecialchars($mobile); ?></li>
<li><b>Address:</b> <?php echo htmlspecialchars($address); ?></li>
<?php if ($unicode_address != 'N/A') { ?>
<li><b>Address (Hindi):</b> <?php echo htmlspecialchars($unicode_address); ?></li>
<?php } ?>
<li><b>Status:</b> <span class="badge bg-success">Verified</span></li>
</ul>
</div>
</div>
<?php } else { ?>
<h6 class="text-center">Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_eShramDetails_list" class="btn btn-dark mt-2">
GO TO E-SHRAM DETAILS LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>