<?php
include('../includes/session.php');
include('../includes/config.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $uid = trim($_POST['uid']);

    /* ================= UID VALIDATION ================= */
    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        die("Invalid Aadhaar Number");
    }

    $Traking_No = "ESHRAM".rand(100000,999999);
    $Purpose    = "ESHRAM CARD PDF";
    $username   = $udata['phone'];
    $fee        = $price['esharam_pdf_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        die("Low Balance");
    }

    /* ================= API FETCH ================= */
    $apiData = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM service_api LIMIT 1"));

    $url = "https://{$apiData['url_link']}/api_services/V1/esharamService/esharam_pdf.php"
         . "?apiKey={$apiData['api_key']}&uid=$uid";

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $resdata = json_decode($response, true);

    if (
        !isset($resdata['Status']) ||
        $resdata['Status'] !== 'Success' ||
        $resdata['StatusCode'] != 100
    ) {
        die($resdata['message'] ?? "API Failed");
    }

    /* ================= PDF PROCESS ================= */
    $pdfRaw = $resdata['data']['pdf'] ?? '';
    if (empty($pdfRaw)) {
        die("PDF Not Found");
    }

    $pdfData = base64_decode(trim($pdfRaw), true);
    if ($pdfData === false) {
        die("Invalid PDF Data");
    }

    $fileName = "ESHRAM_".$uid.".pdf";
    $dirPath  = "../uploads/eshram_pdf/";

    if (!is_dir($dirPath)) {
        mkdir($dirPath, 0777, true);
    }

    $filePath = $dirPath.$fileName;
    file_put_contents($filePath, $pdfData);

    /* ================= SAVE DATA ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        mysqli_query($ahk_conn,"
            INSERT INTO eshram_pdf
            (application_no,purpose,username,uid,name,father,dob,gender,uan,address,
             pdf_file,status,statuscode,fee,old_balance,new_balance,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$uid',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['name'] ?? '')."',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['father'] ?? '')."',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['dob'] ?? '')."',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['gender'] ?? '')."',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['uan'] ?? '')."',
             '".mysqli_real_escape_string($ahk_conn,$resdata['data']['address'] ?? '')."',
             '$fileName','Success','100','$fee','$oldBal','$newBal','$timestamp')
        ");

        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,
             old_balance,new_balance,date,username)
            VALUES
            ('eShram Card','$uid','$Purpose','$Traking_No','Success','$fee','Debit',
             '$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die("Transaction Failed");
    }

    /* ================= DIRECT DOWNLOAD ================= */

    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="'.$fileName.'"');
    header('Content-Length: ' . filesize($filePath));

    readfile($filePath);
    exit;
}
?>

<?php include('../template/ahkweb/header.php'); ?>

<!-- e-SHRAM PDF HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">E-SHRAM CARD PDF</div>

<form method="POST" class="row g-3">

<div class="col-md-12">
<label>Aadhaar Number</label>
<input name="uid" maxlength="12" class="form-control"
placeholder="Enter 12 Digit Aadhaar" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['esharam_pdf_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>

</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="height:290px;background:#f3fbf4;">
<div class="card-body">
<h6>
Aadhaar ke basis par e-Shram Card PDF generate ki ja rahi hai.
Yeh service sirf verification purpose ke liye hai.
</h6>
<hr>

<?php if (isset($fileName)) { ?>
<ul>
<li><b>Name:</b> <?php echo htmlspecialchars($name); ?></li>
<li><b>UAN:</b> <?php echo htmlspecialchars($uan); ?></li>
<li><b>Gender:</b> <?php echo htmlspecialchars($gender); ?></li>
<li><b>DOB:</b> <?php echo htmlspecialchars($dob); ?></li>
</ul>

<a href="<?php echo $filePath; ?>" target="_blank" class="btn btn-success">
Download eShram PDF
</a>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_eShramPdf_list" class="btn btn-dark mt-2">
GO TO E-SHRAM LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>
