<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $eid = trim($_POST['eid']);

    /* ================= EID VALIDATION ================= */
    if (!preg_match('/^[0-9]{28}$/', $eid)) {
        echo "<script>
            Swal.fire('Invalid Enrollment ID','Enter valid 28 digit EID','warning')
            .then(()=>window.location.href='GoodApi_enrollment_status');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "ENRST".rand(100000,999999);
    $Purpose    = "AADHAAR ENROLLMENT STATUS";
    $username   = $udata['phone'];
    $fee        = $price['enroll_status_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/aadharServices/enroll_status.php?enrollmentNumber=$eid&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Enrollment Status Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_enrollment_status');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $apiEid   = $resdata['eid'] ?? $eid;
    $message  = $resdata['message'] ?? 'N/A';
    $apiTrack = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* ENROLL STATUS HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO enroll_status
            (application_no,purpose,username,eid,message,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$apiEid','$message','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('Enrollment Status','$apiEid','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire('Success','Enrollment Status Fetched Successfully','success')
        .then(()=>window.location.href='#');
    </script>";
}
?>
<!-- AADHAAR ENROLLMENT STATUS HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="col-lg-12">
      <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
        <div class="container-fluid">
          <div class="row">

            <!-- INPUT SECTION -->
            <div class="col-lg-4 col-md-6 col-sm-6">
              <div class="card">
                <div class="card-body">
                  <div class="alert alert-danger">
                    AADHAAR ENROLLMENT STATUS
                  </div>

                  <form method="POST" class="row g-3">
                    <div class="col-md-12">
                      <label>Enrollment ID (EID)</label>
                      <input name="eid"
                             type="text"
                             placeholder="Enter 28 Digit EID"
                             maxlength="28"
                             class="form-control"
                             required>
                    </div>

                    <div class="col-md-12 mt-3">
                      <input class="form-control"
                             value="Charge ₹<?php echo $price['enroll_status_fee']; ?>"
                             readonly>
                    </div>

                    <div class="mt-3">
                      <button class="form-control btn btn-success" name="submit">
                        <i class="fa fa-check-circle"></i> Submit
                      </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>

            <!-- RESULT SECTION -->
            <div class="col-lg-8 col-md-6 col-sm-6">
              <div class="card" style="height:290px;background:#f3fbf4;">
                <div class="card-body">
                  <h6>
                    Enrollment ID ke through Aadhaar generation status check kiya ja raha hai.
                    Yeh service sirf information ke liye hai.
                  </h6>
                  <hr>

                  <?php if (isset($message) && $message != '') { ?>
                    <ul>
                      <li>
                        Enrollment ID :
                        <b><?php echo htmlspecialchars($apiEid); ?></b>
                      </li>
                      <li style="color:red">
                        Status Message :
                        <b><?php echo htmlspecialchars($message); ?></b>
                      </li>
                      <li>
                        Status :
                        <b style="color:green">Success</b>
                      </li>
                    </ul>
                  <?php } else { ?>
                    <h6>Data Found To Details Show ...</h6>
                  <?php } ?>
                </div>
              </div>

              <a href="GoodApi_EnrollStatus_list" class="btn btn-dark mt-2">
                GO TO ENROLL STATUS LIST
                <img width="30" height="30"
                     src="https://img.icons8.com/3d-fluency/94/undo.png"
                     alt="undo"/>
              </a>
            </div>

          </div>
        </div>
      </div>
    </div>

    <br>

    <!-- REQUEST HISTORY TABLE -->
    <div class="row">
      <div class="col-xl-12">
        <div class="card shadow border-0">
          <div class="card-header bg-light d-flex justify-content-between">
            <h6><i class="fas fa-history me-2"></i>Request History</h6>

            <?php
              $resultData = mysqli_query(
                $ahk_conn,
                "SELECT * FROM enroll_status WHERE username='$username' ORDER BY id DESC"
              );
            ?>

            <div class="badge bg-primary">
              Total: <?php echo mysqli_num_rows($resultData); ?>
            </div>
          </div>

          <div class="card-body table-responsive">
            <table class="table table-bordered table-striped">
              <thead class="table-primary">
                <tr>
                  <th>#</th>
                  <th>EID</th>
                  <th>Message</th>
                  <th>Charge</th>
                  <th>Status</th>
                  <th>Date</th>
                </tr>
              </thead>
              <tbody>
              <?php if(mysqli_num_rows($resultData)>0){ $i=1; while($row=mysqli_fetch_assoc($resultData)){ ?>
                <tr>
                  <td><?php echo $i++; ?></td>
                  <td><?php echo htmlspecialchars($row['eid']); ?></td>
                  <td><?php echo htmlspecialchars($row['message']); ?></td>
                  <td>₹<?php echo $row['fee']; ?></td>
                  <td><span class="badge bg-success"><?php echo $row['status']; ?></span></td>
                  <td><?php echo date('d M Y h:i A',strtotime($row['date'])); ?></td>
                </tr>
              <?php }} else { ?>
                <tr>
                  <td colspan="6" class="text-center">No records found</td>
                </tr>
              <?php } ?>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>

  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
