<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $pan = strtoupper(trim($_POST['pan']));

    /* ================= PAN VALIDATION ================= */
    if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]$/', $pan)) {
        echo "<script>
            Swal.fire('Invalid PAN','Enter valid PAN number','warning')
            .then(()=>window.location.href='GoodApi_panToname');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "PANND".rand(100000,999999);
    $Purpose    = "PAN TO NAME DOB";
    $username   = $udata['phone'];
    $fee        = $price['pan_name_dob_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/panServices/name_dob.php?panNumber=$pan&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'PAN Name DOB Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_panToname');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $panNumber = $resdata['panNumber'] ?? $pan;
    $name      = $resdata['name'] ?? 'N/A';
    $dob       = $resdata['dob'] ?? 'N/A';
    $apiTrack  = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* PAN NAME DOB HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO pan_name_dob
            (application_no,purpose,username,pan_no,name,dob,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$panNumber','$name','$dob','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('$name','$panNumber','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire('Success','PAN Name & DOB Fetched Successfully','success')
        .then(()=>window.location.href='#');
    </script>";
}
?>
<!-- PAN TO NAME DOB HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="col-lg-12">
      <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
        <div class="stat-content">
          <div class="stat-text">
            <div class="container-fluid">
              <div class="row">

                <!-- INPUT SECTION -->
                <div class="col-lg-4 col-md-6 col-sm-6">
                  <div class="card">
                    <div class="card-body">
                      <div class="alert alert-danger">
                        PAN NUMBER TO NAME & DOB
                      </div>

                      <form action="" method="POST" class="row g-3">
                        <div class="col-md-12">
                          <label>PAN Number</label>
                          <input name="pan"
                                 type="text"
                                 placeholder="ABCDE1234F"
                                 class="form-control"
                                 required>
                        </div>

                        <div class="col-md-12 mt-3">
                          <input class="form-control"
                                 value="Charge ₹<?php echo $price['pan_name_dob_fee']; ?>"
                                 readonly>
                        </div>

                        <div class="text-left mt-3">
                          <button class="form-control btn btn-success" name="submit">
                            <i class="fa fa-check-circle"></i> Submit
                          </button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>

                <!-- RESULT SECTION -->
                <div class="col-lg-8 col-md-6 col-sm-6">
                  <div class="card" style="height:290px;background-color:#f3fbf4;">
                    <div class="card-body">
                      <h6>
                        Please pay attention. PAN se Name aur Date of Birth verify kiya ja raha hai.
                        Yeh service sirf verification ke liye hai, misuse ke liye nahi.
                      </h6>
                      <hr>

                      <?php if (isset($name) && $name != '') { ?>
                        <ul>
                          <li style="color:red">
                            Name :
                            <b><?php echo htmlspecialchars($name); ?></b>
                          </li>
                          <li>
                            Date of Birth :
                            <b><?php echo htmlspecialchars($dob); ?></b>
                          </li>
                          <li>
                            PAN :
                            <b><?php echo htmlspecialchars($panNumber ?? ''); ?></b>
                          </li>
                          <li>
                            Status :
                            <b style="color:green">Verified</b>
                          </li>
                        </ul>
                      <?php } else { ?>
                        <h6>Data Found To Details Show ...</h6>
                      <?php } ?>
                    </div>
                  </div>

                  <a href="GoodApi_panToname_list" class="btn btn-dark mt-2">
                    GO TO PAN NAME DOB LIST
                    <img width="30" height="30"
                         src="https://img.icons8.com/3d-fluency/94/undo.png"
                         alt="undo"/>
                  </a>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <br>

    <!-- REQUEST HISTORY TABLE -->
    <div class="row">
      <div class="col-xl-12">
        <div class="card shadow border-0">
          <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h6 class="mb-0">
              <i class="fas fa-history me-2"></i>Request History
            </h6>

            <?php
              $resultData = mysqli_query(
                $ahk_conn,
                "SELECT * FROM pan_name_dob WHERE username='$username' ORDER BY id DESC"
              );
            ?>

            <div class="badge bg-primary">
              Total: <?php echo mysqli_num_rows($resultData); ?>
            </div>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table id="historyTable" class="table table-striped table-hover table-bordered" style="width:100%">
                <thead class="table-primary">
                  <tr>
                    <th>#</th>
                    <th>PAN</th>
                    <th>Name</th>
                    <th>DOB</th>
                    <th>Charge</th>
                    <th>Status</th>
                    <th>Date</th>
                  </tr>
                </thead>

                <tbody>
                <?php if (mysqli_num_rows($resultData) > 0): ?>
                  <?php $count = 1; while ($row = mysqli_fetch_assoc($resultData)): ?>
                    <tr>
                      <td><?php echo $count++; ?></td>
                      <td><?php echo htmlspecialchars($row['pan_no']); ?></td>
                      <td><?php echo htmlspecialchars($row['name']); ?></td>
                      <td><?php echo htmlspecialchars($row['dob']); ?></td>
                      <td>₹<?php echo htmlspecialchars($row['fee']); ?></td>
                      <td>
                        <?php
                          $status = strtoupper($row['status']);
                          $badgeClass = [
                            'SUCCESS' => 'bg-success',
                            'PENDING' => 'bg-warning text-dark',
                            'FAILED'  => 'bg-danger',
                          ][$status] ?? 'bg-secondary';
                          echo "<span class='badge $badgeClass'>$status</span>";
                        ?>
                      </td>
                      <td><?php echo date('d M Y h:i A', strtotime($row['date'])); ?></td>
                    </tr>
                  <?php endwhile; ?>
                <?php else: ?>
                  <tr>
                    <td colspan="7" class="text-center py-4">
                      <div class="text-muted">
                        <i class="fas fa-inbox fa-2x mb-2"></i><br>
                        No records found
                      </div>
                    </td>
                  </tr>
                <?php endif; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>

