<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $ration = trim($_POST['ration']);

    /* ================= RATION VALIDATION ================= */
    if (!preg_match('/^[0-9]{8,20}$/', $ration)) {
        echo "<script>
            Swal.fire('Invalid Ration Number','Enter valid Ration Card Number','warning')
            .then(()=>window.location.href='GoodApi_RationToUidUp');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "R2UV".rand(100000,999999);
    $Purpose    = "RATION TO UID (UP)";
    $username   = $udata['phone'];
    $fee        = $price['ration_uid_up_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/rasanServices/ration_to_uidno_up.php"
         . "?rationNumber=$ration&type=2&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Ration to UID Fetch Failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_RationToUidUp');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $rationNo     = $resdata['rationNumber'] ?? $ration;
    $uidNumbers   = $resdata['uidNumbers'] ?? [];
    $members      = $resdata['members'] ?? [];
    $totalMembers = $resdata['total_members'] ?? count($members);
    $apiTrack     = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION START ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* MAIN HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO ration_uid_up
            (application_no,purpose,username,ration_no,total_members,uid_list,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$rationNo','$totalMembers','".json_encode($uidNumbers)."','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* MEMBERS DETAIL */
        foreach ($members as $m) {
            mysqli_query($ahk_conn,"
                INSERT INTO ration_uid_up_members
                (application_no,username,srno,name,gender,father_name,relation,dob,uid_no,date)
                VALUES
                ('$Traking_No','$username',
                 '".($m['srno'] ?? '')."',
                 '".($m['Nameof_Family_Member_EN'] ?? '')."',
                 '".($m['Gender'] ?? '')."',
                 '".($m['Father_Name_EN'] ?? '')."',
                 '".($m['RELATION'] ?? '')."',
                 '".($m['DOB'] ?? '')."',
                 '".($m['UIDNo'] ?? '')."',
                 '$timestamp')
            ");
        }

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('Ration UID','$rationNo','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

   $uidList = isset($resdata['uidNumbers']) 
    ? implode(', ', $resdata['uidNumbers']) 
    : 'N/A';

echo "<script>
Swal.fire(
  'Success',
  'Ration to UID Details Fetched Successfully.<br><b>UID Numbers:</b><br>$uidList',
  'success'
);
</script>";

}
?>

<!-- RATION TO UID (UP) HTML -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="col-lg-12">
      <div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
        <div class="container-fluid">
          <div class="row">

            <!-- INPUT -->
            <div class="col-lg-4 col-md-6 col-sm-6">
              <div class="card">
                <div class="card-body">
                  <div class="alert alert-danger">RATION CARD TO UID (UP)</div>
                  <form method="POST" class="row g-3">
                    <div class="col-md-12">
                      <label>Ration Card Number</label>
                      <input name="ration" type="text" class="form-control"
                             placeholder="Enter Ration Number" required>
                    </div>
                    <div class="col-md-12 mt-3">
                      <input class="form-control"
                             value="Charge ₹<?php echo $price['ration_uid_up_fee']; ?>" readonly>
                    </div>
                    <div class="mt-3">
                      <button class="form-control btn btn-success" name="submit">
                        <i class="fa fa-check-circle"></i> Submit
                      </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>

            <!-- RESULT -->
            <div class="col-lg-8 col-md-6 col-sm-6">
              <div class="card" style="background:#f3fbf4;">
                <div class="card-body">
                  <h6>Ration Card ke through family members ke Aadhaar (masked) details nikale ja rahe hain.</h6>
                  <hr>

                  <?php if (isset($members) && count($members) > 0) { ?>
                    <p><b>Total Members:</b> <?php echo $totalMembers; ?></p>
                    <div class="table-responsive">
                      <table class="table table-bordered table-striped">
                        <thead class="table-primary">
                          <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Gender</th>
                            <th>Relation</th>
                            <th>DOB</th>
                            <th>Masked UID</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php foreach ($members as $m) { ?>
                            <tr>
                              <td><?php echo $m['srno']; ?></td>
                              <td><?php echo htmlspecialchars($m['Nameof_Family_Member_EN']); ?></td>
                              <td><?php echo htmlspecialchars($m['Gender']); ?></td>
                              <td><?php echo htmlspecialchars($m['RELATION']); ?></td>
                              <td><?php echo htmlspecialchars($m['DOB']); ?></td>
                              <td><?php echo htmlspecialchars($m['uidNumbers']); ?></td>
                            </tr>
                          <?php } ?>
                        </tbody>
                      </table>
                    </div>
                  <?php } else { ?>
                    <h6>Data Found To Details Show ...</h6>
                  <?php } ?>
                </div>
              </div>

              <a href="GoodApi_rationTouid_up_list" class="btn btn-dark mt-2">
                GO TO RATION UID LIST
              </a>
            </div>

          </div>
        </div>
      </div>
    </div>

    <br>

<!-- HISTORY -->
<div class="row">
  <div class="col-xl-12">
    <div class="card shadow border-0">

      <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <h6 class="mb-0">
          <i class="fas fa-history me-2"></i>Request History (Members)
        </h6>
        <span class="badge bg-primary">
          <?php
          if(isset($_SESSION['phone'])){
            $cnt = mysqli_fetch_row(mysqli_query(
              $ahk_conn,
              "SELECT COUNT(*) FROM ration_uid_up_members WHERE username='".$_SESSION['phone']."'"
            ));
            echo $cnt[0];
          } else {
            echo "0";
          }
          ?>
        </span>
      </div>

      <div class="card-body table-responsive">
        <table class="table table-bordered table-striped table-hover">
          <thead class="table-primary text-center">
            <tr>
              <th>#</th>
              <th>Application No</th>
              <th>Sr No</th>
              <th>Name</th>
              <th>Gender</th>
              <th>Father Name</th>
              <th>Relation</th>
              <th>DOB</th>
              <th>UID No</th>
              <th>Date</th>
            </tr>
          </thead>

          <tbody>
          <?php
          if(isset($_SESSION['phone'])){

            $phone = mysqli_real_escape_string($ahk_conn, $_SESSION['phone']);
            $sql = mysqli_query(
              $ahk_conn,
              "SELECT * FROM ration_uid_up_members 
               WHERE username='$phone' 
               ORDER BY id DESC"
            );

            if(mysqli_num_rows($sql) > 0){
              $slno = 1;
              while($row = mysqli_fetch_assoc($sql)){
          ?>
            <tr>
              <td class="text-center"><?php echo $slno++; ?></td>
              <td><?php echo htmlspecialchars($row['application_no']); ?></td>
              <td><?php echo htmlspecialchars($row['srno']); ?></td>
              <td><?php echo htmlspecialchars($row['name']); ?></td>
              <td><?php echo htmlspecialchars($row['gender']); ?></td>
              <td><?php echo htmlspecialchars($row['father_name']); ?></td>
              <td><?php echo htmlspecialchars($row['relation']); ?></td>
              <td><?php echo htmlspecialchars($row['dob']); ?></td>
              <td><?php echo htmlspecialchars($row['uid_no']); ?></td>
              <td><?php echo date('d M Y h:i A', strtotime($row['date'])); ?></td>
            </tr>
          <?php
              }
            } else {
          ?>
            <tr>
              <td colspan="10" class="text-center text-danger">
                No records found
              </td>
            </tr>
          <?php
            }
          } else {
          ?>
            <tr>
              <td colspan="10" class="text-center text-danger">
                Session expired. Please login again.
              </td>
            </tr>
          <?php } ?>
          </tbody>

        </table>
      </div>

    </div>
  </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
