<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    $rc = strtoupper(trim($_POST['rc']));

    /* ================= RC VALIDATION ================= */
    if (!preg_match('/^[A-Z]{2}[0-9]{2}[A-Z]{1,2}[0-9]{4}$/', $rc)) {
        echo "<script>
            Swal.fire('Invalid Vehicle Number','Enter valid RC number','warning')
            .then(()=>window.location.href='GoodApi_vehicleTomobile');
        </script>";
        exit;
    }

    /* ================= BASIC DATA ================= */
    $Traking_No = "VEH2MOB".rand(100000,999999);
    $Purpose    = "VEHICLE TO MOBILE";
    $username   = $udata['phone'];
    $fee        = $price['vehicle_mobile_fee'];
    $oldBal     = $udata['balance'];
    $newBal     = $oldBal - $fee;
    $Status     = 'Success';
    $timestamp  = date('Y-m-d H:i:s');

    if ($oldBal < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','warning')
            .then(()=>window.location.href='wallet.php');
        </script>";
        exit;
    }

    /* ================= API CALL ================= */
    $AWS_api = mysqli_query($ahk_conn, "SELECT * FROM service_api");
    $api = mysqli_fetch_assoc($AWS_api);

    $url = "https://{$api['url_link']}/api_services/V1/vahanServices/vehicle_to_mobile.php"
         . "?rcNumber=$rc&apiKey={$api['api_key']}";

    $response = file_get_contents($url);
    $resdata  = json_decode($response, true);

    if (!isset($resdata['Status']) || strtolower($resdata['Status']) !== 'success') {
        $msg = $resdata['message'] ?? 'Vehicle to Mobile fetch failed';
        echo "<script>
            Swal.fire('Failed','$msg','error')
            .then(()=>window.location.href='GoodApi_vehicleTomobile');
        </script>";
        exit;
    }

    /* ================= API DATA ================= */
    $apiRc     = $resdata['rcNumber'] ?? $rc;
    $mobile    = $resdata['mobile_no'] ?? 'N/A';
    $apiTrack  = $resdata['tracking_id'] ?? $Traking_No;

    /* ================= TRANSACTION ================= */
    mysqli_begin_transaction($ahk_conn);

    try {

        /* WALLET UPDATE */
        mysqli_query($ahk_conn,
            "UPDATE users SET balance='$newBal' WHERE phone='$username'"
        );

        /* VEHICLE → MOBILE HISTORY */
        mysqli_query($ahk_conn,"
            INSERT INTO vehicle_mobile_find
            (application_no,purpose,username,rc_no,mobile,status,statuscode,fee,old_balance,new_balance,api_tracking_id,date)
            VALUES
            ('$Traking_No','$Purpose','$username','$apiRc','$mobile','$Status','100','$fee','$oldBal','$newBal','$apiTrack','$timestamp')
        ");

        /* CARD SUMMARY */
        mysqli_query($ahk_conn,"
            INSERT INTO card_summary
            (Requst_Name,Requst_No,Purpose,Traking_No,Status,fee,type,old_balance,new_balance,date,username)
            VALUES
            ('$mobile','$apiRc','$Purpose','$Traking_No','$Status','$fee','Debit','$oldBal','$newBal','$timestamp','$username')
        ");

        mysqli_commit($ahk_conn);

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        die('Transaction Failed');
    }

    echo "<script>
        Swal.fire({
          title: 'Success',
          html: 'Mobile Number Retrieved Successfully.<br><b>Mobile:</b> $mobile',
          icon: 'success'
        });
    </script>";
}
?>

<!-- VEHICLE TO MOBILE HTML -->
<div class="page-wrapper">
<div class="page-content">
<div class="col-lg-12">
<div class="card" style="margin-left:10px;padding-left:30px;padding-top:12px;box-shadow:1px 5px 5px 5px;">
<div class="container-fluid">
<div class="row">

<!-- INPUT -->
<div class="col-lg-4 col-md-6 col-sm-6">
<div class="card">
<div class="card-body">
<div class="alert alert-danger">VEHICLE NUMBER TO MOBILE</div>

<form method="POST" class="row g-3">
<div class="col-md-12">
<label>Vehicle Number (RC)</label>
<input name="rc" type="text" class="form-control"
placeholder="UP50BE6017" required>
</div>

<div class="col-md-12 mt-3">
<input class="form-control"
value="Charge ₹<?php echo $price['vehicle_mobile_fee']; ?>" readonly>
</div>

<div class="mt-3">
<button class="form-control btn btn-success" name="submit">
<i class="fa fa-check-circle"></i> Submit
</button>
</div>
</form>
</div>
</div>
</div>

<!-- RESULT -->
<div class="col-lg-8 col-md-6 col-sm-6">
<div class="card" style="height:290px;background:#f3fbf4;">
<div class="card-body">
<h6>
Vehicle number ke through registered mobile number (masked) nikala ja raha hai.
Yeh service sirf verification purpose ke liye hai.
</h6>
<hr>

<?php if (isset($mobile) && $mobile != '') { ?>
<ul>
<li>
Vehicle No :
<b><?php echo htmlspecialchars($apiRc); ?></b>
</li>
<li style="color:red">
Registered Mobile :
<b><?php echo htmlspecialchars($mobile); ?></b>
</li>
<li>
Status :
<b style="color:green">Verified</b>
</li>
</ul>
<?php } else { ?>
<h6>Data Found To Details Show ...</h6>
<?php } ?>

</div>
</div>

<a href="GoodApi_vehicleTomobile_list" class="btn btn-dark mt-2">
GO TO VEHICLE MOBILE LIST
</a>

</div>
</div>
</div>
</div>
</div>

<br>

<?php include('../template/ahkweb/footer.php'); ?>

