<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');
?>

<body>
<div class="page-wrapper">
    <div class="page-content">

        <div class="container my-4">
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-primary text-white text-center rounded-top">
                            <h4 class="mb-0"><i class="fa fa-id-card-alt me-2"></i>Enter PAN Number to Download PAN PDF</h4>
                        </div>
                        <div class="card-body">
                            <form action="GoodApi_Pan_Advance_info.php" method="POST" id="pan_verification">
                                <div class="mb-3">
                                    <label for="panNumber" class="form-label fw-bold">PAN Number</label>
                                    <input type="text" class="form-control form-control-lg" name="panNumber" id="panNumber" placeholder="Enter PAN Number" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">Service Charge</label>
                                    <input type="text" class="form-control" value="Charge ₹<?php echo $price['pan_advance_fee']; ?>" readonly>
                                </div>

                                <div class="d-grid">
                                    <button type="submit" name="verify_pan" class="btn btn-success btn-lg">
                                        <i class="fa fa-download me-2"></i>Get PAN PDF
                                    </button>
                                </div>
                            </form>

                            <hr class="my-4">

                            <div class="text-center">
                                <a href="Pan_Manual_List.php" class="btn btn-outline-secondary">
                                    <img width="24" height="24" src="https://img.icons8.com/3d-fluency/94/undo.png" alt="undo" class="me-1"/>
                                    Go to PAN PDF Find List
                                </a>
                            </div>
                        </div>
                        <div class="card-footer text-muted text-center small">
                            Powered by <strong>Alam Web Solutions</strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- JS Scripts -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>
