<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Initialize variables
$udata = [];
$price = ['ll_fee' => 0];
$current_balance = 0;

// Get user data and fee
if (isset($_SESSION['phone'])) {
    $user_phone = mysqli_real_escape_string($ahk_conn, $_SESSION['phone']);
    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$user_phone' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $udata = mysqli_fetch_assoc($user_query);
        $current_balance = floatval($udata['balance']);
    }
}

// Get fee from commission settings
$fee_query = mysqli_query($ahk_conn, "SELECT ll_fee FROM users LIMIT 1");
if ($fee_query && mysqli_num_rows($fee_query) > 0) {
    $price = mysqli_fetch_assoc($fee_query);
}

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Required fields
        $required_fields = ['appicationNo', 'password', 'ret_wp_no', 'dob'];
        foreach ($required_fields as $field) {
            if (empty(trim($_POST[$field]))) {
                throw new Exception('Please fill all required fields.');
            }
        }

        // Sanitize input
        $appicationNo = mysqli_real_escape_string($ahk_conn, trim($_POST['appicationNo']));
        $dob = mysqli_real_escape_string($ahk_conn, trim($_POST['dob']));
        $password = mysqli_real_escape_string($ahk_conn, trim($_POST['password']));
        $ret_wp_no = mysqli_real_escape_string($ahk_conn, trim($_POST['ret_wp_no']));
        
        // Validate date
        if (!DateTime::createFromFormat('Y-m-d', $dob)) {
            throw new Exception('Invalid date format. Use YYYY-MM-DD.');
        }

        // Check if user is logged in
        if (empty($_SESSION['phone'])) {
            throw new Exception('Session expired. Please login again.');
        }
        
        $appliedby = mysqli_real_escape_string($ahk_conn, $_SESSION['phone']);
        
        // Get fee
        $fee = floatval($price['ll_fee']);
        if ($fee <= 0) {
            throw new Exception('Service fee is not configured. Please contact administrator.');
        }

        // Check if user has sufficient balance
        if ($current_balance < $fee) {
            $_SESSION['error'] = "Insufficient wallet balance. Required: ₹$fee, Available: ₹$current_balance";
            header("Location: learning_licance_exam.php");
            exit;
        }

        // Check if application already exists
        $check_query = mysqli_query($ahk_conn, "SELECT id FROM ll_pas WHERE appicationNo='$appicationNo'");
        if ($check_query && mysqli_num_rows($check_query) > 0) {
            throw new Exception('Application number already exists.');
        }

        // Generate unique tracking number
        $Traking_No = 'LL' . time() . rand(1000, 9999);
        $timestamp = date('Y-m-d H:i:s');
        $status = "pending";
        $purpose = "Learning License Exam";

        // Start transaction
        mysqli_begin_transaction($ahk_conn);

        // 1. Deduct from user's wallet
        $new_balance = $current_balance - $fee;
        $update_wallet = mysqli_query($ahk_conn, 
            "UPDATE users SET balance = balance - $fee WHERE phone = '$appliedby'"
        );
        
        if (!$update_wallet) {
            throw new Exception('Wallet update failed: ' . mysqli_error($ahk_conn));
        }

        // 2. Insert wallet history
        $history_query = mysqli_query($ahk_conn, 
            "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date) 
             VALUES ('{$udata['userid']}', '$fee', '$current_balance', 'Learning License Exam', '1', 'Debit', '$timestamp')"
        );
        
        if (!$history_query) {
            throw new Exception('Failed to record transaction: ' . mysqli_error($ahk_conn));
        }

        // 3. Insert into card_summary
        $card_query = mysqli_query($ahk_conn, 
            "INSERT INTO card_summary (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username) 
             VALUES ('$appicationNo', '$password', '$purpose', '$Traking_No', '$status', '$fee', 'Debit', '$current_balance', '$new_balance', '$timestamp', '$appliedby')"
        );
        
        if (!$card_query) {
            throw new Exception('Failed to create summary: ' . mysqli_error($ahk_conn));
        }

        // 4. Insert into ll_pas table
        $ll_query = mysqli_query($ahk_conn, 
            "INSERT INTO ll_pas (appliedby, appicationNo, dob, password, status, ret_wp_no, fee, application_no, apply_date) 
             VALUES ('$appliedby', '$appicationNo', '$dob', '$password', '$status', '$ret_wp_no', '$fee', '$Traking_No', '$timestamp')"
        );
        
        if (!$ll_query) {
            throw new Exception('Failed to save application: ' . mysqli_error($ahk_conn));
        }

        // Commit transaction
        mysqli_commit($ahk_conn);

        // Send notifications
        if (isset($udata['phone']) && !empty($udata['phone'])) {
            $user_number = "91" . preg_replace('/\D/', '', $udata['phone']);
            $fullname = $udata['name'] ?? 'Customer';
            
            // User message
            $usermsg = rawurlencode("🎉 Congratulations Dear *{$fullname}* 🎉

🔹 *Learning License Exam Application*

📋 Application No: *{$appicationNo}*
💰 Fee: ₹{$fee}
💳 Balance: ₹{$current_balance} → ₹{$new_balance}
📅 DOB: {$dob}

Thank you for using our service! For any queries, please contact support.");

            // Send SMS if configured
            if (!empty($good_sms_url) && !empty($good_sms_kay)) {
                $sms_url = "https://{$good_sms_url}/send-message?api_key={$good_sms_kay}&sender=" . 
                          ($good_sms_sender ?? '') . "&number={$user_number}&message={$usermsg}";
                @file_get_contents($sms_url);
            }

            // Admin notification (if configured)
            if (!empty($good_sms_url) && !empty($good_sms_kay) && !empty($aadhar_to_pdf_opreter)) {
                $admin_msg = rawurlencode("🚨 *NEW LEARNING LICENSE APPLICATION* 🚨

👤 Customer: *{$fullname}*
📞 Phone: *{$appliedby}*
📋 App No: *{$appicationNo}*
💰 Fee: ₹{$fee}
📊 Tracking: {$Traking_No}

⚠️ Please process this application!");
                
                $admin_sms_url = "https://{$good_sms_url}/send-message?api_key={$good_sms_kay}&sender=" . 
                                ($sender_no ?? $good_sms_sender ?? '') . 
                                "&number={$aadhar_to_pdf_opreter}&message={$admin_msg}";
                @file_get_contents($admin_sms_url);
            }
        }

        // Success response
        echo '<script>
            Swal.fire({
                icon: "success",
                title: "Application Submitted!",
                html: "Your learning license exam application has been submitted successfully.<br><br>" +
                      "<strong>Tracking Number:</strong> ' . $Traking_No . '<br>" +
                      "<strong>Fee Deducted:</strong> ₹' . $fee . '<br>" +
                      "<strong>New Balance:</strong> ₹' . $new_balance . '",
                showConfirmButton: true,
                confirmButtonText: "View Applications"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location = "LL_pass_list.php";
                }
            });
        </script>';
        
        // Stop further execution after successful submission
        include('footer.php');
        exit;

    } catch (Exception $e) {
        // Rollback transaction
        if (isset($ahk_conn) && mysqli_errno($ahk_conn)) {
            @mysqli_rollback($ahk_conn);
        }
        
        // Log error
        error_log('LL Submission Error: ' . $e->getMessage());
        
        // Show error
        echo '<script>
            Swal.fire({
                icon: "error",
                title: "Submission Failed",
                text: "' . addslashes($e->getMessage()) . '",
                confirmButtonText: "Try Again"
            }).then(() => {
                window.location.reload();
            });
        </script>';
    }
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="card border-primary">
                    <div class="card-header bg-primary text-white">
                        <div class="d-flex align-items-center">
                            <i class="bx bxs-id-card me-2 fs-4"></i>
                            <h5 class="mb-0">Learning License Exam Application</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Display error message if any -->
                        <?php if (isset($_SESSION['error'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="bx bx-error-circle me-2"></i>
                                <?php echo htmlspecialchars($_SESSION['error']); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            <?php unset($_SESSION['error']); ?>
                        <?php endif; ?>
                        
                        <form method="POST" class="row g-3 needs-validation" novalidate>
                            <div class="col-md-6">
                                <label for="appicationNo" class="form-label">
                                    <i class="bx bx-id-card me-1"></i> Application Number <span class="text-danger">*</span>
                                </label>
                                <input name="appicationNo" type="text" class="form-control" id="appicationNo" 
                                       required maxlength="50" placeholder="Enter application number">
                                <div class="invalid-feedback">
                                    Please enter valid application number
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="dob" class="form-label">
                                    <i class="bx bx-calendar me-1"></i> Date of Birth <span class="text-danger">*</span>
                                </label>
                                <input name="dob" type="date" class="form-control" id="dob" required>
                                <div class="invalid-feedback">
                                    Please select your date of birth
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="password" class="form-label">
                                    <i class="bx bx-lock me-1"></i> Password <span class="text-danger">*</span>
                                </label>
                                <input name="password" type="password" class="form-control" id="password" 
                                       required minlength="4" placeholder="Enter password">
                                <div class="invalid-feedback">
                                    Password must be at least 4 characters
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="ret_wp_no" class="form-label">
                                    <i class="bx bx-phone me-1"></i> WhatsApp Number <span class="text-danger">*</span>
                                </label>
                                <input name="ret_wp_no" type="text" class="form-control" id="ret_wp_no" 
                                       required value="<?php echo htmlspecialchars($udata['phone'] ?? ''); ?>" 
                                       placeholder="Enter WhatsApp number">
                                <div class="invalid-feedback">
                                    Please provide valid WhatsApp number
                                </div>
                            </div>
                            
                            <!-- Fee and Balance Info -->
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <div class="d-flex align-items-center">
                                        <i class="bx bx-info-circle me-3 fs-4"></i>
                                        <div>
                                            <h6 class="mb-1">Application Details</h6>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <strong>Application Fee:</strong> ₹<?php echo htmlspecialchars($price['ll_fee'] ?? 0); ?>
                                                </div>
                                                <div class="col-md-6">
                                                    <strong>Your Balance:</strong> 
                                                    <span class="<?php echo ($current_balance < ($price['ll_fee'] ?? 0)) ? 'text-danger' : 'text-success'; ?>">
                                                        ₹<?php echo htmlspecialchars($current_balance); ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <?php if ($current_balance < ($price['ll_fee'] ?? 0)): ?>
                                                <div class="alert alert-warning mt-2 mb-0 p-2">
                                                    <i class="bx bx-error me-1"></i>
                                                    Insufficient balance. Please recharge your wallet.
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary btn-lg w-100" 
                                        <?php echo ($current_balance < ($price['ll_fee'] ?? 0)) ? 'disabled' : ''; ?>>
                                    <i class="bx bx-send me-2"></i> 
                                    Submit Application
                                </button>
                            </div>
                            
                            <div class="col-12 text-center">
                                <small class="text-muted">
                                    <i class="bx bx-shield me-1"></i> Your information is secure and encrypted
                                </small>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php include('footer.php'); ?>

<!-- JavaScript Libraries -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Form Validation -->
<script>
(function () {
    'use strict'
    var forms = document.querySelectorAll('.needs-validation')
    Array.prototype.slice.call(forms).forEach(function (form) {
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    })
})();

// Date validation - cannot select future date
document.getElementById('dob').max = new Date().toISOString().split("T")[0];
</script>
</body>
</html>