<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['Gadi_Number'])) {
    $Gadi_Number = mysqli_real_escape_string($ahk_conn, $_POST['Gadi_Number']);
    $Gadi_Typs = trim(mysqli_real_escape_string($ahk_conn, $_POST['Gadi_Typs']));
    $mobile_no = mysqli_real_escape_string($ahk_conn, $_POST['mobile_no']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $purpose = mysqli_real_escape_string($ahk_conn, $_POST['purpose']);

    $fee_query = mysqli_query($ahk_conn, "SELECT puc_bike_fee, puc_petrol_cng_fee, puc_diesel_fee FROM users LIMIT 1");
    $price = mysqli_fetch_assoc($fee_query);

    $puc_fee = 0;
    if ($Gadi_Typs == 'Bike') $puc_fee = $price['puc_bike_fee'];
    elseif ($Gadi_Typs == '2nd/18th Petrol cng') $puc_fee = $price['puc_petrol_cng_fee'];
    elseif ($Gadi_Typs == '2nd/18th Diesel') $puc_fee = $price['puc_diesel_fee'];
    else {
        $_SESSION['error'] = "Invalid Gadi type selected.";
        header("Location: PUC_Enroll.php");
        exit;
    }

    $Traking_No = 'PUC' . time() . rand(100, 999);
    $timestamp = date('Y-m-d H:i:s');
    $status = "Pending";
    $userMobile = $_SESSION['phone'];

    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$userMobile'");
    $udata = mysqli_fetch_assoc($user_query);
    $old_walletamount = $udata['balance'];

    if ($old_walletamount < $puc_fee) {
        $_SESSION['error'] = "Insufficient wallet balance.";
        header("Location: PUC_Enroll.php");
        exit;
    }

  // === Upload file with randomized name ===
$target_dir = "admin/uploads/Puc_doc/";
if (!file_exists($target_dir)) mkdir($target_dir, 0755, true);

$file_tmp = $_FILES['imagefile']['tmp_name'];
$file_type = $_FILES['imagefile']['type'];
$file_size = $_FILES['imagefile']['size'];
$original_ext = pathinfo($_FILES['imagefile']['name'], PATHINFO_EXTENSION);

// Clean vehicle number: remove spaces and special characters
$clean_vehicle_number = preg_replace('/[^A-Za-z0-9]/', '', $Gadi_Number);

// Set filename: VEHICLE_UP65BN1111.jpg
$random_name = 'VEHICLE_' . strtoupper($clean_vehicle_number) . '.' . strtolower($original_ext);
$target_file = $target_dir . $random_name;

if (strpos($file_type, 'image') !== false) {
    if ($file_size <= 2 * 1024 * 1024) {
        if (move_uploaded_file($file_tmp, $target_file)) {
            $photo_path = $target_file; // Use this for further processing
        } else {
            $_SESSION['error'] = "Failed to move uploaded file.";
            header("Location: PUC_Enroll.php");
            exit;
        }
    } else {
        $_SESSION['error'] = "Image size should not exceed 2MB.";
        header("Location: PUC_Enroll.php");
        exit;
    }
} else {
    $_SESSION['error'] = "Invalid image type. Only image files allowed.";
    header("Location: PUC_Enroll.php");
    exit;
}


    mysqli_begin_transaction($ahk_conn);
    try {
        $new_walletamount = $old_walletamount - $puc_fee;
        mysqli_query($ahk_conn, "UPDATE users SET balance = '$new_walletamount' WHERE phone = '$userMobile'");

        mysqli_query($ahk_conn, "INSERT INTO card_summary 
            (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username)
            VALUES ('$Gadi_Number','$mobile_no','PUC Enrollment','$Traking_No','$status','$puc_fee','Debit','$old_walletamount','$new_walletamount','$timestamp','$userMobile')");

        // Referral commission
        $parentPhone = $udata['referred_by'];
        if (!empty($parentPhone)) {
            $refer = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$parentPhone'"));
            $commission_fee = 2;
            $refer_wallet_old = $refer['balance'];
            $refer_wallet_new = $refer_wallet_old + $commission_fee;

            mysqli_query($ahk_conn, "UPDATE users SET balance='$refer_wallet_new' WHERE phone='$parentPhone'");
            mysqli_query($ahk_conn, "INSERT INTO card_summary_commissation 
                (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username) 
                VALUES ('$Gadi_Number', '$userMobile', 'PUC Commission', '$Traking_No', 'Success', '$commission_fee', 'Credit', '$refer_wallet_old', '$refer_wallet_new', '$timestamp', '$parentPhone')");
        }
$imageURL = "https://$sarvar_url/$photo_path";

// SQL Insert query
$sql = "INSERT INTO `Puc_enroll` (
    `srno`, `parent`, `appliedby`, `Gadi_Number`, `Gadi_Typs`, `state`, 
    `mobile_no`, `purpose`, `status`, `photo`, 
    `date`, `reson`, `payment_status`, `fee`
) VALUES (
    ?, ?, ?, ?, ?, ?, ?, ?, 'Pending', ?, ?, 'Vehicle PUC', 'paid', ?
)";

$stmt = mysqli_prepare($ahk_conn, $sql);
if ($stmt) {
    mysqli_stmt_bind_param($stmt, "ssssssssssd", 
        $Traking_No, $userMobile, $userMobile, $Gadi_Number, 
        $Gadi_Typs, $state, $mobile_no, $purpose, 
        $imageURL, $timestamp, $puc_fee
    );

    if (mysqli_stmt_execute($stmt)) {
        // ✅ Success
    } else {
        echo "❌ Insert Error: " . mysqli_stmt_error($stmt);
    }

    mysqli_stmt_close($stmt);
} else {
    echo "❌ Prepare Failed: " . mysqli_error($ahk_conn);
}


        // WhatsApp Notification to User
        $apis = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM User_Whatsapp"));
        $message = urlencode("🚗 *PUC Enrollment Successful*\n\n📋 *Vehicle:* *$Gadi_Number*\n• Type: *$Gadi_Typs*\n• State: *$state*\n📩 *Tracking:* *$Traking_No*\n💰 *Fee:* ₹$puc_fee\n📆 *$timestamp*");
        $sms_url = "https://{$apis['good_sms_link']}/send-message?api_key={$apis['api_key']}&sender={$apis['sender_no']}&number=91$userMobile&message=$message";
        @file_get_contents($sms_url);

        // Operator WhatsApp
        $api_opreter = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM User_Whatsapp"));
        $operator_message = urlencode("🚗 *PUC Request Alert*\n\n📋 *Vehicle:* $Gadi_Number\n📞 *Mobile:* $mobile_no\n📍 *State:* $state\n🧾 *Type:* $Gadi_Typs\n📩 *Tracking:* $Traking_No\n🕒 *$timestamp*\n📍 *Photo Download :* $imageURL");

        // Text
        @file_get_contents("https://{$api_opreter['url_link']}/send-message?api_key={$api_opreter['api_key']}&sender={$api_opreter['sender_no']}&number={$api_opreter['puc_opreter']}&message=$operator_message");


        mysqli_commit($ahk_conn);

        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Success 🎉', 'PUC request submitted! Tracking No: $Traking_No', 'success').then(() => {
                window.location.href = 'PUC_Enroll.php';
            });
        </script>";

    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        $_SESSION['error'] = "Transaction failed. Try again.";
        header("Location: PUC_Enroll.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>PUC Enrollment Form</title>
  <!--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">-->
  <!--<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">-->
  <style>
    :root {
      --primary-color: #4e73df;
      --secondary-color: #f8f9fc;
      --success-color: #1cc88a;
    }
    body { background-color: #f8f9fc; font-family: 'Nunito', sans-serif; }
    .card { border: none; border-radius: 0.35rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15); }
    .card-header { background-color: var(--primary-color); color: white; font-weight: 600; border-bottom: none; }
    .fee-display { font-size: 2.5rem; font-weight: 700; color: var(--primary-color); }
    .upload-container { border: 2px dashed #ced4da; border-radius: 0.35rem; padding: 2rem; text-align: center; cursor: pointer; }
    .upload-container:hover { border-color: var(--primary-color); }
    .preview-image { max-width: 100%; max-height: 200px; margin-top: 1rem; display: none; }
  </style>
</head>
<body>
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-lg-8">
        <div class="card shadow-lg">
          <div class="card-header py-3">
            <h5 class="m-0"><i class="fas fa-car me-2"></i>PUC ENROLLMENT</h5>
          </div>
          <div class="card-body">
            <?php if(isset($_SESSION['error'])): ?>
              <div class="alert alert-danger alert-dismissible fade show mb-4">
                <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif; ?>
            
            <div class="d-flex justify-content-between align-items-center mb-4 p-3 bg-light rounded">
              <div>
                <h6 class="mb-1"><i class="fas fa-wallet me-2"></i>WALLET BALANCE</h6>
                <h4 class="mb-0">₹<?php echo number_format($udata['balance'] ?? 0, 2); ?></h4>
              </div>
              <div class="text-end">
                <h6 class="mb-1"><i class="fas fa-tag me-2"></i>SERVICE FEE</h6>
                <div id="fee-display" class="fee-display">₹0</div>
              </div>
            </div>

            <form method="POST" enctype="multipart/form-data" id="pucForm">
              <div class="row g-3 mb-4">
                <div class="col-md-6">
                  <label for="Gadi_Number" class="form-label fw-bold">VEHICLE NUMBER*</label>
                  <input type="text" class="form-control form-control-lg" id="Gadi_Number" name="Gadi_Number" required>
                </div>
                <div class="col-md-6">
                  <label for="Gadi_Typs" class="form-label fw-bold">GADI TYPE*</label>
                  <select name="Gadi_Typs" id="Gadi_Typs" class="form-control form-control-lg" required>
                    <option value="">Select Gadi</option>
                    <option value="Bike">ALL BIKE ₹ <?php echo $price['puc_bike_fee']; ?></option>
                    <option value="2nd/18th Petrol cng">ALL PETROL & CNG ₹ <?php echo $price['puc_petrol_cng_fee']; ?></option>
                    <option value="2nd/18th Diesel">ALL DIESEL ₹ <?php echo $price['puc_diesel_fee']; ?></option>
                  </select>
                </div>
              </div>

              <div class="row g-3 mb-4">
                <div class="col-md-6">
                  <label for="mobile_no" class="form-label fw-bold">MOBILE NUMBER*</label>
                  <div class="input-group">
                    <span class="input-group-text bg-light">+91</span>
                    <input type="text" maxlength="10" pattern="\d{10}" class="form-control form-control-lg" id="mobile_no" name="mobile_no" required>
                  </div>
                </div>
                <div class="col-md-6">
                  <label for="state" class="form-label fw-bold">STATE*</label>
                  <input type="text" class="form-control form-control-lg" id="state" name="state" required>
                </div>
              </div>

              <div class="mb-4">
                <label for="purpose" class="form-label fw-bold">PURPOSE*</label>
                <input type="text" class="form-control form-control-lg" id="purpose" name="purpose" value="PUC Certificate" readonly required>
              </div>

              <div class="mb-2">
                <label class="form-label fw-bold">VEHICLE PHOTO*</label>
                <div class="upload-container" id="uploadContainer">
                  <div class="upload-icon">
                    <i class="fas fa-cloud-upload-alt fa-3x mb-3 text-muted"></i>
                  </div>
                  <h5>Drag & Drop or Click to Upload</h5>
                  <p class="text-muted">Supported formats: JPG, PNG (Max 2MB)</p>
                  <div id="fileName" class="file-info"></div>
                  <input type="file" id="imagefile" name="imagefile" class="d-none" accept="image/jpeg,image/png" required>
                  <img id="imagePreview" class="preview-image img-thumbnail" alt="Vehicle Photo Preview">
                </div>
              </div>

              <div class="d-grid mt-4">
                <button type="submit" class="btn btn-primary btn-lg py-3">
                  <i class="fas fa-paper-plane me-2"></i>SUBMIT APPLICATION
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const uploadContainer = document.getElementById('uploadContainer');
    const fileInput = document.getElementById('imagefile');
    const fileName = document.getElementById('fileName');
    const preview = document.getElementById('imagePreview');

    uploadContainer.addEventListener('click', () => fileInput.click());

    fileInput.addEventListener('change', function(e) {
      const file = e.target.files[0];
      if (file) {
        if (!file.type.match('image/jpeg') && !file.type.match('image/png')) {
          alert('Please upload only JPG or PNG images');
          return;
        }

        if (file.size > 2 * 1024 * 1024) {
          alert('File size exceeds 2MB limit');
          return;
        }

        fileName.textContent = file.name;
        const reader = new FileReader();
        reader.onload = function(e) {
          preview.src = e.target.result;
          preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
      }
    });

    // Dynamic fee update
    document.getElementById('Gadi_Typs').addEventListener('change', function () {
      const selected = this.value;
      let fee = 0;
      if (selected === "Bike") {
        fee = <?php echo $price['puc_bike_fee']; ?>;
      } else if (selected === "2nd/18th Petrol cng") {
        fee = <?php echo $price['puc_petrol_cng_fee']; ?>;
      } else if (selected === "2nd/18th Diesel") {
        fee = <?php echo $price['puc_diesel_fee']; ?>;
      }
      document.getElementById('fee-display').textContent = `₹${fee}`;
    });
  </script>
  <!-- Add your footer content here -->
     <?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>