<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

if (checkAdmin($udata['type']) == false) {
    echo "<script>window.location='index.php';</script>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['name'])) {

    $name    = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $phone   = mysqli_real_escape_string($ahk_conn, $_POST['phone']);
    $email   = mysqli_real_escape_string($ahk_conn, $_POST['email']);
    $address = mysqli_real_escape_string($ahk_conn, $_POST['address']);
    $password = $_POST['password'];

    /* ================= USER TYPE LOGIC ================= */
    $type = "retailer";

    if ($udata['type'] == "admin" || $udata['type'] == "distributor") {
        $type = mysqli_real_escape_string($ahk_conn, $_POST['type']);
    }

    if (!in_array($type, ['retailer', 'distributor'])) {
        ?>
        <script>
            Swal.fire('Invalid Type','Only Retailer or Distributor allowed','error');
        </script>
        <?php
        exit;
    }

    /* ================= DUPLICATE CHECK ================= */
    $check = mysqli_query($ahk_conn, "SELECT id FROM users WHERE phone='$phone'");
    if (mysqli_num_rows($check) > 0) {
        ?>
        <script>
            Swal.fire('User Exists','Mobile number already registered','error');
        </script>
        <?php
        exit;
    }

    /* ================= INSERT USER ================= */
    $hash = password_hash($password, PASSWORD_DEFAULT);

    $insert = mysqli_query($ahk_conn, "
        INSERT INTO users
        (referred_by, name, phone, email, address, type, password, status)
        VALUES
        ('{$udata['phone']}', '$name', '$phone', '$email', '$address', '$type', '$hash', '1')
    ");

    if ($insert) {

        /* ================= WHATSAPP API ================= */
        $number  = "91".$phone;             // USER NUMBER WITH COUNTRY CODE

        $message = "🎉 Congratulations 🎉

Your account has been created successfully.

Name : $name
Mobile : $phone
Password : $password
User Type : $type

Thank you for working with us.";

        $footer = "Sent via GoodSms";

        $params = http_build_query([
            "api_key" => $good_sms_kay,
            "sender"  => $good_sms_sender,
            "number"  => $number,
            "message" => $message,
            "footer"  => $footer
        ]);

        $url = "https://$good_sms_url/send-message?" . $params;

        // SEND REQUEST
        $response = file_get_contents($url);
        $result = json_decode($response, true);

        ?>
        <script>
            Swal.fire(
                'User Created Successfully',
                'WhatsApp Message Sent',
                'success'
            );
            setTimeout(() => {
                window.location='User_list.php';
            }, 1500);
        </script>
        <?php

    } else {
        ?>
        <script>
            Swal.fire('Error','User not created','error');
        </script>
        <?php
    }
}
?>


		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<div class="row">
					<div class="col-xl-10 mx-auto">
						<h6 class="mb-0 text-uppercase">Add New user</h6>
						<hr/>
						<div class="card border-top border-0 border-4 border-primary">
							<div class="card-body p-5">
								<div class="card-title d-flex align-items-center">
									<div><i class="bx bxs-user me-1 font-22 text-primary"></i>
									</div>
									<h5 class="mb-0 text-primary">user Details</h5>
								</div>
								<hr>
								<form action="" method="POST" class="row g-3">
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Name</label>
										<input name="name"  type="text"  placeholder="Name"  class="form-control" id="inputFirstName">
									</div>
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Phone (It Will be Username)</label>
										<input name="phone"  type="text"  placeholder="Phone"  class="form-control" id="inputFirstName">
									</div>
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Email</label>
										<input name="email"  type="email"  placeholder="Enter Email"  class="form-control" id="inputFirstName">
									</div>
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Full Address</label>
										<input name="address"  type="address"  placeholder="Enter address"  class="form-control" id="inputFirstName">
									</div>
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Usertype</label>
										<select class="form-control" name="type" id="">
                                            <option value="">Select User Type</option>
                                            <option value="retailer">Retailer</option>
                                            <option value="distributor">Distributor</option>
                                          
                                        </select>
									</div>
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">Password</label>
										<input name="password"  type="password"  placeholder="Password"  class="form-control" id="inputFirstName">
									</div>
									
									<div class="col-12">
										<button type="submit" class="btn btn-primary px-5">Save</button>
									</div>
								</form>
							</div>
						</div>
					
					</div>
				</div>
				
			</div>
		</div>
		
		<!--end page wrapper -->
		<?php 
		include('footer.php');
		?>
	<!-- Bootstrap JS -->
	

	<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/ahkweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/ahkweb/assets/js/app.js"></script>
</body>

 <script>
document.addEventListener('contextmenu', function(event) {
    event.preventDefault();
    window.close();
});
</script>
<script>
document.addEventListener('keydown', function(event) {
    // Close the page when Ctrl+U (View Source) is pressed
    if (event.ctrlKey && (event.key === 'u' || event.key === 'U')) {
        event.preventDefault();
        window.close();
    }
    // Close the page when Ctrl+Shift+I or F12 (Developer Tools) is pressed
    if ((event.ctrlKey && event.shiftKey && (event.key === 'i' || event.key === 'I')) || event.key === 'F12') {
        event.preventDefault();
        window.close();
    }
});
</script>
<script>
document.addEventListener('keydown', function(event) {
    // Close the page when Ctrl+U (View Source) is pressed
    if (event.ctrlKey && (event.key === 'u' || event.key === 'U')) {
        event.preventDefault();  // Prevent default behavior (view source)
        if (window.opener) {     // Only close if the window was opened by a script
            window.close();
        }
    }
    
    // Close the page when Ctrl+Shift+I or F12 (Developer Tools) is pressed
    if ((event.ctrlKey && event.shiftKey && (event.key === 'i' || event.key === 'I')) || event.key === 'F12') {
        event.preventDefault();  // Prevent opening developer tools
        if (window.opener) {     // Only close if the window was opened by a script
            window.close();
        }
    }
});
</script>

<script>
	$(document).ready(function() {
	
	$('#eid').inputmask();
	$('#date').inputmask();
	$('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        hourFormat: 12
      });
	});
</script>
</html>