<?php
include('../includes/session.php');
include('../includes/config.php');
if(checkAdmin($udata['type']) == false){
    header('Location: index.php');
    die();
}
include('../template/ahkweb/header.php');

// File upload handling
if(isset($_POST['Gadi_Number']) && !empty($_POST['Gadi_Number'])){
    $Gadi_Number = mysqli_real_escape_string($ahk_conn, $_POST['Gadi_Number']);
    $id = mysqli_real_escape_string($ahk_conn, $_POST['id']);
    $type = $_FILES['puc_pdf']['type'];
    
    // Allowed file types
    $allowedTypes = ["application/pdf", "image/jpeg", "image/png", "image/jpg"];
    
    if(in_array($type, $allowedTypes)){
        // Create upload directory if not exists
        $uploadDir = "uploads/Puc_doc/";
        if(!is_dir($uploadDir)){
            mkdir($uploadDir, 0755, true);
        }
      
        // Generate unique filename
        $ext = pathinfo($_FILES['puc_pdf']['name'], PATHINFO_EXTENSION);
        $filename = uniqid() . '_' . time() . '.' . $ext;
        $filePath = $uploadDir . $filename;
        
        if(move_uploaded_file($_FILES['puc_pdf']['tmp_name'], $filePath)){
            // Generate accessible link
            $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
            $link = $protocol . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/' . $filePath;
            
            // Get user details and referral information
            $userQuery = mysqli_query($ahk_conn, "SELECT appliedby, srno, fee FROM Puc_enroll WHERE id='$id'");
            if(mysqli_num_rows($userQuery) > 0) {
                $userData = mysqli_fetch_assoc($userQuery);
                $userMobile = $userData['appliedby'];
                $puc_fee = $userData['fee'];
                $Traking_No = $userData['srno'];
                $purpose = $userData['purpose'];
                // Get user's referrer
                $refQuery = mysqli_query($ahk_conn, "SELECT referred_by FROM users WHERE phone='$userMobile'");
                $refData = mysqli_fetch_assoc($refQuery);
                $parentPhone = $refData['referred_by'] ?? '';
                $parentname = $refData['name'] ?? '';
            } else {
                $userMobile = '';
                $parentPhone = '';
            }
            
            $timestamp = date('Y-m-d H:i:s');
            $status = "success";
            
            // Start transaction
            mysqli_begin_transaction($ahk_conn);
            
            try {
                // Update PUC record
                $updatePuc = mysqli_query($ahk_conn, "UPDATE Puc_enroll SET pdf_link='$link', Gadi_Number='$Gadi_Number', status='$status' WHERE id='$id'");
                if(!$updatePuc) throw new Exception("PUC update failed");
                
                // Record main transaction
                $insert_transaction = mysqli_query($ahk_conn, "INSERT INTO card_summary 
                    (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username)
                    VALUES ('$Gadi_Number','$userMobile','$purpose','$Traking_No','$status','$puc_fee','Debit','NULL','NULL','$timestamp','$userMobile')");
                if(!$insert_transaction) throw new Exception("Transaction record failed");
                
                // Process referral commission if applicable
                if(!empty($parentPhone)) {
                    $refer = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='$parentPhone'"));
                    if($refer) {
                        $commission_fee = 5;
                        $parentname = $refer['name'] ?? '';
                        $refer_wallet_old = $refer['balance'];
                        $refer_wallet_new = $refer_wallet_old + $commission_fee;
                        
                        // Update referrer's balance
                        $update_referral = mysqli_query($ahk_conn, "UPDATE users SET balance='$refer_wallet_new' WHERE phone='$parentPhone'");
                        if(!$update_referral) throw new Exception("Referral wallet update failed");
                        
                        // Record commission transaction
                        $insert_commission = mysqli_query($ahk_conn, "INSERT INTO card_summary_commissation 
                            (Requst_Name, Requst_No, Purpose, Traking_No, Status, fee, type, old_balance, new_balance, date, username) 
                            VALUES ('$Gadi_Number', '$userMobile', 'PUC Commission', '$Traking_No', 'Success', '$commission_fee', 'Credit', '$refer_wallet_old', '$refer_wallet_new', '$timestamp', '$parentPhone')");
                        if(!$insert_commission) throw new Exception("Commission record failed");
                                // Send WhatsApp notifications
               $api = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM User_Whatsapp"));
        
// Distibuter notification
$message = urlencode("🚗 *Hello Dear $parentname – Distributor Commission Alert*\n\n
📝 *Purpose:* $purpose\n
🚘 *Vehicle:* $Gadi_Number\n
📦 *Tracking No:* $Traking_No\n
💵 *Your Old Balance:* ₹$refer_wallet_old\n
🤑 *Commission Earned:* ₹$commission_fee\n
💳 *Your Current Balance:* ₹$refer_wallet_new\n
📌 *Status:* $status\n
🗓️ *Date & Time:* $timestamp");

$good_sms_url = "https://{$api['good_sms_link']}/send-message?api_key={$api['api_key']}&sender={$api['sender_no']}&number=91$parentPhone&message=$message";
@file_get_contents($good_sms_url);

                    }
                }
                
                // Commit transaction if all queries succeeded
                mysqli_commit($ahk_conn);
                
                // Send WhatsApp notification Retailer
                if(!empty($userMobile)) {
                    $apis = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM User_Whatsapp"));
                    $message = urlencode("🚗 *PUC Certificate Successfully Uploaded*\n\n📋 *Vehicle:* $Gadi_Number\n\n📩 *Status:* $status\n📆 *$timestamp*");
                    $sms_url = "https://{$apis['good_sms_link']}/send-message?api_key={$apis['api_key']}&sender={$apis['sender_no']}&number=91$userMobile&message=$message";
                    @file_get_contents($sms_url);
                }
                
                echo "<script>
                    Swal.fire({
                        title: 'Success!',
                        text: 'Document uploaded and processed successfully',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location='puc_certificate_admin';
                    });
                </script>";
                
            } catch (Exception $e) {
                // Rollback transaction on error
                mysqli_rollback($ahk_conn);
                // Delete the uploaded file
                unlink($filePath);
                
                error_log("PUC Processing Error: " . $e->getMessage());
                
                echo "<script>
                    Swal.fire({
                        title: 'Error!',
                        text: 'An error occurred while processing your request. Please try again.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                </script>";
            }
        } else {
            echo "<script>
                Swal.fire(
                    'Upload Failed!',
                    'Error while moving uploaded file',
                    'error'
                );
            </script>";
        }
    } else {
        echo "<script>
            Swal.fire(
                'Invalid File Type!',
                'Only PDF, JPEG, PNG files are allowed',
                'error'
            );
        </script>";
    }
}
?>

<!-- Your HTML form would go here -->

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pollution Certificate Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4e73df;
            --secondary-color: #1cc88a;
            --accent-color: #f6c23e;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
        }
        
        body {
            background-color: #f8f9fc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            background-color: var(--primary-color);
            color: white;
            border-radius: 8px 8px 0 0 !important;
            padding: 15px 20px;
        }
        
        .table th {
            background-color: var(--dark-color);
            color: white;
            font-weight: 600;
        }
        
        .badge {
            padding: 6px 10px;
            font-weight: 500;
            border-radius: 4px;
        }
        
        .user-photo {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #e0e0e0;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .user-photo:hover {
            transform: scale(1.1);
        }
        
        .upload-form {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
        }
        
        .action-btns .btn {
            margin: 2px;
        }
        
        /* Modal styles */
        .modal-img-container {
            max-height: 70vh;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-img {
            max-width: 100%;
            max-height: 70vh;
            object-fit: contain;
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid py-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-certificate me-2"></i>POLLUTION CERTIFICATE ADMIN PANEL
                    </h5>
                    <div>
                        <button class="btn btn-sm btn-light" onclick="window.location.reload()">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table id="adminTable" class="table table-hover align-middle mb-0">
                            <thead>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th>Photo</th>
                                    <th>Vehicle No</th>
                                    <th>Vehicle Type</th>
                                    <th>Mobile</th>
                                    <th>Status</th>
                                    <th>Apply Date</th>
                                    <th>Document</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $res = mysqli_query($ahk_conn, "SELECT * FROM Puc_enroll ORDER BY id DESC");
                                if(mysqli_num_rows($res) > 0){
                                    $x = 0;
                                    while($data = mysqli_fetch_assoc($res)){
                                        $x++;
                                        ?>
                                        <tr>
                                            <td class="text-center"><?= $x; ?></td>
                                            <td class="text-center">
                                                <?php if(!empty($data['photo'])): ?>
                                                    <img src="<?= htmlspecialchars($data['photo']); ?>" 
                                                         class="user-photo" 
                                                         data-bs-toggle="modal" 
                                                         data-bs-target="#photoModal" 
                                                         data-photo="<?= htmlspecialchars($data['photo']); ?>"
                                                         alt="User Photo"
                                                         onerror="this.src='https://via.placeholder.com/40'">
                                                <?php else: ?>
                                                    <img src="https://via.placeholder.com/40" class="user-photo" alt="No Photo">
                                                <?php endif; ?>
                                            </td>
                                            <td><?= strtoupper(htmlspecialchars($data['Gadi_Number'] ?? 'N/A')); ?></td>
                                            <td><?= strtoupper(htmlspecialchars($data['Gadi_Typs'] ?? 'N/A')); ?></td>
                                            <td><?= htmlspecialchars($data['mobile_no'] ?? 'N/A'); ?></td>
                                            <td>
                                                <?php if(strtolower($data['status']) == "pending"): ?>
                                                    <span class="badge bg-warning text-dark">
                                                        <i class="fas fa-clock me-1"></i> Pending
                                                    </span>
                                                <?php elseif(strtolower($data['status']) == "success"): ?>
                                                    <span class="badge bg-success text-white">
                                                        <i class="fas fa-check-circle me-1"></i> Approved
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary text-white">
                                                        <?= htmlspecialchars($data['status'] ?? 'N/A'); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= htmlspecialchars($data['date'] ?? 'N/A'); ?></td>
                                            <td>
                                               <?php if(strtolower($data['status']) == "pending" && $data['payment_status'] == "paid"): ?>
                                                    <div class="upload-form">
                                                        <form method="POST" action="" enctype="multipart/form-data">
                                                            <input type="hidden" name="id" value="<?= htmlspecialchars($data['id']); ?>">
                                                            <div class="mb-2">
                                                                <input type="text" class="form-control form-control-sm" 
                                                                       name="Gadi_Number" required 
                                                                       placeholder="Vehicle Number"
                                                                       value="<?= htmlspecialchars($data['Gadi_Number'] ?? ''); ?>">
                                                            </div>
                                                            <div class="mb-2">
                                                                <input type="file" class="form-control form-control-sm" 
                                                                       name="puc_pdf" required 
                                                                       accept=".pdf,.jpg,.jpeg,.png">
                                                            </div>
                                                            <button type="submit" class="btn btn-sm btn-success w-100">
                                                                <i class="fas fa-upload me-1"></i> Upload
                                                            </button>
                                                        </form>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="text-center">
                                                        <p class="mb-1"><strong><?= htmlspecialchars($data['Gadi_Number'] ?? ''); ?></strong></p>
                                                        <?php if(!empty($data['pdf_link'])): ?>
                                                            <a href="<?= htmlspecialchars($data['pdf_link']); ?>" target="_blank" class="btn btn-sm btn-info">
                                                                <i class="fas fa-eye me-1"></i> View
                                                            </a>
                                                            <a href="<?= htmlspecialchars($data['pdf_link']); ?>" download class="btn btn-sm btn-primary mt-1">
                                                                <i class="fas fa-download me-1"></i> Download
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center action-btns">
                                                <a href="#" class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="#" class="btn btn-sm btn-danger" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    ?>
                                    <tr>
                                        <td colspan="10" class="text-center py-4">
                                            <div class="empty-state">
                                                <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">No records found</h5>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Photo Modal -->
<div class="modal fade" id="photoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">User Photo</h5>
                <div>
                    <a href="#" id="downloadPhoto" class="btn btn-sm btn-light me-2">
                        <i class="fas fa-download me-1"></i> Download
                    </a>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
            </div>
            <div class="modal-body text-center p-0">
                <div class="modal-img-container">
                    <img id="modalPhoto" src="" class="modal-img" alt="User Photo">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>

<!-- JavaScript Libraries -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#adminTable').DataTable({
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        language: {
            search: "_INPUT_",
            searchPlaceholder: "Search applications...",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                previous: "<i class='fas fa-chevron-left'></i>",
                next: "<i class='fas fa-chevron-right'></i>"
            }
        },
        responsive: true
    });

    // Photo modal handler with download functionality
    $('#photoModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var photoUrl = button.data('photo');
        var modal = $(this);
        
        // Set image source
        modal.find('#modalPhoto').attr('src', photoUrl);
        
        // Set download link
        modal.find('#downloadPhoto').attr('href', photoUrl);
        modal.find('#downloadPhoto').attr('download', 'user-photo-' + new Date().getTime() + '.jpg');
    });

    // Delete confirmation
    $('.btn-danger').click(function(e) {
        e.preventDefault();
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                // Add your delete logic here
                Swal.fire(
                    'Deleted!',
                    'The record has been deleted.',
                    'success'
                );
            }
        });
    });
});
</script>
</body>
</html>