<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pollution Certificate Customber</title>
   
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4e73df;
            --success: #1cc88a;
            --warning: #f6c23e;
            --danger: #e74a3b;
            --dark: #5a5c69;
            --light: #f8f9fc;
        }
        
        .card {
            border-radius: 0.35rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }
        
        .table th {
            background-color: var(--dark);
            color: white;
        }
        
        .badge-pending {
            background-color: var(--warning);
            color: #000;
        }
        
        .badge-approved {
            background-color: var(--success);
            color: #fff;
        }
        
        .user-photo {
            width: 50px;
            height: 50px;
            border-radius: 4px;
            object-fit: cover;
            cursor: pointer;
            transition: transform 0.2s;
            border: 1px solid #ddd;
        }
        
        .user-photo:hover {
            transform: scale(1.1);
        }
        
        .action-btn {
            width: 32px;
            height: 32px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        .upload-container {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
        }
        
        /* Fix for image modal */
        #modalPhoto {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }
        
        /* Ensure table images are properly sized */
        .photo-col {
            width: 60px;
        }
        
        /* Fix for empty image placeholder */
        .user-photo[src*="placeholder.com"] {
            object-fit: contain;
            background: #f5f5f5;
            padding: 5px;
        }
    </style>
</head>
<body>
        <!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
    <div class="container-fluid py-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-certificate fa-fw me-2"></i>
                    Pollution Certificate Applications
                </h6>
                <div>
                    <button class="btn btn-sm btn-outline-primary" id="refreshBtn">
                        <i class="fas fa-sync-alt fa-fw"></i> Refresh
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="applicationsTable" class="table table-hover" style="width:100%">
                         <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="photo-col">Photo</th>
                                <th>Application No</th>
                                <th>Vehicle No</th>
                                <th>Vehicle Type</th>
                                <th>State</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th>Apply Date</th>
                                <th>Payment</th>
                                <th>Fee</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $res = mysqli_query($ahk_conn,"SELECT * FROM Puc_enroll WHERE appliedby='".$udata['phone']."' ORDER BY id DESC");
                            if(mysqli_num_rows($res)>0){
                                $x=0;
                                while($data = mysqli_fetch_assoc($res)){
                                    $x++;
                                    // Handle image path - ensure it's properly formatted
                                    $photoUrl = !empty($data['photo']) ? $data['photo'] : 'https://via.placeholder.com/50x50?text=No+Image';
                                    // Fix URL if it starts with /uploads (example)
                                    if (strpos($photoUrl, '/uploads') === 0) {
                                        $photoUrl = '..' . $photoUrl;
                                    }
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $x; ?></td>
                                        <td class="text-center">
                                            <img src="<?= $photoUrl; ?>" 
                                                 class="user-photo" 
                                                 data-bs-toggle="modal" 
                                                 data-bs-target="#photoModal" 
                                                 data-photo="<?= $photoUrl; ?>"
                                                 alt="Vehicle Photo"
                                                 onerror="this.onerror=null;this.src='https://via.placeholder.com/50x50?text=Image+Error'">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-2 text-primary">
                                                    <i class="fas fa-file-alt"></i>
                                                </div>
                                                <div>
                                                    <span class="application-no"><?= $data['srno'] ?? 'N/A'; ?></span>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?= strtoupper($data['Gadi_Number'] ?? 'N/A'); ?></td>
                                        <td><?= strtoupper($data['Gadi_Typs'] ?? 'N/A'); ?></td>
                                        <td><?= strtoupper($data['state'] ?? 'N/A'); ?></td>
                                        <td><?= $data['mobile_no'] ?? 'N/A'; ?></td>
                                        <td>
                                            <?php if($data['status'] == "pending"): ?>
                                                <span class="badge bg-warning text-dark status-badge">
                                                    <i class="fas fa-clock me-1"></i> Pending
                                                </span>
                                            <?php elseif($data['status'] == "success"): ?>
                                                <span class="badge bg-success text-white status-badge">
                                                    <i class="fas fa-check-circle me-1"></i> Approved
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary text-white status-badge">
                                                    <?= $data['status'] ?? 'N/A'; ?>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= $data['date'] ?? 'N/A'; ?></td>
                                        <td>
                                            <?php if($data['payment_status'] == "paid"): ?>
                                                <span class="badge bg-success text-white">
                                                    Paid
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-danger text-white">
                                                    Unpaid
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>₹<?= number_format($data['fee'] ?? 0, 2); ?></td>
                                        <td class="text-center action-btns">
                                            <?php if($data['status'] == "success"): ?>
                                                <div class="text-center">
                                                    <a download="<?= $data['Gadi_Number'] ?>" href="<?= $data['pdf_link'] ?>" class="btn btn-sm btn-success">Download PDF</a>
                                                </div>
                                                 <?php else: ?>
                                                   <span class="badge bg-danger text-white">
                                                    Pdf Not Uploded
                                                </span>
                                                <hr>
                                                 <a href="#" class="btn btn-sm btn-primary" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php endif; ?>
                                           
                                        </td>
                                    </tr>
                                    <?php
                                }
                            } else {
                                ?>
                                <tr>
                                    <td colspan="13" class="text-center">
                                        <div class="empty-state py-5">
                                            <i class="fas fa-folder-open"></i>
                                            <h5 class="mt-3 text-muted">No records found</h5>
                                            <p class="text-muted">You don't have any pollution certificate applications yet.</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

   
    <!-- Photo Modal -->
    <div class="modal fade" id="photoModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Vehicle Photo</h5>
                    <div>
                        <a href="#" id="downloadPhoto" class="btn btn-sm btn-light me-2">
                            <i class="fas fa-download me-1"></i> Download
                        </a>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                </div>
                <div class="modal-body p-0 text-center">
                    <img id="modalPhoto" src="" class="img-fluid" style="max-height: 70vh;">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> Close
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#applicationsTable').DataTable({
                dom: '<"top"f>rt<"bottom"lip><"clear">',
                language: {
                    search: "_INPUT_",
                    searchPlaceholder: "Search applications...",
                    lengthMenu: "Show _MENU_ entries",
                    info: "Showing _START_ to _END_ of _TOTAL_ entries",
                    paginate: {
                        previous: "<i class='fas fa-chevron-left'></i>",
                        next: "<i class='fas fa-chevron-right'></i>"
                    }
                },
                initComplete: function() {
                    $('.dataTables_filter input').addClass('form-control');
                    $('.dataTables_length select').addClass('form-select');
                },
                responsive: true
            });

            // Photo modal handler
            $('#photoModal').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget);
                var photoUrl = button.data('photo');
                var modal = $(this);
                modal.find('#modalPhoto').attr('src', photoUrl);
                
                // Set download link
                $('#downloadPhoto').attr('href', photoUrl);
                $('#downloadPhoto').attr('download', 'vehicle-photo-' + new Date().getTime() + '.jpg');
            });
            
            // Refresh button handler
            $('#refreshBtn').click(function() {
                location.reload();
            });
        });
    </script>
<!--end page wrapper -->
<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
		$(document).ready(function() {
			$('#example').DataTable();
		  } );
	</script>
	
	<script>
		$(document).ready(function() {
			var table = $('#example2').DataTable( {
				lengthChange: false,
				buttons: [ 'copy', 'excel', 'pdf', 'print']
			} );
		 
			table.buttons().container()
				.appendTo( '#example2_wrapper .col-md-6:eq(0)' );
		} );
	</script>
	
</body>
</html>