/**
 * SprintApi Pro
 * Version: 1.0.0
 * Author: Pansprint Infotech
 * License: MIT (or specify the license you prefer)
 * 
 * Copyright (c) 2023 Pansprint Infotech. All rights reserved.
 */
 
function Ps_alert(message, type) {
      var alertDiv = document.createElement("div");
    
      // Determine the alert class based on the type parameter
      if (type === "success") {
        alertDiv.className = "alert ps-alert-success";
      } else if (type === "error") {
        alertDiv.className = "alert ps-alert-danger";
      } else if (type === "info") {
        alertDiv.className = "alert ps-alert-info";
      } else {
        // Default to "info" if an invalid type is provided
        alertDiv.className = "alert ps-alert-info";
      }
    
      // Set the message text
      alertDiv.textContent = message;
    
      // Set the position, width, and text alignment
      alertDiv.style.position = "fixed";
      alertDiv.style.bottom = "-20px";
      alertDiv.style.left = "0";
      alertDiv.style.right = "0";
      alertDiv.style.textAlign = "center";
      alertDiv.style.padding = "10px";
      alertDiv.style.display = "flex";
    
      // Append the alert to the document body
      document.body.appendChild(alertDiv);
    
      // Automatically remove the alert after a few seconds (adjust the timeout as needed)
      setTimeout(function () {
        document.body.removeChild(alertDiv);
      }, 7000); // This will remove the alert after 3 seconds
    }
    
    
    
    
    
    
    