<?php
session_start();
include('./includes/config.php');

// Get IP address
$ip_address = $_SERVER['REMOTE_ADDR']; 

// Get device information from the user agent
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$device_info = "Device: " . (preg_match('/mobile/i', $user_agent) ? 'Mobile' : 'Desktop') . ", Browser: " . (preg_match('/Chrome/i', $user_agent) ? 'Chrome' : (preg_match('/Firefox/i', $user_agent) ? 'Firefox' : 'Other'));

// Fetch location information
$geo_info = @file_get_contents("https://ipinfo.io/{$ip_address}/json");
$geo_data = json_decode($geo_info, true);
$location = isset($geo_data['city']) ? $geo_data['city'] . ', ' . $geo_data['region'] . ', ' . $geo_data['country'] : 'Unknown Location';

// Variable for SweetAlert message
$show_alert = false;
$alert_type = '';
$alert_title = '';
$alert_message = '';

if(isset($_POST['username']) && !empty($_POST['username'])){
    $username = mysqli_real_escape_string($ahk_conn,$_POST['username']);
    $password = mysqli_real_escape_string($ahk_conn,$_POST['password']);
    $time = date("Y-m-d H:i:s");

    $fetch = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$username' or email='$username'");
    if(mysqli_num_rows($fetch) == '1'){
        $data = mysqli_fetch_assoc($fetch);
        if($data['status'] == 'active'){
            if(password_verify($password, $data['password'])){
                // Fetching user details from users table
                $AWS = mysqli_fetch_array(mysqli_query($ahk_conn, "SELECT * FROM `users` WHERE `phone`='$username'"));
                $fullname = $AWS['name'];
                $apply_by = $AWS['phone'];
                $user_number = '91' . $apply_by;

                // Get current date and time with AM/PM
                $current_datetime = date("d-m-Y h:i:s A");
                $current_time = date("h:i:s A");

                // Crafting the WhatsApp message
                $usermsg = urlencode("🌟 *Login Notification* 🌟\n\n"
                    . "📅 *Date & Time:* $current_datetime\n\n"
                    . "👤 *User Details:*\n"
                    . "• Name: *$fullname*\n"
                    . "• Phone: *$apply_by*\n\n"
                    . "🖥️ *Login Information:*\n"
                    . "• Login Time: *$current_time*\n"
                    . "• IP Address: *$ip_address*\n"
                    . "• Device: *$device_info*\n"
                    . "• Location: *$location*\n"
                    . "• Server: *$PowerBy*\n\n"
                    . "✅ Your login was successful at *$current_time*!\n"
                    . "Thank you for staying connected with us.\n\n"
                    . "💬 Join our WhatsApp group for updates:\n"
                    . "$whatsapp_url");

                // Sending the WhatsApp message
                $sms_url = "https://$good_sms_url/send-message?api_key={$good_sms_kay}&sender={$good_sms_sender}&number={$user_number}&message=$usermsg";
                @file_get_contents($sms_url);   

                if(!isset($_SESSION)){
                    session_start();
                }
                $_SESSION['phone'] = $data['phone'];
                
                // Set success alert
                $show_alert = true;
                $alert_type = 'success';
                $alert_title = 'Success!';
                $alert_message = 'Login Successful';
                
                // Redirect after 2 seconds
                echo "<script>
                    setTimeout(function() {
                        window.location.href = 'admin';
                    }, 2000);
                </script>";
                
            } else {
                // Set error alert for wrong password
                $show_alert = true;
                $alert_type = 'error';
                $alert_title = 'Incorrect Password';
                $alert_message = 'Please Enter Valid Password!';
            }
        } else {
            // Set error alert for inactive account
            $show_alert = true;
            $alert_type = 'error';
            $alert_title = 'Account Inactive';
            $alert_message = 'Your Account Is Not Active, Contact With Team!';
        }
    } else {
        // Set error alert for not registered
        $show_alert = true;
        $alert_type = 'error';
        $alert_title = 'Not Found';
        $alert_message = 'Email or Phone Is Not Registered!';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php ahkweb('webname'); ?></title>
    
    <!-- jQuery and SweetAlert -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="icon" href="data:image/png;base64,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">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-wrapper {
            width: 100%;
            max-width: 420px;
            animation: slideUp 0.5s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
        }

        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            text-align: center;
            color: white;
        }

        .login-header .icon {
            font-size: 60px;
            margin-bottom: 15px;
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            width: 100px;
            height: 100px;
            line-height: 100px;
            border-radius: 50%;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
            }
            70% {
                box-shadow: 0 0 0 15px rgba(255, 255, 255, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
            }
        }

        .login-header h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
        }

        .login-header p {
            margin: 10px 0 0;
            opacity: 0.9;
            font-size: 14px;
        }

        .login-body {
            padding: 40px 30px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
            font-size: 14px;
        }

        .input-group {
            position: relative;
            display: flex;
            align-items: center;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            color: #999;
            font-size: 18px;
            transition: color 0.3s;
            z-index: 1;
        }

        .input-group input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #e1e5ee;
            border-radius: 12px;
            font-size: 15px;
            transition: all 0.3s;
            background: #f8f9fa;
        }

        .input-group input:focus {
            border-color: #667eea;
            outline: none;
            background: white;
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.1);
        }

        .input-group input:focus + i {
            color: #667eea;
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            left: auto !important;
            cursor: pointer;
            color: #999;
            z-index: 2;
        }

        .password-toggle:hover {
            color: #667eea;
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            color: #666;
            font-size: 14px;
        }

        .remember-me input {
            width: 18px;
            height: 18px;
            cursor: pointer;
            accent-color: #667eea;
        }

        .forgot-link {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .login-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            color: white;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }

        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .login-btn:active {
            transform: translateY(0);
        }

        .login-btn i {
            margin-right: 8px;
        }

        .register-section {
            text-align: center;
            margin-top: 25px;
            padding-top: 25px;
            border-top: 1px solid #e1e5ee;
        }

        .register-section p {
            color: #666;
            font-size: 14px;
        }

        .register-section a {
            color: #667eea;
            font-weight: 600;
            text-decoration: none;
        }

        .register-section a:hover {
            text-decoration: underline;
        }

        .login-footer {
            text-align: center;
            margin-top: 20px;
            color: rgba(255, 255, 255, 0.8);
            font-size: 13px;
        }

        .login-footer a {
            color: white;
            text-decoration: none;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        @media (max-width: 480px) {
            .login-header {
                padding: 30px 20px;
            }
            
            .login-body {
                padding: 30px 20px;
            }
            
            .form-options {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>
    <div class="login-wrapper">
        <div class="login-card">
            <div class="login-header">
                <div class="icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h2>Welcome Back! 👋</h2>
                <p><?php ahkweb('webname'); ?> Login</p>
            </div>

            <div class="login-body">
                <form method="POST" action="" id="loginForm">
                    <div class="form-group">
                        <label>Username / Email / Phone</label>
                        <div class="input-group">
                            <i class="fas fa-user"></i>
                            <input type="text" 
                                   name="username" 
                                   id="username"
                                   placeholder="Enter your username, email or phone"
                                   required 
                                   autofocus>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Password</label>
                        <div class="input-group" id="show_hide_password">
                            <i class="fas fa-lock"></i>
                            <input type="password" 
                                   name="password" 
                                   id="password"
                                   placeholder="Enter your password"
                                   required>
                            <a href="javascript:;" class="password-toggle">
                                <i class="fas fa-eye"></i>
                            </a>
                        </div>
                    </div>

                    <div class="form-options">
                        <label class="remember-me">
                            <input type="checkbox" name="remember" id="remember">
                            <span>Remember me</span>
                        </label>
                        <a href="forgot-password.php" class="forgot-link">
                            Forgot Password?
                        </a>
                    </div>

                    <button type="submit" class="login-btn" id="loginBtn">
                        <i class="fas fa-sign-in-alt"></i>
                        Login
                    </button>
                </form>

                <div class="register-section">
                    <p>Don't have an account? <a href="register.php">Create New Account</a></p>
                </div>
            </div>
        </div>

        <div class="login-footer">
            <p>&copy; <?php echo date('Y'); ?> <?php ahkweb('webname'); ?>. All rights reserved.</p>
        </div>
    </div>

    <?php if($show_alert): ?>
    <script>
        $(document).ready(function() {
            Swal.fire({
                icon: '<?php echo $alert_type; ?>',
                title: '<?php echo $alert_title; ?>',
                text: '<?php echo $alert_message; ?>',
                confirmButtonColor: '#667eea',
                <?php if($alert_type == 'success'): ?>
                timer: 2000,
                showConfirmButton: false,
                willClose: () => {
                    window.location.href = 'admin';
                }
                <?php endif; ?>
            });
        });
    </script>
    <?php endif; ?>

    <script>
        $(document).ready(function() {
            // Password show/hide functionality
            $("#show_hide_password a").on('click', function(event) {
                event.preventDefault();
                var input = $(this).closest('.input-group').find('input');
                var icon = $(this).find('i');
                
                if (input.attr("type") == "text") {
                    input.attr('type', 'password');
                    icon.removeClass("fa-eye-slash").addClass("fa-eye");
                } else {
                    input.attr('type', 'text');
                    icon.removeClass("fa-eye").addClass("fa-eye-slash");
                }
            });

            // Remember me functionality
            if (localStorage.getItem('rememberedUser')) {
                $('#username').val(localStorage.getItem('rememberedUser'));
                $('#remember').prop('checked', true);
            }

            $('#remember').change(function() {
                if ($(this).is(':checked')) {
                    localStorage.setItem('rememberedUser', $('#username').val());
                } else {
                    localStorage.removeItem('rememberedUser');
                }
            });

            $('#username').on('change', function() {
                if ($('#remember').is(':checked')) {
                    localStorage.setItem('rememberedUser', $(this).val());
                }
            });

            // Form submit animation
            $('#loginForm').on('submit', function() {
                $('#loginBtn').html('<i class="fas fa-spinner fa-spin"></i> Logging in...').prop('disabled', true);
            });
        });
    </script>
</body>
</html>