<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Responses BY Pay.pgfast</title>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
</head>
<body>

<?php
session_start();
include '../includes/config.php';

if (!isset($_SESSION['order_id'])) {
    echo "<script>Swal.fire('Error','Order ID not set in session','error');</script>";
    exit;
}

$order_id        = $_SESSION['order_id'];
$customer_mobile = $_SESSION['customer_mobile'];
$minimum_amount  = 1;

// --------------------------------------
// CHECK IF WALLET ALREADY UPDATED
// --------------------------------------
$check_wallet = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE txn_id='$order_id'");
if (!$check_wallet) {
    die("SQL ERROR : " . mysqli_error($ahk_conn));
}

$wallet_data = mysqli_fetch_assoc($check_wallet);

if (!$wallet_data || $wallet_data['status'] != "pending") {
    echo "<script>
        Swal.fire('Already Processed','Wallet Already Updated','warning')
        .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
    </script>";
    exit;
}

// --------------------------------------
// CALL PAYMENT GATEWAY API
// --------------------------------------
$url = "https://$good_upi_url/api/check-order-status";

$postData = array(
    "user_token" => $good_upi_kay,
    "order_id"   => $order_id
);

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo "<script>Swal.fire('cURL Error','".curl_error($ch)."','error');</script>";
    exit;
}
curl_close($ch);

$responseData = json_decode($response, true);

// --------------------------------------
// VALIDATE RESPONSE
// --------------------------------------
if (empty($responseData["result"])) {
    echo "<script>
        Swal.fire('API ERROR','Invalid Response from API','error')
        .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
    </script>";
    exit;
}

// Extract Values
$txnStatus  = $responseData["result"]["txnStatus"];   // COMPLETE
$status     = $responseData["result"]["status"];      // SUCCESS
$amount     = $responseData["result"]["amount"];
$utr        = $responseData["result"]["utr"];
$resultInfo = $responseData["result"]["resultInfo"];

// --------------------------------------
// CHECK PAYMENT SUCCESS
// --------------------------------------
if ($status == "SUCCESS" && $txnStatus == "COMPLETED") {

    // -------------------------
    // AMOUNT VALIDATION
    // -------------------------
    if ($amount >= $minimum_amount) {

        // UPDATE USER WALLET
        $sql1 = "UPDATE users SET balance = balance + $amount WHERE phone='$customer_mobile'";

        // UPDATE WALLET TABLE
        $sql2 = "
            UPDATE wallet SET 
                status = 'success',
                amount = '$amount',
                BANKTXNID = '$utr',
                RESPMSG = '$resultInfo',
                PAYMENTMODE = 'UPI QR'
            WHERE txn_id = '$order_id'
        ";

        if ($ahk_conn->query($sql1) && $ahk_conn->query($sql2)) {

            // SMS Notification
            $userInfo = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$customer_mobile'"));
            $fullname = $userInfo['name'];
            $apply_by = $userInfo['phone'];
            $mob      = "91".$apply_by;

            $msg = urlencode("Congratulations 🎉 Dear *$fullname*\n\nYour Wallet Load Successfully\nAmount : ₹$amount\nOrder Id : $order_id\n\nThank You!");

            file_get_contents("https://$good_sms_url/send-message?api_key=$good_sms_kay&sender=$good_sms_sender&number=$mob&message=$msg");

            // SUCCESS ALERT
            echo "<script>
                Swal.fire('SUCCESS','Wallet Updated Successfully','success')
                .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
            </script>";
            exit;

        } else {
            echo "<script>
                Swal.fire('DB ERROR','".$ahk_conn->error."','error')
                .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
            </script>";
            exit;
        }

    } else {

        // CHEATING ATTEMPT (LOW AMOUNT)
        mysqli_query($ahk_conn, "
            UPDATE wallet SET 
                status='success',
                amount='$amount',
                BANKTXNID='$utr',
                RESPMSG='Low Amount – Not Added',
                PAYMENTMODE='UPI – LOW AMOUNT'
            WHERE txn_id='$order_id'
        ");

        echo "<script>
            Swal.fire('Invalid Amount','Minimum load ₹$minimum_amount required','error')
            .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
        </script>";
        exit;
    }

} else {

    echo "<script>
        Swal.fire('FAILED','Payment Not Successful','error')
        .then(()=>{ window.location.href='https://$sarvar_url/admin/wallet.php'; });
    </script>";
    exit;
}

?>

</body>
</html>
