<?php
include('./includes/config.php');

function sendWhatsAppGoodSms($ahk_conn, $mobile, $message, $amount = 0, $footer = 'Sent via GoodSms')
{
    $api = mysqli_fetch_assoc(
        mysqli_query($ahk_conn, "SELECT * FROM User_Whatsapp LIMIT 1")
    );

    $params = [
        'api_key' => $api['api_key'],
        'sender'  => $api['sender_no'],
        'number'  => $mobile,        // 91XXXXXXXXXX
        'message' => $message,
        'amount'  => $amount,        // 🔴 REQUIRED BY API
        'footer'  => $footer
    ];

    $api_url = "https://" . $api['good_sms_link'] . "/send-message?" . http_build_query($params);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return json_decode($response, true);
}


/* ================= REF CODE ================= */
$ref_code = '';
if (isset($_GET['ref']) && $_GET['ref'] != '') {
    $ref_code = base64_decode(mysqli_real_escape_string($ahk_conn, $_GET['ref']));
}

include('./template/ahkweb/authentication-signup.php');

/* ================= SIGNUP ================= */
if (isset($_POST['phone']) && !empty($_POST['phone'])) {

    $name     = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $email    = mysqli_real_escape_string($ahk_conn, $_POST['email']);
    $phone    = mysqli_real_escape_string($ahk_conn, $_POST['phone']);
    $usertype = mysqli_real_escape_string($ahk_conn, $_POST['usertype']);
    $password = $_POST['password'];
    $cpassword = $_POST['cpassword'];

    $order_id = "REG-" . rand(100000, 999999);
    $price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT * FROM users"));
    /* ===== REGISTRATION FEE ===== */
    if ($usertype == "retailer") {
        $amount = $price['retailer_fee'];
    } elseif ($usertype == "distributor") {
        $amount = $price['distributor_fee'];
    } else {
        $amount = 999;
    }

    if (in_array(strtolower($usertype), ['admin'])) {
        echo "<script>
                Swal.fire('Error','Invalid User Type','error');
              </script>";
        exit;
    }

    /* ===== CHECK USER ===== */
    $check = mysqli_query($ahk_conn, "SELECT id FROM users WHERE phone='$phone' OR email='$email'");
    if (mysqli_num_rows($check) > 0) {
        echo "<script>
                Swal.fire('Oops','Phone or Email Already Exists','error');
              </script>";
        exit;
    }

    if ($password != $cpassword) {
        echo "<script>
                Swal.fire('Oops','Password Not Matched','error');
              </script>";
        exit;
    }

    $hashPass = password_hash($password, PASSWORD_DEFAULT);
    date_default_timezone_set("Asia/Kolkata");
    $date = date("d-m-Y");

    /* ===== INSERT USER ===== */
    $res = mysqli_query($ahk_conn,
        "INSERT INTO users (`name`,`phone`,`email`,`password`,`type`,`status`,`referred_by`,`order_id`,`date`)
         VALUES ('$name','$phone','$email','$hashPass','$usertype','0','$ref_code','$order_id','$date')"
    );

    if ($res) {

        if ($ref_code != '') {
            mysqli_query($ahk_conn,
                "INSERT INTO referal (`phone`,`referred_by`,`txn_no`,`referral_balance`,`status`)
                 VALUES ('$phone','$ref_code','REF" . rand(10000, 99999) . "','" . $webdata['ref_bal'] . "','1')"
            );
        }

        /* ===== WALLET ENTRY (QR) ===== */
        if ($_POST['mode'] == "qr") {
            mysqli_query($ahk_conn,
                "INSERT INTO wallet (`phone`,`amount`,`txn_id`,`email`,`status`,`date`,`PAYMENTMODE`)
                 VALUES ('$phone','$amount','$order_id','$email','pending','$date','REGQR')"
            );

            /* ===== WHATSAPP MESSAGE ===== */
            $mobile = '91' . $phone;

            $message = "Congratulations 🎉 dear { *$name* }

📝 *New Account Registered Successfully*

📱 Mobile : $phone
📧 Email : $email
👤 User Type : $usertype

💰 Registration Fee : ₹$amount
🆔 Order ID : $order_id

🔐 Password : *$password*

🌐 Login Here :
$sarvar_url

♻ Thanks for joining *$PowerBy* ♻
Join WhatsApp :
$whatsapp_url";

            sendWhatsAppGoodSms($ahk_conn, $mobile, $message, 'Registration Alert');

            /* ===== REDIRECT TO PAYMENT ===== */
            ?>
            <form method="post" name="payform" action="../payment/regpg.php">
                <input type="hidden" name="frompage" value="reg">
                <input type="hidden" name="order_id" value="<?php echo $order_id; ?>">
                <input type="hidden" name="phone" value="<?php echo $phone; ?>">
                <input type="hidden" name="amount" value="<?php echo $amount; ?>">
            </form>
            <script>document.payform.submit();</script>
            <?php
        }
    }
}
?>

