<?php
include('header.php');
?>
<?php
$panData = $_SESSION['PAN_ADV'] ?? [];

$panNumber = $panData['pan'] ?? '';
$name = $panData['name'] ?? '';
$fathername = $panData['father'] ?? '';
$dob = $panData['dob'] ?? '';
$gender = $panData['gender'] ?? '';
?>
<!--start page wrapper -->
<div class="page-wrapper">
<div class="container my-5">
  <div class="card shadow rounded-4">
    <div class="card-header bg-primary text-white rounded-top-4">
      <h4 class="mb-0"><i class="bx bxs-id-card me-2"></i> PAN Card Manual Entry</h4>
    </div>

    <div class="card-body p-4">
      <form method="post" enctype="multipart/form-data" onsubmit="return validation();" autocomplete="off">

        <div class="mb-3">
          <label class="form-label fw-semibold">Select PAN Card Type</label>
          <select name="ptype" id="ptype" class="form-select form-select-lg rounded-pill" required>
            <option value="">-- Select Type --</option>
            <option value="UTI-NONMINOR">(18 साल या उस से ज्यादा उम्र के लिए)</option>
            <option value="NSDL-NONMINOR">NSDL NONMINOR</option>
            <option value="UTI-MINOR">UTI MINOR</option>
            <option value="NSDL-MINOR">NSDL MINOR</option>
          </select>
        </div>

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">PAN Card Number</label>
            <input type="text" name="pannumber" id="pannumber"
              value="<?php echo $panNumber; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              maxlength="10" readonly required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold">Full Name</label>
            <input type="text" name="name"
              value="<?php echo $name; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              readonly required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold">Father's Name</label>
            <input type="text" name="fathername"
              value="<?php echo $fathername; ?>"
              class="form-control form-control-lg rounded-pill text-uppercase"
              readonly required>
          </div>

          <div class="col-md-3">
            <label class="form-label fw-semibold">Date of Birth</label>
            <input type="text" name="dobadhar"
              value="<?php echo $dob; ?>"
              class="form-control form-control-lg rounded-pill"
              readonly required>
          </div>

          <div class="col-md-3">
            <label class="form-label fw-semibold">Gender</label>
            <select name="gender" class="form-select form-select-lg rounded-pill" readonly required>
              <option value="<?php echo $gender; ?>"><?php echo $gender; ?></option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold" id="stype">Upload Photo</label>
            <input type="file" name="imagefile" class="form-control form-control-lg rounded-pill" required>
          </div>

          <div class="col-md-6">
            <label class="form-label fw-semibold" id="simgs">Upload Signature</label>
            <input type="file" name="signfile" class="form-control form-control-lg rounded-pill" required>
          </div>
        </div>

        <div class="mt-4 d-flex justify-content-between align-items-center">
          <h5 class="text-warning">
            Application Fee: ₹<?php echo $price['pan_advance_fee']; ?>
          </h5>
          <button type="submit" name="savedata" class="btn btn-lg btn-success rounded-pill px-5">
            <i class="bi bi-check2-circle me-1"></i> Submit
          </button>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
function validation() {
  const pan = document.getElementById("pannumber");
  const error = document.getElementById("erroraadharno");
  if (pan.value.length !== 10) {
    error.innerText = "Please enter a valid 10-digit PAN number.";
    pan.classList.add("is-invalid");
    pan.focus();
    return false;
  }
  return true;
}

function ValidatePAN() {
  const pan = document.getElementById("pannumber");
  const pattern = /^([A-Z]{5})(\d{4})([A-Z]{1})$/;
  if (pan.value && !pattern.test(pan.value)) {
    alert("Invalid PAN format (Example: ABCDE1234F)");
    pan.value = '';
    pan.focus();
    return false;
  }
}

function previewImage(input, targetImg, hiddenInput) {
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = function (e) {
      document.getElementById(targetImg).src = e.target.result;
      document.getElementById(targetImg).classList.remove("d-none");
      document.getElementById(hiddenInput).value = e.target.result;
    };
    reader.readAsDataURL(input.files[0]);
  }
}

document.getElementById("imgInp").addEventListener("change", function () {
  previewImage(this, 'blah', 'blahin');
});
document.getElementById("signInp").addEventListener("change", function () {
  previewImage(this, 'blahs', 'blahsin');
});

// Hide Signature Field for MINOR
document.getElementById("ptype").addEventListener("change", function () {
  const isMinor = this.value.includes("MINOR");
  document.getElementById("signInp").style.display = isMinor ? "none" : "block";
  document.getElementById("simgs").style.display = isMinor ? "none" : "block";
});
</script>
		<?php 
		include('footer.php');
		?>
	<!-- Bootstrap JS -->
	<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/ahkweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
<script>
	$(document).ready(function() {
	
	$('#eid').inputmask();
	$('#date').inputmask();
	$('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        // hourFormat: 24
      });
	});
</script>
</html>