<?php include('header.php'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
        title: "<?php echo $title; ?>",
        text: '<?php echo $News_Message; ?>',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
});
</script>

<style>
/* Modern Dashboard CSS */
:root {
    --primary: #4361ee;
    --secondary: #3f37c9;
    --success: #4cc9f0;
    --danger: #f72585;
    --warning: #f8961e;
    --info: #4895ef;
    --light: #f8f9fa;
    --dark: #212529;
    --gradient-1: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --gradient-2: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    --gradient-3: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    --gradient-4: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    --shadow-sm: 0 2px 8px rgba(0,0,0,0.1);
    --shadow-md: 0 5px 20px rgba(0,0,0,0.15);
    --shadow-lg: 0 8px 30px rgba(0,0,0,0.2);
    --radius-sm: 10px;
    --radius-md: 15px;
    --radius-lg: 25px;
}

body {
    background: #f0f2f5;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.page-wrapper {
    padding: 20px;
}

/* Statistics Card */
.stat-card-wrapper {
    margin-bottom: 30px;
}

.stat-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: var(--radius-md);
    padding: 20px;
    box-shadow: var(--shadow-md);
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    text-decoration: none;
    display: block;
    color: white;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow-lg);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: rgba(255,255,255,0.1);
    transform: rotate(45deg);
    transition: all 0.5s ease;
}

.stat-card:hover::before {
    transform: rotate(45deg) translate(20%, 20%);
}

.stat-icon {
    font-size: 40px;
    opacity: 0.8;
    margin-bottom: 10px;
}

.stat-number {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 5px;
    line-height: 1;
}

.stat-label {
    font-size: 14px;
    opacity: 0.9;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.stat-trend {
    position: absolute;
    top: 20px;
    right: 20px;
    background: rgba(255,255,255,0.2);
    padding: 5px 10px;
    border-radius: 50px;
    font-size: 12px;
    font-weight: 600;
}

/* Marquee Styles */
.marquee-container {
    border-radius: 50px;
    overflow: hidden;
    margin-bottom: 15px;
    box-shadow: var(--shadow-sm);
}

.marquee-text {
    padding: 15px 25px;
    color: white;
    font-weight: 600;
    font-size: 16px;
    white-space: nowrap;
    background: var(--gradient-1);
}

/* Service Cards Grid */
.service-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 20px;
    margin-top: 30px;
}

.service-card {
    background: white;
    border-radius: var(--radius-md);
    overflow: hidden;
    box-shadow: var(--shadow-sm);
    transition: all 0.3s ease;
    position: relative;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.service-card:hover {
    transform: translateY(-8px);
    box-shadow: var(--shadow-lg);
}

/* Card Header with Gradient */
.card-header-gradient {
    height: 100px;
    position: relative;
    overflow: hidden;
}

.gradient-bg-1 { background: var(--gradient-1); }
.gradient-bg-2 { background: var(--gradient-2); }
.gradient-bg-3 { background: var(--gradient-3); }
.gradient-bg-4 { background: var(--gradient-4); }

/* Price Badge */
.price-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: rgba(255,255,255,0.95);
    padding: 8px 18px;
    border-radius: 50px;
    font-weight: 700;
    font-size: 18px;
    color: var(--primary);
    box-shadow: var(--shadow-sm);
    z-index: 2;
    backdrop-filter: blur(5px);
}

.price-badge small {
    font-size: 12px;
    font-weight: normal;
    color: #666;
}

/* Card Icon - Image Style */
.card-icon {
    position: absolute;
    bottom: -20px;
    left: 20px;
    width: 60px;
    height: 60px;
    background: white;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: var(--shadow-md);
    z-index: 2;
    border: 3px solid white;
    overflow: hidden; /* Image को circle में रखने के लिए */
    padding: 5px;
}

.service-img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Image को सही से fit करने के लिए */
    border-radius: 10px;
}

/* अगर आपको background image चाहिए तो */
.card-header-image {
    height: 140px;
    position: relative;
    overflow: hidden;
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
}

/* Price badge पर ध्यान दें */
.price-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: rgba(255,255,255,0.95);
    padding: 8px 18px;
    border-radius: 50px;
    font-weight: 700;
    font-size: 18px;
    color: var(--primary);
    box-shadow: var(--shadow-sm);
    z-index: 3;
}

/* Card Content */
.card-content {
    padding: 30px 20px 20px;
    flex: 1;
}

.service-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--dark);
    margin-bottom: 10px;
    line-height: 1.4;
    min-height: 45px;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.service-meta {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 15px;
}

.service-type {
    background: #eef2f6;
    padding: 4px 12px;
    border-radius: 50px;
    font-size: 11px;
    font-weight: 600;
    color: #555;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.service-rating {
    color: #ffc107;
    font-size: 12px;
}

.service-rating span {
    color: #666;
    margin-left: 5px;
}

/* Price Display */
.price-display {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 10px 15px;
    border-radius: var(--radius-sm);
    margin: 15px 0;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.price-label {
    font-size: 13px;
    color: #666;
    font-weight: 500;
}

.price-value {
    font-size: 24px;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
}

.price-value small {
    font-size: 12px;
    color: #999;
    font-weight: normal;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 10px;
    margin-top: 15px;
}

.btn-modern {
    flex: 1;
    padding: 10px;
    border: none;
    border-radius: var(--radius-sm);
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    text-decoration: none;
    display: inline-block;
}

.btn-apply {
    background: var(--primary);
    color: white;
    box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
}

.btn-apply:hover {
    background: var(--secondary);
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(67, 97, 238, 0.4);
    color: white;
}

.btn-list {
    background: white;
    color: var(--primary);
    border: 2px solid var(--primary);
}

.btn-list:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-2px);
}

/* Section Title */
.section-title {
    margin: 40px 0 25px;
    position: relative;
}

.section-title h2 {
    font-size: 24px;
    font-weight: 700;
    color: var(--dark);
    margin: 0;
    padding-left: 15px;
    position: relative;
    display: inline-block;
}

.section-title h2:before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 5px;
    background: var(--gradient-1);
    border-radius: 5px;
}

.section-title p {
    color: #666;
    margin: 5px 0 0 15px;
    font-size: 14px;
}

/* Loading Animation */
@keyframes shimmer {
    0% { background-position: -1000px 0; }
    100% { background-position: 1000px 0; }
}

.loading {
    animation: shimmer 2s infinite;
    background: linear-gradient(to right, #eff1f3 4%, #e2e2e2 25%, #eff1f3 36%);
    background-size: 1000px 100%;
}

/* Responsive */
@media (max-width: 768px) {
    .service-grid {
        grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
        gap: 15px;
    }
    
    .stat-number {
        font-size: 24px;
    }
    
    .price-value {
        font-size: 20px;
    }
    
    .service-title {
        font-size: 14px;
    }
}
</style>

<div class="page-wrapper">
    <div class="container-fluid">
<!-- Statistics Cards - User Management -->
<?php if(checkAdmin($udata['type']) == true): 

// Database connection (assuming already connected)
// Calculate statistics from users table
$total_users_query = "SELECT COUNT(*) as total FROM users";
$total_users_result = mysqli_query($conn, $total_users_query);
$total_users = mysqli_fetch_assoc($total_users_result)['total'];

$total_active_query = "SELECT COUNT(*) as total FROM users WHERE status = 'active'";
$total_active_result = mysqli_query($conn, $total_active_query);
$total_active = mysqli_fetch_assoc($total_active_result)['total'];

$total_inactive_query = "SELECT COUNT(*) as total FROM users WHERE status = 'inactive'";
$total_inactive_result = mysqli_query($conn, $total_inactive_query);
$total_inactive = mysqli_fetch_assoc($total_inactive_result)['total'];

$total_suspended_query = "SELECT COUNT(*) as total FROM users WHERE status = 'suspended'";
$total_suspended_result = mysqli_query($conn, $total_suspended_query);
$total_suspended = mysqli_fetch_assoc($total_suspended_result)['total'];

$total_retailer_query = "SELECT COUNT(*) as total FROM users WHERE type = 'retailer'";
$total_retailer_result = mysqli_query($conn, $total_retailer_query);
$total_retailer = mysqli_fetch_assoc($total_retailer_result)['total'];

$total_distributor_query = "SELECT COUNT(*) as total FROM users WHERE type = 'distributor'";
$total_distributor_result = mysqli_query($conn, $total_distributor_query);
$total_distributor = mysqli_fetch_assoc($total_distributor_result)['total'];

$total_balance_query = "SELECT SUM(balance) as total FROM users";
$total_balance_result = mysqli_query($conn, $total_balance_query);
$total_balance = mysqli_fetch_assoc($total_balance_result)['total'] ?? 0;

// Calculate percentages
$active_percent = ($total_users > 0) ? round(($total_active/$total_users)*100, 1) : 0;
$retailer_percent = ($total_users > 0) ? round(($total_retailer/$total_users)*100, 1) : 0;
$distributor_percent = ($total_users > 0) ? round(($total_distributor/$total_users)*100, 1) : 0;
?>

<style>
/* Simple Card CSS */
.stat-row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px 20px -10px;
}

.stat-col {
    width: 25%;
    padding: 0 10px;
    margin-bottom: 20px;
}

.stat-card-simple {
    background: white;
    border-radius: 10px;
    padding: 20px 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    border: 1px solid #f0f0f0;
    transition: all 0.2s ease;
}

.stat-card-simple:hover {
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-color: #e0e0e0;
}

.stat-card-simple a {
    text-decoration: none;
    color: inherit;
    display: block;
}

.stat-label {
    font-size: 13px;
    color: #666;
    margin-bottom: 8px;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.stat-number {
    font-size: 24px;
    font-weight: 600;
    color: #333;
    margin-bottom: 10px;
}

.stat-footer {
    font-size: 12px;
    color: #888;
    border-top: 1px solid #f0f0f0;
    padding-top: 8px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.stat-footer i {
    font-size: 14px;
    color: #999;
}

.stat-footer span {
    color: #4361ee;
    font-weight: 500;
}

.quick-stats {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 15px;
    border: 1px solid #f0f0f0;
}

.quick-stats-title {
    font-size: 14px;
    font-weight: 600;
    color: #333;
    margin-bottom: 15px;
    padding-bottom: 8px;
    border-bottom: 1px solid #e0e0e0;
}

.quick-stat-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    font-size: 13px;
}

.quick-stat-label {
    color: #666;
}

.quick-stat-value {
    color: #333;
    font-weight: 500;
}

/* Responsive */
@media (max-width: 1200px) {
    .stat-col {
        width: 33.333%;
    }
}

@media (max-width: 768px) {
    .stat-col {
        width: 50%;
    }
}

@media (max-width: 480px) {
    .stat-col {
        width: 100%;
    }
}
</style>

<!-- First Row -->
<div class="stat-row">
    <!-- Total Users Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list">
                <div class="stat-label">
                    <i class='bx bx-user' style="margin-right: 5px; color: #4361ee;"></i> Total Users
                </div>
                <div class="stat-number"><?php echo number_format($total_users); ?></div>
                <div class="stat-footer">
                    <span><i class='bx bx-check-circle'></i> <?php echo number_format($total_active); ?> Active</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Total Balance Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_balance.php">
                <div class="stat-label">
                    <i class='bx bx-wallet' style="margin-right: 5px; color: #10b981;"></i> Total Balance
                </div>
                <div class="stat-number">₹<?php echo number_format($total_balance, 2); ?></div>
                <div class="stat-footer">
                    <span><i class='bx bx-trending-up'></i> Wallet Balance</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Active Users Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list?status=active">
                <div class="stat-label">
                    <i class='bx bx-user-check' style="margin-right: 5px; color: #10b981;"></i> Active Users
                </div>
                <div class="stat-number"><?php echo number_format($total_active); ?></div>
                <div class="stat-footer">
                    <span><?php echo $active_percent; ?>% of total</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Pending Users Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list?status=inactive">
                <div class="stat-label">
                    <i class='bx bx-time' style="margin-right: 5px; color: #f59e0b;"></i> Pending Users
                </div>
                <div class="stat-number"><?php echo number_format($total_inactive); ?></div>
                <div class="stat-footer">
                    <span><i class='bx bx-time'></i> Need approval</span>
                </div>
            </a>
        </div>
    </div>
</div>

<!-- Second Row -->
<div class="stat-row">
    <!-- Retailers Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list?type=retailer">
                <div class="stat-label">
                    <i class='bx bx-store' style="margin-right: 5px; color: #8b5cf6;"></i> Total Retailers
                </div>
                <div class="stat-number"><?php echo number_format($total_retailer); ?></div>
                <div class="stat-footer">
                    <span><?php echo $retailer_percent; ?>% of users</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Distributors Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list?type=distributor">
                <div class="stat-label">
                    <i class='bx bx-network-chart' style="margin-right: 5px; color: #ec4899;"></i> Total Distributors
                </div>
                <div class="stat-number"><?php echo number_format($total_distributor); ?></div>
                <div class="stat-footer">
                    <span><?php echo $distributor_percent; ?>% of users</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Suspended Users Card -->
    <div class="stat-col">
        <div class="stat-card-simple">
            <a href="User_list?status=suspended">
                <div class="stat-label">
                    <i class='bx bx-block' style="margin-right: 5px; color: #ef4444;"></i> Suspended Users
                </div>
                <div class="stat-number"><?php echo number_format($total_suspended); ?></div>
                <div class="stat-footer">
                    <span><i class='bx bx-error-circle'></i> Blocked accounts</span>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Quick Stats Card -->
    <div class="stat-col">
        <div class="quick-stats">
            <div class="quick-stats-title">
                <i class='bx bx-stats' style="margin-right: 5px; color: #4361ee;"></i> Quick Stats
            </div>
            <div class="quick-stat-item">
                <span class="quick-stat-label">Active %</span>
                <span class="quick-stat-value"><?php echo $active_percent; ?>%</span>
            </div>
            <div class="quick-stat-item">
                <span class="quick-stat-label">Retailer %</span>
                <span class="quick-stat-value"><?php echo $retailer_percent; ?>%</span>
            </div>
            <div class="quick-stat-item">
                <span class="quick-stat-label">Distributor %</span>
                <span class="quick-stat-value"><?php echo $distributor_percent; ?>%</span>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>

        <!-- Marquee Messages -->
        <div class="marquee-container">
            <marquee class="marquee-text" style="background: var(--gradient-1);" behavior="scroll" scrollamount="8">
                <i class='bx bx-star me-2'></i> <?php echo $message_tag_line1; ?> <i class='bx bx-star ms-2'></i>
            </marquee>
        </div>
        
        <div class="marquee-container">
            <marquee class="marquee-text" style="background: var(--gradient-4); color: #333;" behavior="scroll" scrollamount="8">
                <i class='bx bx-bell me-2'></i> <?php echo $message_tag_line2; ?> <i class='bx bx-bell ms-2'></i>
            </marquee>
        </div>

        <!-- Services Section Title -->
        <div class="section-title">
            <h2>Our Services</h2>
            <p>Choose from our wide range of digital services</p>
        </div>

        <!-- Service Cards Grid -->
        <div class="service-grid">
<?php
// All services data with PRICE array (OLD STYLE)
$services = [
    [
        'title' => 'Pan Find Full Detail By Uid No',
        'price' => $price['pan_find_fee'],  // Old style - direct price array
        'apply' => 'GoodApi_PanFind',
        'list' => 'GoodApi_PanFind_list',
        'type' => 'Instant',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-1',
        'image' => '../assets/images/PanUid.jpeg'
    ],
    [
        'title' => 'Aadhar Pdf { Instant }',
        'price' => $price['uid_pdf_instant_fee'],
        'apply' => 'GoodApi_Instant_UidPdf',
        'list' => 'GoodApi_Instant_UidPdf_list',
        'type' => 'Instant',
        'rating' => 4.8,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/uid_instant.png'
    ],
    [
        'title' => 'Pan Detail Find By PanNo',
        'price' => $price['Pan_detail_fee'],
        'apply' => 'GoodApi_PanDetail',
        'list' => 'GoodApi_PanDetail_list',
        'type' => 'Instant',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-3',
        'image' => '../assets/images/pancard-logo.webp'
    ],
    [
        'title' => 'AgrisFarmers_PDF All State',
        'price' => $price['AgriFarmer_Fee'],
        'apply' => 'AgriFarmerCard.php',
        'list' => null,
        'type' => 'Premium',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-4',
        'image' => 'https://tse4.mm.bing.net/th/id/OIP.BzKrKRJA6i84WqY3PEqgkAAAAA?rs=1&pid=ImgDetMain&o=7&rm=3'
    ],
    [
        'title' => 'DBT Only Bihar',
        'price' => $price['dbt_farmer_fee'],
        'apply' => 'DBTFarmer_PDF.php',
        'list' => null,
        'type' => 'State Specific',
        'rating' => 4.0,
        'gradient' => 'gradient-bg-1',
        'image' => 'https://assets.tractorjunction.com/tractor-junction/blog/2023/09/DBT-in-Agriculture-Harvesting-Benefits-for-Farmers.jpg'
    ],
    [
        'title' => 'Pollution Certificate (Bike)',
        'price' => $price['puc_bike_fee'],
        'apply' => 'puc_certificate.php',
        'list' => 'puc_certificate_list.php',
        'type' => 'Transport',
        'rating' => 4.6,
        'gradient' => 'gradient-bg-2',
        'image' => 'https://sarkariinformation.in/wp-content/uploads/2025/03/Pollution-Certificate-Apply-Online-2025.jpg'
    ],
    [
        'title' => 'Pollution Certificate (Petrol/CNG)',
        'price' => $price['puc_petrol_cng_fee'],
        'apply' => 'puc_certificate.php',
        'list' => 'puc_certificate_list.php',
        'type' => 'Transport',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://sarkariinformation.in/wp-content/uploads/2025/03/Pollution-Certificate-Apply-Online-2025.jpg'
    ],
    [
        'title' => 'Pollution Certificate (Diesel)',
        'price' => $price['puc_diesel_fee'],
        'apply' => 'puc_certificate.php',
        'list' => 'puc_certificate_list.php',
        'type' => 'Transport',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-4',
        'image' => 'https://sarkariinformation.in/wp-content/uploads/2025/03/Pollution-Certificate-Apply-Online-2025.jpg'
    ],
    [
        'title' => 'Pan Advance Print',
        'price' => $price['pan_advance_fee'],
        'apply' => 'Goodapi_Pan_Advance',
        'list' => 'Goodapi_Pan_Advance_list',
        'type' => 'Premium',
        'rating' => 4.7,
        'gradient' => 'gradient-bg-1',
        'image' => '../assets/images/panCard.jpeg'
    ],
    [
        'title' => 'Owner Rc Card Print',
        'price' => $price['Rc_fee'],
        'apply' => 'GoodApi_Rc_Pdf',
        'list' => 'GoodApi_Rc_list',
        'type' => 'Vehicle',
        'rating' => 4.4,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/rc_owner.jpeg'
    ],
    [
        'title' => 'DL NO FIND INSTANT',
        'price' => $price['dl_no_fee'],
        'apply' => 'GoodApi_DlNo_Find_By_NameMobile',
        'list' => null,
        'type' => 'Instant',
        'rating' => 4.9,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://i.ytimg.com/vi/J1DGgD9yJVY/hq720.jpg'
    ],
    [
        'title' => 'Driving Licence Card Print With Chip',
        'price' => $price['dl_fee'],
        'apply' => 'GoodApi_Dlpdf',
        'list' => 'GoodApi_DlPdf_list',
        'type' => 'Premium',
        'rating' => 4.8,
        'gradient' => 'gradient-bg-4',
        'image' => '../assets/images/Dl.jpeg'
    ],
    [
        'title' => 'Driving Licence Print Without Chip',
        'price' => $price['dl_fee'],
        'apply' => 'GoodApi_Dlpdf_2',
        'list' => 'GoodApi_DlPdf_list',
        'type' => 'Standard',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-1',
        'image' => '../assets/images/Dl.jpeg'
    ],
    [
        'title' => 'PAN TO UID S1',
        'price' => $price['pan_aadharNo_fee'],
        'apply' => 'GoodApi_PanToUid_S1',
        'list' => null,
        'type' => 'Verification',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/panCard.jpeg'
    ],
    [
        'title' => 'UID TO NAME S1',
        'price' => $price['uid_to_name_fee'],
        'apply' => 'GoodApi_UidToname',
        'list' => null,
        'type' => 'Verification',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://surepass.io/wp-content/uploads/2025/08/Aadhaar-verification-image-png.png'
    ],
    [
        'title' => 'Pan Manual Print',
        'price' => $price['pan_manual_fee'],
        'apply' => 'Pan_manual',
        'list' => 'Pan_manual_list',
        'type' => 'Manual',
        'rating' => 4.0,
        'gradient' => 'gradient-bg-4',
        'image' => '../assets/images/pan.png'
    ],
    [
        'title' => 'Uid Advance Print',
        'price' => $price['aadhar_adv_fee'],
        'apply' => 'GoodApi_Uid_Print',
        'list' => 'GoodApi_Uid_Print_list',
        'type' => 'Premium',
        'rating' => 4.6,
        'gradient' => 'gradient-bg-1',
        'image' => '../assets/images/uid.png'
    ],
    [
        'title' => 'Aadhar No To Pdf (24 Hour)',
        'price' => $price['aadhaar_no_to_pdf'],
        'apply' => 'AadharNo_to_pdf',
        'list' => 'AadharNo_to_pdf_list',
        'type' => 'Standard',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/uid_instant.png'
    ],
    [
        'title' => 'Matching Duplicate Eid 2 UidNo',
        'price' => $price['eid_to_uid_fee'],
        'apply' => 'GoodApi_Eid_AadharNo',
        'list' => 'GoodApi_Eid_AadharNo_list',
        'type' => 'Verification',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-3',
        'image' => '../assets/images/Uid_finger.jpeg'
    ],
    [
        'title' => 'Aadhar Manual Print',
        'price' => $price['aadhar_manual_fee'],
        'apply' => 'Adhar_manual',
        'list' => 'Adhar_manual_list',
        'type' => 'Manual',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-4',
        'image' => '../assets/images/aadhar.jpeg'
    ],
    [
        'title' => 'Learning Licence PDF',
        'price' => $price['Learning_License_pdf_Fee'],
        'apply' => 'GoodApi_LL_PDF',
        'list' => '#',
        'type' => 'Learning',
        'rating' => 4.4,
        'gradient' => 'gradient-bg-1',
        'image' => 'https://i.ytimg.com/vi/4jlalxs_mgY/maxresdefault.jpg'
    ],
    [
        'title' => 'Learning Licence Exam Pass',
        'price' => $price['ll_fee'],
        'apply' => 'LL_pass',
        'list' => 'list.php',
        'type' => 'Exam',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/Learning_Exam.jpg'
    ],
    [
        'title' => 'Ration To Aadhar No (UP)',
        'price' => $price['ration_aadhar_fee'],
        'apply' => 'GoodApi_rationTouid_up',
        'list' => null,
        'type' => 'Ration',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQy64eGIwYq1OW53EzKk2wa0PAKianBZren3Q&s'
    ],
    [
        'title' => 'Ration Card Print',
        'price' => $price['ration_fee'],
        'apply' => 'GoodApi_RationPdf',
        'list' => 'GoodApi_RationPdf_list',
        'type' => 'Ration',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-4',
        'image' => '../All_image/download.jpeg'
    ],
    [
        'title' => 'Ration Card By Aadhar',
        'price' => $price['ration_pdf_aadhar_fee'],
        'apply' => 'GoodApi_RationPdf_By_UID',
        'list' => 'GoodApi_RationPdf_By_UID_list',
        'type' => 'Ration',
        'rating' => 4.4,
        'gradient' => 'gradient-bg-1',
        'image' => 'https://i.ytimg.com/vi/-r9lbRmqUK0/hq720.jpg'
    ],
    [
        'title' => 'Covid Vaccine Without Batch',
        'price' => $price['covid_1_2_fee'],
        'apply' => 'Covid_without_Batch',
        'list' => 'list.php',
        'type' => 'Health',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-2',
        'image' => '../All_image/Covid.jpg'
    ],
    [
        'title' => 'Covid Vaccine With Batch',
        'price' => $price['covid_batch_fee'],
        'apply' => 'Covid_batch',
        'list' => 'list.php',
        'type' => 'Health',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-3',
        'image' => '../All_image/download.png'
    ],
    [
        'title' => 'Covid All Batch',
        'price' => $price['covid_all_batch_fee'],
        'apply' => 'Covid_batch',
        'list' => 'list.php',
        'type' => 'Health',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-4',
        'image' => '../All_image/download.png'
    ],
    [
        'title' => 'Airtel Payment Bank Passbook',
        'price' => $price['airtel_pass_fee'],
        'apply' => 'Airtel_passbook',
        'list' => 'Airtel_pass_list',
        'type' => 'Bank',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-1',
        'image' => 'https://legend-print-sewa.in/vendors/images/Airtel.jpg'
    ],
    [
        'title' => 'Fino Payment Bank Passbook',
        'price' => $price['fino_pass_fee'],
        'apply' => 'Fino_passbook',
        'list' => 'Fino_pass_list',
        'type' => 'Bank',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-2',
        'image' => 'https://legend-print-sewa.in/vendors/images/FINO.jpg'
    ],
    [
        'title' => 'IPPB Bank Passbook Print',
        'price' => $price['ippb_pass_fee'],
        'apply' => 'Ippb_passbook',
        'list' => 'list.php',
        'type' => 'Bank',
        'rating' => 4.4,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://legend-print-sewa.in/vendors/images/IPPB_LOGO.jpg'
    ],
    [
        'title' => 'Voter Card Advance Print',
        'price' => $price['voter_advance_fee'],
        'apply' => 'GoodApi_Voter_Adv',
        'list' => 'GoodApi_Voter_list',
        'type' => 'Voter',
        'rating' => 4.5,
        'gradient' => 'gradient-bg-4',
        'image' => '../All_image/Voter.jpeg'
    ],
    [
        'title' => 'Voter Card Mobile Update',
        'price' => $price['voter_mobile_fee'],
        'apply' => 'GoodApi_Voter_Mob',
        'list' => 'GoodApi_Voter_Mob_list',
        'type' => 'Voter',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-1',
        'image' => '../All_image/Voter.jpeg'
    ],
    [
        'title' => 'Voter Card Pdf Print',
        'price' => $price['voter_pdf_fee'],
        'apply' => 'GoodApi_Voter_pdf',
        'list' => 'GoodApi_Voter_pdf_list',
        'type' => 'Voter',
        'rating' => 4.4,
        'gradient' => 'gradient-bg-2',
        'image' => '../All_image/Voter.jpeg'
    ],
    [
        'title' => 'Ayushman Card',
        'price' => $price['ayushmna_card_fee'],
        'apply' => 'Ayushman_card.php',
        'list' => null,
        'type' => 'Health',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://ayushman.gov.in/images/logo.png'
    ],
    [
        'title' => 'e-Shram Card',
        'price' => $price['esharm_fee'],
        'apply' => 'GoodApi_eShramDetails',
        'list' => null,
        'type' => 'Government',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-4',
        'image' => 'https://eshram.gov.in/assets/images/logo.png'
    ],
    [
        'title' => 'e-Shram Card Pdf',
        'price' => $price['esharm_fee'],
        'apply' => 'GoodApi_eShramPdf',
        'list' => null,
        'type' => 'Government',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-4',
        'image' => 'https://eshram.gov.in/assets/images/logo.png'
    ],
    [
        'title' => 'UID Mask Pan',
        'price' => $price['uid_mask_pan_fee'],
        'apply' => 'Uid_Mask_Pan.php',
        'list' => null,
        'type' => 'Verification',
        'rating' => 4.3,
        'gradient' => 'gradient-bg-1',
        'image' => '../assets/images/panCard.jpeg'
    ],
    [
        'title' => 'Pan Mask UID',
        'price' => $price['pan_mask_uid_fee'],
        'apply' => 'GoodApi_PanToMaskUid',
        'list' => null,
        'type' => 'Verification',
        'rating' => 4.2,
        'gradient' => 'gradient-bg-2',
        'image' => '../assets/images/uid.png'
    ],
    [
        'title' => 'Vehicle Challan',
        'price' => $price['vehicle_challan_fee'],
        'apply' => 'GoodApi_challan_check',
        'list' => null,
        'type' => 'Transport',
        'rating' => 4.0,
        'gradient' => 'gradient-bg-3',
        'image' => 'https://img.icons8.com/color/480/000000/traffic-jam.png'
    ],
    [
        'title' => 'Bihar RTPS',
        'price' => $price['bihar_rtps_fee'],
        'apply' => 'Bihar_RTPS.php',
        'list' => null,
        'type' => 'Government',
        'rating' => 4.1,
        'gradient' => 'gradient-bg-4',
        'image' => 'https://upload.wikimedia.org/wikipedia/en/thumb/0/06/Emblem_of_Bihar.svg/1200px-Emblem_of_Bihar.svg.png'
    ]
];

// Shuffle for variety (optional)
shuffle($services);

// Display services
$count = 0;
foreach($services as $service): 
    if($count >= 40) break; // Show up to 40 services
    $count++;
    
    // Direct price from array - no need for extra variable
    $service_price = $service['price'];
?>
           <div class="service-card">
    <div class="card-header-gradient <?php echo $service['gradient']; ?>">
        <div class="">
           
        </div>
        <div class="card-icon">
            <!-- Image Tag - यह सही तरीका है -->
            <img src="<?php echo $service['image']; ?>" alt="<?php echo $service['title']; ?>" class="service-img">
        </div>
    </div>
                
                <div class="card-content">
                    <h5 class="service-title"><?php echo $service['title']; ?></h5>
                    
                    <div class="service-meta">
                        <span class="service-type"><?php echo $service['type']; ?></span>
                        <div class="service-rating">
                            <i class='bx bxs-star'></i>
                            <span><?php echo $service['rating']; ?></span>
                        </div>
                    </div>
                    
                    <div class="price-display">
                        <span class="price-label">Service Fee</span>
                        <span class="price-value">₹<?php echo $service['price']; ?><small>/-</small></span>
                    </div>
                    
                    <div class="action-buttons">
                        <a href="<?php echo $service['apply']; ?>" class="btn-modern btn-apply">
                            <i class='bx bx-check-circle me-1'></i> Apply
                        </a>
                        <?php if($service['list']): ?>
                        <a href="<?php echo $service['list']; ?>" class="btn-modern btn-list">
                            <i class='bx bx-list-ul me-1'></i> List
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>

</body>
</html>